; GIMP Script-Fu Mansiki Libs
;Tiny-fu版に変更
(define ( Mansiki-hash ) 
	(gimp-message  "hash lib")
)

;--------------------------------------------------ハッシュ変数の作成
(define ( MSK-newHash ) 
    (list (make-vector 0) (make-vector 0))
)
;--------------------------------------------------ハッシュの要素ListByKey

(define ( MSK-getKeyListFromHash hash) 
    (let* (
            (keys (list ))
        )
        (if (list? hash)
            (begin
                (if (> (MSK-count hash) 0)
                    (begin
                        (set! keys (MSK-getValueByIndex hash 0))
                        (if (vector? keys)
                            (vector->list keys)
                            (begin 
                                (if (list? keys)
                                    keys
                                    (list keys)
                                )
                            )
                        )
                    )
                    keys
                )
            )
            keys
        )
    )
)
;--------------------------------------------------ハッシュの要素ListByValue

(define ( MSK-getValueListFromHash hash) 
    (let* (
            (keys (list ))
        )
        (if (list? hash)
            (begin
                (if (> ( MSK-count hash) 1)
                    (begin
                        (set! keys (MSK-getValueByIndex hash 1))
                        (if (vector? keys)
                            (vector->list keys)
                            (begin 
                                (if (list? keys)
                                    keys
                                    (list keys)
                                )
                            )
                        )
                    )
                    keys
                )
            )
            keys
        )
    )
)
;--------------------------------------------------ハッシュの要素のうむByKey
(define ( MSK-hasKeyOnHash hash key) 
    (let* (
			(hashKeyList ( MSK-getKeyListFromHash hash) )
		)
       (if (> ( MSK-getIndexByValue hashKeyList key) -1 )
            TRUE
            FALSE
        )
    )
)
;--------------------------------------------------ハッシュの要素のうむByValue
(define ( MSK-hasValueOnHash hash value) 
    (let* (
			(hashValueList ( MSK-getValueListFromHash hash) )
		)
       (if (> ( MSK-getIndexByValue hashValueList value) -1 )
            TRUE
            FALSE
        )
    )
)
;--------------------------------------------------ハッシュに要素追加&上書き
(define ( MSK-addElement2Hash hash key value) 
	(let* (
			(hashKeyList ( MSK-getKeyListFromHash hash) )
			(hashValueList ( MSK-getValueListFromHash hash) )
			(keyIndex ( MSK-getIndexByValue hashKeyList key) )
			
		)
		(if(>= keyIndex 0)
            (begin 
                (set! hashValueList (MSK-updateElementAtIndex hashValueList keyIndex value))
                (list (MSK-list2Vector hashKeyList) (MSK-list2Vector hashValueList))
            )
            (begin 
            (list (MSK-list2Vector (MSK-push hashKeyList key)) (MSK-list2Vector (MSK-push hashValueList value)))
            )
        )
    )
)
;--------------------------------------------------ハッシュの要素取得ByKey
(define ( MSK-getValueFromHash hash key) 
    (let* (
			(hashKeyList ( MSK-getKeyListFromHash hash) )
			(hashValueList ( MSK-getValueListFromHash hash) )
            (index (MSK-getIndexByValue hashKeyList key))
		)
		(if (and (number? index) (> index -1))
            (MSK-getValueByIndex hashValueList index)
            ""
        )
    )
)
;--------------------------------------------------ハッシュの要素取得ByValue
(define ( MSK-getKeyFromHash hash value) 
    (let* (
			(hashKeyList ( MSK-getKeyListFromHash hash) )
			(hashValueList ( MSK-getValueListFromHash hash) )
            (index (MSK-getIndexByValue hashValueList value))
		)
		(if (and (number? index) (> index -1))
            (MSK-getValueByIndex hashKeyList index)
            ""
        )
    )
)
;--------------------------------------------------ハッシュの要素削除
(define ( MSK-deleteElementFromHash hash key) 
    (let* (
			(hashKeyList ( MSK-getKeyListFromHash hash) )
			(hashValueList ( MSK-getValueListFromHash hash) )
            (index (MSK-getIndexByValue hashValueList key))
		)
		(if (and (number? index) (> index -1))
		    (begin 
                (list   (MSK-list2Vector ( MSK-deleteElementByIndex hashKeyList index)) 
                        (MSK-list2Vector ( MSK-deleteElementByIndex hashValueList index)))
            )
            hash
        )
    )
)
;--------------------------------------------------ハッシュのソート
(define ( MSK-sortTheHash hash) 
    (let* (
			(hashKeyList ( MSK-getKeyListFromHash hash) )
			(hashValueList ( MSK-getValueListFromHash hash) )
			(newKeyList (list ""))
			(newValueList (list ""))
            (tempKeyList hashKeyList)
            (count 0)
            (len (length hashKeyList))
            (tempIndex 0)
		)
		(set! tempKeyList (MSK-sort tempKeyList))
		
        (while (> len count)
            (begin 
                (set! tempIndex (MSK-getIndexByValue hashKeyList (MSK-getValueByIndex tempKeyList count)))
                (set! newKeyList (MSK-push newKeyList (MSK-getValueByIndex hashKeyList tempIndex)))
                (set! newValueList (MSK-push newValueList (MSK-getValueByIndex hashValueList tempIndex)))
                (set! count (+ count 1))
            )
        ) 
		(list (MSK-list2Vector (MSK-shift newKeyList)) (MSK-list2Vector (MSK-shift newValueList)))
    )
)
;--------------------------------------------------ハッシュの要素数
(define ( MSK-getHashLength hash) 
    (let* (
			(hashKeyList  "")
		)
		(if (> (MSK-isHash hash)0)
            (MSK-count ( MSK-getKeyListFromHash hash)) 
            -1
        )
    )
)

;--------------------------------------------------ハッシュの要素数
(define ( MSK-isHash hash) 
    (let* (
			(hashKeyList (list "") )
		)
		(if (list? hash)
		    (begin
		        (if (eqv? (MSK-count hash) 2)
		            (begin 
		                (if (and (vector? (MSK-getValueByIndex hash 0))(vector? (MSK-getValueByIndex hash 1)))
		                    (begin 
		                        (if (eqv? (vector-length (MSK-getValueByIndex hash 0))(vector-length (MSK-getValueByIndex hash 1)))
		                            TRUE
		                            FALSE
		                        )
		                    )
		                    FALSE
		                )
		            )
		            FALSE
		        )
		    )
		    FALSE
		)
    )
)

;--------------------------------------------------
(script-fu-register "Mansiki-hash"
		    "Mansiki-hash(Lib)"
		    "Mansiki"
		    "name"
		    "copyright"
		    "2008/03/26"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-hash"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
		    
