; GIMP Script-Fu Mansiki Libs

(define ( Mansiki-Char ) 
	(gimp-message  "Char")
	
)
;--------------------------------------------------四捨五入：桁溢れが気になる
(define ( MSK-Char2Num char) 
	(let* (
			(i 0)
			(output 1)
			(truncated 10)
			(powNum 0 )
			(powNumALL  0)
			(level  (- 0 levelInput))
		)

	)
)

;--------------------------------------------------文字を6桁の数値Listに変換
(define (MSK-string2integersArray inputString )
    (let* (
		    (stringlength (MSK-length inputString))
		    (count 0)
		    (integerArray (list ""))
        )
        (while (< count stringlength)
        	(set! integerArray (MSK-push integerArray (MSK-string2integerByIndex inputString count )))
        	(set! count (+ count 1))
        )
	    (MSK-shift integerArray)
	)
)
;--------------------------------------------------文字を6桁の数値文字列に変換マルチバイト対応
(define (MSK-string2integersString inputString )
	(MSK-join (MSK-string2integersArray inputString ) "")
)
;--------------------------------------------------文字を6桁の数値に変換マルチバイト対応
(define (MSK-string2integerByIndex inputString charIndex )
	(MSK-getIntStrAt0Head (char->integer (string-ref inputString charIndex)) 6)
)
;--------------------------------------------------文字を6桁の数値Listに変換マルチバイト対応
(define (MSK-integerString2integerArray inputString )
	(let* (
		    (stringlength (MSK-length inputString))
		    (count 0)
		    (integerArray (list ""))
        )
        (while (< count stringlength)
        	(set! integerArray (MSK-push integerArray (string->number (substring  inputString count (+ count 6)))))
        	(set! count (+ count 6))
        )
	    (MSK-shift integerArray)
	)
)
;--------------------------------------------------文字を6桁の数値Vectorに変換
(define (MSK-integerString2integerVector inputString )
	 ( MSK-list2Vector (MSK-integerString2integerArray inputString ) )
)
;--------------------------------------------------文字を3桁の数値に変換
(define (MSK-integerString2String inputString )
	(let* (
		    (stringlength (MSK-length inputString))
		    (count 0)
		    (integerArray (MSK-integerString2integerArray inputString ) )
		    (iaCount (MSK-count integerArray))
		    (resultString "")
        )
        (while (< count iaCount)
        	(set! resultString (string-append resultString (MSK-integer2char (MSK-getValueByIndex integerArray count)) ))
        	(set! count(+ count 1))
        )
        resultString
 	)
)

;--------------------------------------------------二桁の数値を文字列に変換
(define (MSK-integer2charOld charIndex)
    (let* (     ;   0    1    2    3    4    5    6    7    8    9
             (ctA  '("¥N" "¥1" "¥2" "¥3" "¥d" "¥5" "¥6" "¥7" ""  "¥t"))
             (ctB  '("¥n" ""   ""   "¥r" ""   ""   ""   ""   ""   "" ))
             (ctC  '(""   ""   ""   ""   ""   ""   ""   ""   ""   "" ))
             (ctD  '(""   ""   " "  "!"  "¥" "#"  "$"  "%"  "&"  "'"))
             (ctE  '("("  ")"  "*"  "+"  ","  "-"  "."  "/"  "0"  "1"))
             (ctF  '("2"  "3"  "4"  "5"  "6"  "7"  "8"  "9"  ":"  ";"))
             (ctG  '("<"  "="  ">"  "?"  "@"  "A"  "B"  "C"  "D"  "E"))
             (ctH  '("F"  "G"  "H"  "I"  "J"  "K"  "L"  "M"  "N"  "O"))
             (ctI  '("P"  "Q"  "R"  "S"  "T"  "U"  "V"  "W"  "X"  "Y"))
             (ctJ  '("Z"  "[" "¥¥"  "]"  "^"  "_"  "`"  "a"  "b"  "c"))
             (ctK  '("d"  "e"  "f"  "g"  "h"  "i"  "j"  "k"  "l"  "m"))
             (ctL  '("n"  "o"  "p"  "q"  "r"  "s"  "t"  "u"  "v"  "w"))
             (ctM  '("x"  "y"  "z"  "{"  "|"  "}"  "‾"  "" ""   "" ))
             (characterTable (list ""))
        ) 
        (set! characterTable (append ctA ctB ctC ctD ctE ctF ctG ctH ctI ctJ ctK ctL ctM))
        (if 
                (and 
                    (<= 0 charIndex) 
                    (<= charIndex 127)
                )
                (MSK-getValueByIndex characterTable charIndex)
                (number->string charIndex)
        )
    )
)

;--------------------------------------------------二桁の数値を文字列に変換マルチバイト対応
(define (MSK-integer2char charIndex)
	(list->string (list (integer->char charIndex)))
)
;--------------------------------------------------二桁の数値を文字列に変換マルチバイト対応
(define (MSK-char2String char)
	(list->string (list char))
)
;--------------------------------------------------二桁の数値を文字列に変換マルチバイト対応
(define (MSK-boolean2number boolean)
	(if boolean
		1
		0
	)
)
;--------------------------------------------------二桁の数値を文字列に変換マルチバイト対応
(define (MSK-number2boolean number)
	(if (eqv? number 1)
		#t
		#f
	)
)
;--------------------------------------------------二桁の数値を文字列に変換マルチバイト対応
(define (MSK-string2number input)
	(if (and (string? input)(not (equal? "" input)))
		(string->number input)
		(begin
			(if (equal? "" input)
				0
				(begin
					(if (number? input)
						input
						0
					)
				)
			)
		)
		
	)
)
;--------------------------------------------------
(script-fu-register "Mansiki-Char"
		    "Mansiki-Char(Lib)"
		    "Mansiki"
		    "name"
		    "Rongfu"
		    "2008/06/18"
		    "GPL"
	) 

(script-fu-menu-register "Mansiki-Char"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
