;;Batch file conversion Script-Fuの改良版 http://sourceforge.jp/projects/mansiki/
;;Ronfu
;;05/07/2007
;;This code is under the GPLS

;;Convert a file(s) that match filePathPattern to the type
;;indicated by the ending ext (eg "jpg,png").その改良版

(define (Mansiki-file-convert filePath ext2 ext editSizeFlag imgHsize editResolutionFlag imgDpi opMode )
	(let* (
	        (filePathPattern (string-append filePath "/" ext2))
			(fileCount (car (file-glob filePathPattern 1)))
			(filelist list(""))
			(drawable -1)
		)	;ファイルを読み込む。
		(print filePathPattern )
		(if(> fileCount 0)
		    (begin 
                (set! filelist (cadr (file-glob filePathPattern 1)))
			    (print filelist )
		        (while filelist
			        (let*
				        (
		           			(loadFileName (car filelist))
					        (image (MSK-loadImage loadFileName))
					        (i (- (string-length loadFileName) 1))
					        ( saveName_A loadFileName )
				        )
				        (let* (
						        ;レイヤー数が多い場合はその統合を行う(印刷でわかると思います。pngにするだけでいいんですけど)
						        (layerNum (car (gimp-image-get-layers image)))
						        (mergedLayer (car (gimp-image-get-active-layer image)))
						        (preWidth (car (gimp-image-width image))) 
						        (preHeight (car (gimp-image-height image)))
						        (setHeight 0)
						        (ratio  (/ imgHsize preWidth))
						        (setHeight  (* ratio preHeight))
					        )
					        (if (< 1 layerNum)
						        (set! mergedLayer (car (gimp-image-merge-visible-layers image 1)))
						        (gimp-image-set-active-layer image mergedLayer)
					        )
					        ;-----------------------------------------------------------------
					        (if (and (= opMode 1) (not (equal? ext "jpg")));"MonoTone")
					            (begin 
						            (gimp-image-convert-grayscale image) 
						            (gimp-image-convert-indexed image FS-DITHER MAKE-PALETTE 2 FALSE TRUE "")
						        )
					        )
					
					        (if (and (= opMode 2) (not (equal? ext "jpg")));"Optimaized")
						        (gimp-image-convert-indexed image FS-DITHER MAKE-PALETTE 256 FALSE TRUE "")
					        )
					
					        (if (and (= opMode 3) (not (equal? ext "jpg")));"WebColor")
						        (gimp-image-convert-indexed image FS-DITHER WEB-PALETTE 250 FALSE TRUE "")
					        )
					
					        (if (= opMode 4);"GrayScale")
						        (gimp-image-convert-grayscale image) 
					        )
					        (if (= (car(gimp-drawable-is-rgb mergedLayer)) 1);"RGB")
						        (set! opMode 0)
					        )
					        (if (= opMode 5);"RGB")
						        (gimp-image-convert-rgb image) 
					        )
					        ;-----------------------------------------------------------------
					        (if (= editSizeFlag 1)
					            (begin
						            (gimp-drawable-transform-scale 
						                mergedLayer 0 0 imgHsize setHeight TRANSFORM-FORWARD INTERPOLATION-CUBIC 1 3 0)
						            (gimp-image-resize image imgHsize setHeight 0 0) 
						        )
					        )
					
					        (if (= editResolutionFlag 1)
						        (gimp-image-set-resolution image imgDpi imgDpi) 
					        )
					
					        (if (= editSizeFlag 1)
						        (set! saveName_A (string-append saveName_A (string-append (number->string imgHsize 10) "px")))
					        )
					
					        (if (= editResolutionFlag 1)
						        (set! saveName_A (string-append saveName_A (string-append "_" (number->string imgDpi 10) "dpi")))
					        )
					
					        (set! saveName_A (string-append saveName_A (string-append "." ext)))
				
					        (gimp-file-save RUN-NONINTERACTIVE
					               image
					               mergedLayer
					               saveName_A
					               saveName_A)
					        (gimp-image-delete image)
					        (print (string-append saveName_A "\n") )
				        )
			        )
			        (set! filelist (cdr filelist))
		        )
		    )
		    (begin 
		        (gimp-message  (string-append filePathPattern "のファイルは見つかりませんでした。" ))
		    )
		)
	)
)

(script-fu-register "Mansiki-file-convert"
		    "FileComvert..."
		    "file-convertの改変版です。ファイル変換を行います。ファイル名のワイルドカードの指定できます。"
		    "Ronfu"
		    "GPL"
		    "05/07/2007"
		    ""
		    SF-DIRNAME _"Pattern/Path to file(s)" "~/"
		    SF-STRING _"Convert from(ファイル名)" "*.xcf"
		    SF-STRING _"Convert to(拡張子を指定)" "jpg"
			SF-TOGGLE     _"縦横サイズ変更を行う"	TRUE
			SF-VALUE      _"画像幅 (ピクセル)"  "300"
			SF-TOGGLE     _"印刷解像度設定を行う"	TRUE
			SF-VALUE      _"解像度（dpi）"  "600"
			SF-OPTION     _"画像モード"    '(_"変更なし"
											_"MonoTone"
											_"GrayScale"
											_"WebColor"
											_"Optimaized"
											_"RGB")
)

(script-fu-menu-register "Mansiki-file-convert"
		    "<Toolbox>/Xtns/Script-Fu/Mansiki")
