/*
 * Copyright (c)  2006-2011 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.rialto.CheckboxWrapper")
	.extend("maskat.widget.rialto.RialtoWidgetWrapper", {

	defaultGetter: "isChecked",

	defaultSetter: "setChecked",
	
    createWidget: function(parent) {
    	var checkbox = new rialto.widget.Checkbox(
            this.name,
            this.top,
            this.left,
            null, /* parent */
            this.text,
            this.checked,
			this.className);
		checkbox.setEnable(this.enable);

		var self = this;
		checkbox.onclick = function() { self.notifyEvent("onclick", arguments); };

		this.widget = checkbox;
		return checkbox;
    },

	getControlElement: function() {
		return this.widget.checkbox;
	},

	isChecked: function() {
		return this.widget.isCheck();
	},

	setChecked: function(value) {
		if (value == "true") {
			this.widget.setCheck(true);
		} else if (value == "false") {
			this.widget.setCheck(false);
		}
	},
	
	clear: function() {
		this.widget.setCheck(false);
	},

    postCreateWidget: function() {
		this.widget.divExt.tabIndex = this.getTabIndex();
    },

	handleKeyEvent: function(event) {
		if (event.keyCode == 13 || event.keyCode == 32) {
			this.widget.setCheck(!this.widget.isCheck());
			this.setFocus();
			return false;
		}
		return true;
	},
	
	setFocus: function() {
		this.widget.divExt.focus();
	}
});
