#include "stdafx.h"
#include "Configuration.h"

#include <shlobj.h>

class __declspec(uuid("{C132E8CE-DB3F-4aa9-884A-82334BC39CBF}")) CConfStrage
	: public IConfStrage
	, public CComObjectRoot
	, public CComCoClass<CConfStrage, &__uuidof(CConfStrage)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage ConfStrage Object")

	BEGIN_COM_MAP(CConfStrage)
		COM_INTERFACE_ENTRY(IConfStrage)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		if ( !::SHGetSpecialFolderPath(NULL, szPath_, CSIDL_LOCAL_APPDATA, TRUE)) {
			return AtlHresultFromWin32(ERROR_PATH_NOT_FOUND);
		}

		if ( _tcscat_s(szPath_, MAX_PATH, _TEXT("\\MkImgPage"))) {
			return AtlHresultFromWin32(ERROR_PATH_NOT_FOUND);
		}

		::SHCreateDirectory(NULL, szPath_);

		DWORD attr = ::GetFileAttributes(szPath_);
		if (attr == -1 || !(attr & FILE_ATTRIBUTE_DIRECTORY)) {
			return AtlHresultFromWin32(ERROR_PATH_NOT_FOUND);
		}

		if ( _tcscat_s(szPath_, MAX_PATH, _TEXT("\\MkImgPage.ini"))) {
			return AtlHresultFromWin32(ERROR_PATH_NOT_FOUND);
		}

		return S_OK;
	}

	void FinalRelease() throw()
	{
	}

	virtual HRESULT __stdcall GetDWORD(LPCWSTR v_name, DWORD v_default, DWORD* v_pValue) throw()
	{
		if ( !v_name) {
			return E_FAIL;
		}

		*v_pValue = ::GetPrivateProfileInt(APPNAME, CW2T(v_name), v_default, szPath_);
		return S_OK;
	}

	virtual HRESULT __stdcall WriteDWORD(LPCWSTR v_name, DWORD v_value) throw()
	{
		if ( !v_name) {
			return E_FAIL;
		}

		CString tmp;
		tmp.Format(_TEXT("%d"), v_value);
		if ( !::WritePrivateProfileString(APPNAME, CW2T(v_name), tmp, szPath_)) {
			return AtlHresultFromLastError();
		}
		return S_OK;
	}

	virtual HRESULT __stdcall GetString(LPCWSTR v_name, LPCWSTR v_default, BSTR* v_pValue) throw()
	{
		if ( !v_name) {
			return E_FAIL;
		}
		if ( !v_pValue) {
			return E_POINTER;
		}
		if ( !v_default) {
			v_default = _TEXT("");
		}
		ATLASSERT(*v_pValue == NULL);

		TCHAR buf[MAX_PATH * 2];
		::GetPrivateProfileString(APPNAME, CW2T(v_name),
				CW2T(v_default), buf, MAX_PATH * 2, szPath_);
		*v_pValue = ::SysAllocString(CT2W(buf));
		return S_OK;
	}

	virtual HRESULT __stdcall WriteString(LPCWSTR v_name, LPCWSTR v_pValue) throw()
	{
		if ( !v_name) {
			return E_FAIL;
		}
		if ( !v_pValue) {
			v_pValue = _TEXT("");
		}

		if( !::WritePrivateProfileString(APPNAME, CW2T(v_name), CW2T(v_pValue), szPath_)) {
			return AtlHresultFromLastError();
		}
		return S_OK;
	}

private:

	static LPCTSTR APPNAME;

	TCHAR szPath_[MAX_PATH];
};

LPCWSTR CConfStrage::APPNAME = _TEXT("MkImgPage");

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CConfStrage), CConfStrage);


HRESULT __stdcall GetConfStrage(IConfStrage** v_ppConfStrage) throw()
{
	return CConfStrage::CreateInstance(v_ppConfStrage);
}

HRESULT __stdcall GetModuleDirectory(HINSTANCE v_hInst, BSTR* v_pBaseDir) throw()
{
	if ( !v_pBaseDir) {
		ATLASSERT(false);
		return E_POINTER;
	}

	ATLASSERT(!*v_pBaseDir);

	try {
		TCHAR szFilePath[MAX_PATH];
		DWORD dwFLen = ::GetModuleFileName(v_hInst, szFilePath, MAX_PATH);
		if( dwFLen == 0 || dwFLen == MAX_PATH ) {
			// W[̃pX̎擾Ɏs
			return E_FAIL;
		}

		LPTSTR p = szFilePath;
		while (*p) p++;
		for(;;) {
			if (*p == '\\') {
				*p = 0;
				break;
			}
			if (p <= szFilePath) {
				// tH_؂肪ǂɂȂB
				break;
			}
			p = CharPrev(szFilePath, p);
		}

		CString path(szFilePath);
		path += _TEXT("\\");

		CComBSTR tmp(path);
		*v_pBaseDir = tmp.Detach();
		return S_OK;
	}
	catch (...) {
		return E_FAIL;
	}
}
