#include "stdafx.h"
#include "FileCreator.h"

class __declspec(uuid("{DF381145-69E1-4676-A35D-0CE6E048A2F8}")) CTempFileCreator
	: public IFileCreator
	, public CComObjectRoot
	, public CComCoClass<CTempFileCreator, &__uuidof(CTempFileCreator)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage Temporary File Creator Object")

	BEGIN_COM_MAP(CTempFileCreator)
		COM_INTERFACE_ENTRY(IFileCreator)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		size_t sz = MAX_PATH;
		for(;;) {
			temp_.SetCount(sz);
			DWORD ret = ::GetTempPath(MAX_PATH, temp_.GetData());
			if (ret == 0) {
				return E_FAIL;
			}
			if (ret > MAX_PATH) {
				sz = ret;
				continue;
			}
			return S_OK;
		}
	}

	void FinalRelease() throw()
	{
		POSITION pos = autoDels_.GetHeadPosition();
		while (pos != NULL) {
			const CComBSTR& path = autoDels_.GetNext(pos);
			::DeleteFile(CW2T(path));
		}
	}

	virtual HRESULT __stdcall Create(IFileName** v_ppFileStream) throw()
	{
		try {
			CComBSTR path;
			int retry = 0;
			for(;;) {
				SYSTEMTIME systime = {0};
				::GetLocalTime(&systime);
				CString tempFileName;
				tempFileName.Format(
					_TEXT("%smkimgpage-%04d%02d%02d%02d%02d%02d-%04d-%02d.htm"),
					temp_.GetData(),
					systime.wYear,
					systime.wMonth,
					systime.wDay,
					systime.wHour,
					systime.wMinute,
					systime.wSecond,
					systime.wMilliseconds,
					retry
					);
				HANDLE hTempFile = ::CreateFile(
					tempFileName,
					GENERIC_WRITE,
					FILE_SHARE_WRITE | FILE_SHARE_READ,
					NULL,
					CREATE_NEW,
					FILE_ATTRIBUTE_NORMAL,
					NULL
					);
				if (hTempFile != INVALID_HANDLE_VALUE) {
					::CloseHandle(hTempFile);
					path = tempFileName;
					break;
				}
				retry++;
				if (retry >= MAX_RETRY) {
					return AtlHresultFromWin32(ERROR_FILE_NOT_FOUND);
				}
			}

			// 폜Xgɒǉ
			autoDels_.AddTail(path);

			return CreateFileStream(path, v_ppFileStream);
		}
		catch (...) {
			return E_FAIL;
		}
	}

private:

	static const int MAX_RETRY = 20;
	
	CAtlArray<TCHAR> temp_;
	
	CAtlList<CComBSTR> autoDels_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CTempFileCreator), CTempFileCreator);


HRESULT __stdcall GetTempFileCreator(IFileCreator** v_ppFileCreator) throw()
{
	return CTempFileCreator::CreateInstance(v_ppFileCreator);
}


/////////////////////////////////////////////////////

class __declspec(uuid("{07DAFD65-CBBA-46cc-AAEE-6994DC8CB41A}")) CFileName
	: public IFileName
	, public CComObjectRoot
	, public CComCoClass<CFileName, &__uuidof(CFileName)>
{
public:
	BEGIN_COM_MAP(CFileName)
		COM_INTERFACE_ENTRY(IFileName)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT Init(LPCWSTR v_path) throw()
	{
		if ( !v_path) {
			return E_POINTER;
		}
		try {
			path_ = v_path;

			return SHCreateStreamOnFile(
				path_,
				STGM_READWRITE | STGM_SHARE_DENY_NONE | STGM_CREATE,
				&pStream_
				);
		}
		catch (...) {
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall get_Path(BSTR* v_pPath) throw()
	{
		if ( !v_pPath) {
			return E_POINTER;
		}
		return path_.CopyTo(v_pPath);
	}

	virtual HRESULT __stdcall GetStream(IStream** v_ppStream) throw()
	{
		return pStream_.QueryInterface(v_ppStream);
	}

protected:

	CComBSTR path_;

	CComPtr<IStream> pStream_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CFileName), CFileName)


HRESULT __stdcall CreateFileStream(LPCWSTR v_pPath, IFileName** v_ppFileName) throw()
{
	if ( !v_pPath) {
		return E_INVALIDARG;
	}
	if ( !v_ppFileName) {
		return E_POINTER;
	}

	HRESULT hr;

	CComObject<CFileName> *pFileNameImpl = NULL;
	hr = CComObject<CFileName>::CreateInstance(&pFileNameImpl);
	if (FAILED(hr)) {
		return hr;
	}
	CComPtr<IFileName> pFileName(pFileNameImpl);

	hr = pFileNameImpl->Init(v_pPath);
	if (FAILED(hr)) {
		return hr;
	}

	*v_ppFileName = pFileName.Detach();
	return S_OK;
}

