#include "stdafx.h"

#include "StreamWriter.h"

class __declspec(uuid("{1B5CCF87-EA59-4f79-B06D-8504ACD418C8}")) CStreamWriter
	: public IStreamWriter
	, public CComObjectRoot
	, public CComCoClass<CStreamWriter, &__uuidof(CStreamWriter)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage Setting Object")

	BEGIN_COM_MAP(CStreamWriter)
		COM_INTERFACE_ENTRY(IStreamWriter)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	///

	HRESULT Init(IStream* v_pStm) throw()
	{
		if ( !v_pStm) {
			return E_POINTER;
		}
		try {
			pStm_ = v_pStm;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall Write(LPCWSTR v_pValue) throw()
	{
		ATLASSERT(pStm_);

		if ( !v_pValue) {
			return S_FALSE;
		}

		try {
			// UTF-16UTF-8ɕϊꍇ̃obt@TCY߂
			const int requireLen = WideCharToMultiByte(CP_UTF8, 0, v_pValue, -1,
													   NULL, 0, NULL, NULL);
			if ( !requireLen) {
				return AtlHresultFromLastError();
			}
			
			// BSTRɃoCïmۂ
			CComBSTR guard;
			BSTR buf = SysAllocStringByteLen(NULL, requireLen);
			if ( !buf) {
				return E_OUTOFMEMORY;
			}
			guard.Attach(buf);

			// UTF-16UTF-8֕ϊ
			LPSTR pByteBuf = reinterpret_cast<LPSTR>(buf);

			if ( !WideCharToMultiByte(CP_UTF8, 0, v_pValue, -1,
									  pByteBuf, requireLen, NULL, NULL)) {
				return AtlHresultFromLastError();
			}

			// Xg[ւ̏
			HRESULT hr;
			ULONG wd = 0;
			hr = pStm_->Write(pByteBuf, requireLen - 1, &wd);
			if (FAILED(hr)) {
				return hr;
			}
			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

protected:

	CComPtr<IStream> pStm_;

};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CStreamWriter), CStreamWriter);


HRESULT __stdcall CreateStreamWriter(IStream* v_pStm,
									 IStreamWriter** v_ppWriter) throw()
{
	if ( !v_pStm) {
		return E_INVALIDARG;
	}
	if ( !v_ppWriter) {
		return E_POINTER;
	}

	HRESULT hr;
	CComObject<CStreamWriter> *pWriterImpl = NULL;
	hr = CComObject<CStreamWriter>::CreateInstance(&pWriterImpl);
	if (FAILED(hr)) {
		return hr;
	}
	CComPtr<IStreamWriter> pWriter(pWriterImpl);

	hr = pWriterImpl->Init(v_pStm);
	if (FAILED(hr)) {
		return hr;
	}

	return pWriter.CopyTo(v_ppWriter);
}
