#include "stdafx.h"

#include "ScriptObject.h"

class __declspec(uuid("{57C7C3D7-7A4B-42d9-A6A4-88DF6C213233}")) CScriptObject
	: public CComObjectRoot
	, public CComCoClass<CScriptObject, &__uuidof(CScriptObject)>
	, public IScriptObject
{
public:
	DECLARE_OBJECT_DESCRIPTION("CScriptObject")

	BEGIN_COM_MAP(CScriptObject)
		COM_INTERFACE_ENTRY(IScriptObject)
		COM_INTERFACE_ENTRY(IDispatch)
	END_COM_MAP()

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()
	DECLARE_PROTECT_FINAL_CONSTRUCT()

	// DISPID̃Xg
	enum {
		// item\bhDISPID (0)
		SCROBJ_DISPID_ITEM = DISPID_VALUE,

		// lengthvpeBDISPID (1)
		SCROBJ_DISPID_LENGTH = 1,

		// o^\ȃvpeB̊Jnԍ
		SCROBJ_DISPID_PROPERTIES = 2 
	};

	HRESULT FinalConstruct(void) throw()
	{
		try {
			names_.Add(L"item");   // 0 = SCROBJ_DISPID_ITEM
			names_.Add(L"length"); // 1 = SCROBJ_DISPID_LENGTH
		}
		catch (...) {
			return E_OUTOFMEMORY;
		}
		return S_OK;
	}

	//// IDispatch ////

    virtual HRESULT STDMETHODCALLTYPE GetTypeInfoCount( 
        /* [out] */ __RPC__out UINT *pctinfo) throw()
	{
		if ( !pctinfo) {
			return E_POINTER;
		}
		*pctinfo = 0;
		return S_OK;
	}
    
    virtual HRESULT STDMETHODCALLTYPE GetTypeInfo( 
        /* [in] */ UINT iTInfo,
        /* [in] */ LCID lcid,
        /* [out] */ __RPC__deref_out_opt ITypeInfo **ppTInfo) throw()
	{
		return TYPE_E_ELEMENTNOTFOUND;
	}
    
    virtual HRESULT STDMETHODCALLTYPE GetIDsOfNames( 
        /* [in] */ __RPC__in REFIID riid,
        /* [size_is][in] */ __RPC__in_ecount_full(cNames) LPOLESTR *rgszNames,
        /* [range][in] */ UINT cNames,
        /* [in] */ LCID lcid,
        /* [size_is][out] */ __RPC__out_ecount_full(cNames) DISPID *rgDispId) throw()
	{
		if ( !rgDispId) {
			return E_POINTER;
		}
		try {
			UINT found = 0;
			for (UINT arg = 0; arg < cNames; arg++) {
				CAtlStringW name(rgszNames[arg]);
				size_t len = names_.GetCount();
				DISPID dispId = DISPID_UNKNOWN;
				for (size_t idx = 0; idx < len; idx++) {
					if (name.CompareNoCase(names_[idx]) == 0) {
						dispId = static_cast<DISPID>(idx);
						found++;
						break;
					}
				}
				rgDispId[arg] = dispId;
			}

			return (found == cNames) ? S_OK : DISP_E_UNKNOWNNAME;
		}
		catch (...) {
			return E_FAIL;
		}
	}
    
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Invoke( 
        /* [in] */ DISPID dispIdMember,
        /* [in] */ REFIID riid,
        /* [in] */ LCID lcid,
        /* [in] */ WORD wFlags,
        /* [out][in] */ DISPPARAMS *pDispParams,
        /* [out] */ VARIANT *pVarResult,
        /* [out] */ EXCEPINFO *pExcepInfo,
        /* [out] */ UINT *puArgErr) throw()
	{
		// item\bh
		if (dispIdMember == SCROBJ_DISPID_ITEM) {
			if (wFlags & DISPATCH_METHOD || wFlags & DISPATCH_PROPERTYGET) {
				// get_Item
				if (pDispParams && pDispParams->cArgs == 1) {
					// 1
					if ( !pVarResult) {
						// ߂lȂ = ȂɂȂ
						return S_OK;
					}
					return get_item(pDispParams->rgvarg[0], pVarResult);
				}
				else if (pDispParams && pDispParams->cArgs == 2) {
					// 2
					return put_item(pDispParams->rgvarg[1], pDispParams->rgvarg[0]);
				}
			}
		}
		// lengthvpeB
		else if (dispIdMember == SCROBJ_DISPID_LENGTH) {
			if (wFlags & DISPATCH_METHOD || wFlags & DISPATCH_PROPERTYGET) {
				// get_Item
				if ( !pDispParams || pDispParams->cArgs == 0) {
					// ͂ƂȂ
					if ( !pVarResult) {
						// ߂lȂ = ȂɂȂ
						return S_OK;
					}
					long length;
					HRESULT hr = get_length(&length);
					if (FAILED(hr)) {
						return hr;
					}
					CComVariant varLength(length);
					return varLength.Detach(pVarResult);
				}
			}
		}
		else if(dispIdMember == DISPID_NEWENUM) {
			if ( !pDispParams || pDispParams->cArgs == 0) {
				// ͂ƂȂ
				if ( !pVarResult) {
					// ߂lȂ = ȂɂȂ
					return S_OK;
				}
				HRESULT hr;
				CComPtr<IUnknown> pUnk;
				hr = get__newEnum(&pUnk);
				if (FAILED(hr)) {
					return hr;
				}
				pVarResult->vt = VT_UNKNOWN;
				pVarResult->punkVal = pUnk.Detach();
				return S_OK;
			}
		}
		else {
			// ȊO͓IȃvpeB
			ATLASSERT(dispIdMember >= SCROBJ_DISPID_PROPERTIES);
			HRESULT hr;
			CComVariant varIndex;
			hr = FindName(dispIdMember, &varIndex);
			if (FAILED(hr)) {
				return hr;
			}

			if (wFlags & DISPATCH_METHOD || wFlags & DISPATCH_PROPERTYGET) {
				if ( !pDispParams || pDispParams->cArgs == 0) {
					// Ȃ
					if ( !pVarResult) {
						// ߂lȂ = ȂɂȂ
						return S_OK;
					}
					return get_item(varIndex, pVarResult);
				}
			}
			else if (wFlags & DISPATCH_PROPERTYPUT) { // REF͎󂯎Ȃ
				if (pDispParams && pDispParams->cArgs == 1) {
					// 1
					return put_item(varIndex, pDispParams->rgvarg[0]);
				}
			}
		}
		return DISP_E_MEMBERNOTFOUND;
	}

	//// IScriptObject ////

	virtual HRESULT __stdcall get_length(long *v_pLength) throw()
	{
		if ( !v_pLength) {
			return E_POINTER;
		}
		// item\bhlengthvpeB̕o^ς݃ACeԂ
		*v_pLength = static_cast<long>(names_.GetCount() - 2);
		return S_OK;
	}

	virtual HRESULT __stdcall get_item(VARIANT varIndex, VARIANT *v_pValue) throw()
	{
		CComVariant value;

		HRESULT hr;
		DISPID dispId;

		hr = FindIndex(varIndex, &dispId, true);
		if (FAILED(hr)) {
			return hr;
		}
		if (hr == S_OK) {
			if (dispId == 0 || dispId == 1) {
				// ύXs\ȗvf
				ATLASSERT(false);
				return E_FAIL;
			}
			CAtlMap<DISPID, CComVariant>::CPair* ret = values_.Lookup(dispId);
			if (ret != NULL) {
				value = ret->m_value;
			}
		}

		return value.Detach(v_pValue);
	}

	virtual HRESULT __stdcall put_item(VARIANT varIndex, VARIANT v_value) throw()
	{
		HRESULT hr;
		DISPID dispId;

		hr = FindIndex(varIndex, &dispId, true);
		if (FAILED(hr)) {
			return hr;
		}
		ATLASSERT(hr == S_OK);

		if (dispId == 0 || dispId == 1) {
			// ύXs\ȗvf
			ATLASSERT(false);
			return E_FAIL;
		}

		try {
			values_.SetAt(dispId, v_value);
		}
		catch (...) {
			return E_OUTOFMEMORY;
		}

		return S_OK;
	}

	virtual HRESULT __stdcall get__newEnum(IUnknown **v_pEnum) throw()
	{
		if ( !v_pEnum) {
			return E_POINTER;
		}

		try {
			*v_pEnum = new CEnumNames(this);
		}
		catch (...) {
			return E_FAIL;
		}
		
		return S_OK;
	}

protected:

	friend class CEnumNames;

	class CEnumNames
		: public IEnumVARIANT
	{
	public:

		CEnumNames(CScriptObject* v_pParent) throw()
			: pParent_(v_pParent)
			, refCount_(1)
			, index_(SCROBJ_DISPID_PROPERTIES) // item\bhlengthvpeB͗񋓂̑ΏۊO
		{
			pParent_->AddRef();
		}

        virtual HRESULT __stdcall QueryInterface( 
            /* [in] */ REFIID riid,
            /* [iid_is][out] */ void** ppvObject) throw()
		{
			if ( !ppvObject) {
				return E_POINTER;
			}
			if (IsEqualIID(riid, __uuidof(IUnknown)) ||
				IsEqualIID(riid, __uuidof(IEnumVARIANT))) {
				*ppvObject = this;
				refCount_++;
				return S_OK;
			}
			return E_NOINTERFACE;
		}

        virtual ULONG __stdcall AddRef(void) throw()
		{
			return ++refCount_;
		}

        virtual ULONG __stdcall Release(void) throw()
		{
			ULONG cnt = --refCount_;
			if (cnt == 0) {
				delete this;
			}
			return cnt;
		}

		virtual HRESULT __stdcall Next(ULONG v_celt,
			VARIANT* v_rgVar, ULONG* v_pCeltFetched) throw()
		{
			if ( !v_rgVar) {
				return E_INVALIDARG;
			}
			if (v_pCeltFetched) {
				*v_pCeltFetched = 0;
			}

			try {
				for (ULONG loop = 0; loop < v_celt; loop++) {
					VariantInit(&v_rgVar[loop]);
				}
			}
			catch (...) {
				return E_FAIL;
			}

			try {
				ULONG len = static_cast<ULONG>(pParent_->names_.GetCount());

				ULONG fetched = 0;
				for (ULONG loop = 0; loop < v_celt; ++loop) {
					if (index_ >= len) {
						break;
					}

					CComBSTR name(pParent_->names_[index_]);

					v_rgVar[loop].vt = VT_BSTR;
					v_rgVar[loop].bstrVal = name.Detach();

					fetched += 1;
					index_ += 1;
				}

				if (v_pCeltFetched) {
					*v_pCeltFetched = fetched;
				}

				return fetched == v_celt ? S_OK : S_FALSE;
			}
			catch (...) {
				for (ULONG loop = 0; loop < v_celt; loop++) {
					VariantClear(&v_rgVar[loop]);
				}
				return E_FAIL;
			}
		}
        
        virtual HRESULT __stdcall Skip(ULONG v_celt) throw()
		{
			ULONG len = static_cast<ULONG>(pParent_->names_.GetCount());

			index_ += v_celt;

			if (index_ >= len) {
				index_ = len;
				return S_FALSE;
			}

			return S_OK;
		}
        
        virtual HRESULT __stdcall Reset(void) throw()
		{
			index_ = SCROBJ_DISPID_PROPERTIES;
			return S_OK;
		}
        
        virtual HRESULT __stdcall Clone( 
            /* [out] */ IEnumVARIANT** ppEnum) throw()
		{
			if ( !ppEnum) {
				return E_POINTER;
			}
			try {
				*ppEnum = new CEnumNames(*this);
				return S_OK;
			}
			catch (...) {
				return E_OUTOFMEMORY;
			}
		}

	protected:

		CEnumNames(const CEnumNames& v_src)
			: pParent_(v_src.pParent_)
			, refCount_(1)
			, index_(v_src.index_)
		{
			pParent_->AddRef();
		}

		virtual ~CEnumNames() throw()
		{
			pParent_->Release();
		}

		CScriptObject* pParent_;

		ULONG refCount_;

		size_t index_;
	};

	HRESULT FindName(DISPID v_dispId, VARIANT* v_pVarIndex) throw()
	{
		if ( !v_pVarIndex) {
			return E_POINTER;
		}
		LONG len = static_cast<LONG>(names_.GetCount()); // DISPIDLONG̕ʖ̂
		if (v_dispId < 0 || v_dispId >= len) {
			// ͈͊O
			return DISP_E_MEMBERNOTFOUND;
		}
		CAtlStringW& name = names_[v_dispId];
		CComVariant varIndex(name);
		return varIndex.Detach(v_pVarIndex);
	}

	HRESULT FindIndex(VARIANT& varIndex, DISPID* v_pIndex, bool v_create) throw()
	{
		if ( !v_pIndex) {
			return E_POINTER;
		}
		try {
			*v_pIndex = DISPID_UNKNOWN;

			HRESULT hr;

			// ƂĎ擾
			CComVariant index;
			hr = index.ChangeType(VT_BSTR, &varIndex);
			if (FAILED(hr)) {
				return hr;
			}

			// 
			size_t len = names_.GetCount();
			for (size_t idx = 0; idx < len; idx++) {
				if (names_[idx].CompareNoCase(index.bstrVal) == 0) {
					*v_pIndex = static_cast<DISPID>(idx);
					return S_OK;
				}
			}

			// ݂Ȃꍇ͒ǉ
			if (v_create) {
				size_t idx = names_.Add(index.bstrVal);
				*v_pIndex = static_cast<DISPID>(idx);
				return S_OK;
			}

			return S_FALSE;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	CAtlArray<CAtlStringW> names_;

	CAtlMap<DISPID, CComVariant> values_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CScriptObject), CScriptObject)


HRESULT __stdcall CreateScriptObject(IScriptObject** v_ppScriptObject) throw()
{
	return CScriptObject::CreateInstance(v_ppScriptObject);
}
