/*
    Melody maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __FILE_H__
#define __FILE_H__


#include "mmaid.h"


G_BEGIN_DECLS


#define FILE_KIND_ERROR    0
#define FILE_KIND_UNKNOWN  1
#define FILE_KIND_TAG      2
#define FILE_KIND_DB       3
#define FILE_KIND_LIST     4


#define FILE_SAVE_SUCCESS          0
#define FILE_SAVE_ERRROR           1
#define FILE_SAVE_CHARSET_TITLE    2
#define FILE_SAVE_CHARSET_ARTIST   3
#define FILE_SAVE_CHARSET_ALBUM    4
#define FILE_SAVE_CHARSET_YEAR     5
#define FILE_SAVE_CHARSET_COMMENT  6
#define FILE_SAVE_LENGTH_TITLE     7
#define FILE_SAVE_LENGTH_ARTIST    8
#define FILE_SAVE_LENGTH_ALBUM     9
#define FILE_SAVE_LENGTH_YEAR     10
#define FILE_SAVE_LENGTH_COMMENT  11


/******************************************************************************
*                                                                             *
* ファイル入力関数群                                                          *
*                                                                             *
******************************************************************************/
/*  ja:ファイルの種類を取得する
    file,ファイル名
     RET,FILE_KIND_TAG:ID3TAG,FILE_KIND_DB:db,FILE_KIND_LIST:プレイリスト   */
guint
file_is_type (const gchar *file);


/*  ja:dbファイルを開く
        file,ファイル名
    charlist,キャラクターセットリスト
         RET,タグ                                                           */
ID3Tag *
file_open_id3tag (const gchar *file,
                  const gchar *charlist);


/*  ja:dbファイルを開く
     file,ファイル名
    mmaid,ウインドウ情報                                                    */
void
file_open_db (const gchar *file,
              MmaidWindow *mmaid);


/*  ja:プレイリストを開く
     file,ファイル名
    mmaid,ウインドウ情報                                                    */
void
file_open_list (const gchar *file,
                MmaidWindow *mmaid);


/*  ja:ファイルを開く
    file,ファイル名
     RET,ウインドウ情報                                                     */
MmaidWindow *
file_open_edit (const gchar *file);


/******************************************************************************
*                                                                             *
* ja:ファイル出力関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:mp3ファイルを保存する
      file,ファイル名
    id3tag,タグ
      gnum,ジャンル
       RET,エラーコード                                                     */
gint
file_save_id3tag (const gchar  *file,
                  const ID3Tag *id3tag,
                  const gint    gnum);


/*  ja:dbファイルを保存する
       file,ファイル名
      mmaid,ウインドウ情報
       root,ルート
    charset,キャラクターセット
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
file_save_db (const gchar *file,
              MmaidWindow *mmaid,
              const gchar *root,
              const gchar *charset);


/*  ja:プレイリストを保存する
        file,ファイル名
       mmaid,ウインドウ情報
        root,ルート
     charset,キャラクターセット
    playlist.プレイリスト(0:相対,1:絶対,2:名前)
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
file_save_list (const gchar *file,
                MmaidWindow *mmaid,
                const gchar *root,
                const gchar *charset,
                const gint   playlist);


G_END_DECLS


#endif /* __FILE_H__ */
