/*
    Melody maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "command.h"
#include "file.h"
#include "general.h"
#include "menu.h"
#include "mm_list.h"
#include "sigfile.h"
#include "misc/fileio.h"
#include "misc/misc.h"
#include "orz/orzmdi.h"


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(マウス)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_button_press (GtkWidget      *widget,
                     GdkEventButton *event,
                     MmaidWindow    *mmaid)
{
  if (event->type == GDK_BUTTON_PRESS && event->button == 3)
    {
      gboolean arrow_select = FALSE;
      gint i, n, c;

      mm_list_get_cursor_from_pos (MM_LIST (mmaid->list),
                                    (gint)event->x, (gint)event->y, &n, &c);
      if (n >= 0)
        mm_list_set_cursor (MM_LIST (mmaid->list), n, c);
      mm_list_get_cursor (MM_LIST (mmaid->list), &n, NULL);
      for (i = mm_list_length (MM_LIST (mmaid->list)) - 1; i >= 0; i--)
        if (mm_list_is_selected (MM_LIST (mmaid->list), i))
          {
            arrow_select = TRUE;
            break;
          }
      if (cmd_play || cmd_stop )
        {
          gtk_widget_show (misc_find_menu (popup_entries, "/play"));
          gtk_widget_show (misc_find_menu (popup_entries, "/stop"));
          gtk_widget_show (misc_find_menu (popup_entries, "/sep1"));
          gtk_widget_set_sensitive (misc_find_menu (popup_entries, "/play"),
                                                                    n >= 0);
          gtk_widget_set_sensitive (misc_find_menu (popup_entries, "/stop"),
                                                            cmd_stop != NULL);
        }
      else
        {
          gtk_widget_hide (misc_find_menu (popup_entries, "/play"));
          gtk_widget_hide (misc_find_menu (popup_entries, "/stop"));
          gtk_widget_hide (misc_find_menu (popup_entries, "/sep1"));
        }
      gtk_widget_show (misc_find_menu (popup_entries, "/cut"));
      gtk_widget_show (misc_find_menu (popup_entries, "/copy"));
      gtk_widget_show (misc_find_menu (popup_entries, "/paste"));
      gtk_widget_show (misc_find_menu (popup_entries, "/delete"));
      gtk_widget_show (misc_find_menu (popup_entries, "/sep2"));
      gtk_widget_show (misc_find_menu (popup_entries, "/all"));
      gtk_widget_set_sensitive (misc_find_menu (popup_entries, "/cut"),
                                                                arrow_select);
      gtk_widget_set_sensitive (misc_find_menu (popup_entries, "/copy"),
                                                                arrow_select);
      gtk_widget_set_sensitive (misc_find_menu (popup_entries, "/delete"),
                                                                arrow_select);
      gtk_menu_popup (GTK_MENU (misc_find_menu (popup_entries, "/")),
                        NULL, NULL, NULL, NULL, event->button, event->time);
      return TRUE;
    }
  return FALSE;
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(フレーム)                                        *
*                                                                             *
******************************************************************************/
void
signal_changed (GtkWidget   *widget,
                MmaidWindow *mmaid)
{
  if (mmaid == orz_mdi_get_data (ORZ_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_edited (GtkWidget   *widget,
               const gint   n,
               const gint   c,
               MmaidWindow *mmaid)
{
  if (c == MM_LIST_ID3TAG || c == MM_LIST_FILE || c == MM_LIST_TITLE
            || c == MM_LIST_ARTIST || c == MM_LIST_ALBUM || c == MM_LIST_GENRE)
    orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
  if (mmaid == orz_mdi_get_data (ORZ_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_inserted (GtkWidget   *widget,
                 const gint   n,
                 MmaidWindow *mmaid)
{
  orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
  if (mmaid == orz_mdi_get_data (ORZ_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_moved (GtkWidget   *widget,
              const gint   n0,
              const gint   n1,
              MmaidWindow *mmaid)
{
  orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
  if (mmaid == orz_mdi_get_data (ORZ_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_sorted (GtkWidget   *widget,
               MmaidWindow *mmaid)
{
  orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
  if (mmaid == orz_mdi_get_data (ORZ_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_destroy_list (GtkWidget   *widget,
                     MmaidWindow *mmaid)
{
  gint i;

  /* ja:メニュー */
  i = orz_mdi_get_n_pages (ORZ_MDI (mdi));
  if (i < 1
        || (i == 1 && orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid) >= 0))
    set_menu_bar (NULL);
  /* ja:メモリを解放する */
  g_free (mmaid->charset);
  g_free (mmaid);
}
