/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer;

import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.Renderer;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.JmeException;
import com.jme.util.SortUtil;
import java.util.Arrays;
import java.util.Comparator;

public class RenderQueue {
    private SceneElementList transparentBucket;
    private SceneElementList transparentBackBucket;
    private SceneElementList opaqueBucket;
    private SceneElementList opaqueBackBucket;
    private SceneElementList orthoBucket;
    private SceneElementList orthoBackBucket;
    private Renderer renderer;
    private CullState tranCull;
    private ZBufferState tranZBuff;
    private boolean twoPassTransparent = true;
    private Vector3f tempVector = new Vector3f();

    public RenderQueue(Renderer renderer) {
        this.renderer = renderer;
        this.tranCull = renderer.createCullState();
        this.tranZBuff = renderer.createZBufferState();
        this.tranZBuff.setWritable(false);
        this.tranZBuff.setFunction(3);
        this.setupBuckets();
    }

    public void setTwoPassTransparency(boolean bl) {
        this.twoPassTransparent = bl;
    }

    public boolean isTwoPassTransparency() {
        return this.twoPassTransparent;
    }

    private void setupBuckets() {
        this.opaqueBucket = new SceneElementList(new OpaqueComp());
        this.opaqueBackBucket = new SceneElementList(new OpaqueComp());
        this.transparentBucket = new SceneElementList(new TransparentComp());
        this.transparentBackBucket = new SceneElementList(new TransparentComp());
        this.orthoBucket = new SceneElementList(new OrthoComp());
        this.orthoBackBucket = new SceneElementList(new OrthoComp());
    }

    public void addToQueue(SceneElement sceneElement, int n) {
        switch (n) {
            case 2: {
                this.opaqueBucket.add(sceneElement);
                break;
            }
            case 3: {
                this.transparentBucket.add(sceneElement);
                break;
            }
            case 4: {
                this.orthoBucket.add(sceneElement);
                break;
            }
            default: {
                throw new JmeException("Illegal Render queue order of " + n);
            }
        }
    }

    private float distanceToCam(SceneElement sceneElement) {
        if (sceneElement.queueDistance != Float.NEGATIVE_INFINITY) {
            return sceneElement.queueDistance;
        }
        Camera camera = this.renderer.getCamera();
        sceneElement.queueDistance = 0.0f;
        Vector3f vector3f = camera.getLocation();
        Vector3f vector3f2 = null;
        Vector3f vector3f3 = camera.getDirection();
        if (Vector3f.isValidVector(camera.getLocation())) {
            if (sceneElement.getWorldBound() != null && Vector3f.isValidVector(sceneElement.getWorldBound().getCenter())) {
                vector3f2 = sceneElement.getWorldBound().getCenter();
            } else if (sceneElement instanceof Spatial && Vector3f.isValidVector(((Spatial)sceneElement).getWorldTranslation())) {
                vector3f2 = ((Spatial)sceneElement).getWorldTranslation();
            }
        }
        if (vector3f2 != null) {
            vector3f2.subtract(vector3f, this.tempVector);
            float f = Math.abs(this.tempVector.dot(vector3f3) / vector3f3.dot(vector3f3));
            this.tempVector = vector3f3.mult(f, this.tempVector);
            sceneElement.queueDistance = this.tempVector.length();
        }
        return sceneElement.queueDistance;
    }

    public void clearBuckets() {
        this.transparentBucket.clear();
        this.opaqueBucket.clear();
        this.orthoBucket.clear();
    }

    public void swapBuckets() {
        SceneElementList sceneElementList = this.transparentBucket;
        this.transparentBucket = this.transparentBackBucket;
        this.transparentBackBucket = sceneElementList;
        sceneElementList = this.orthoBucket;
        this.orthoBucket = this.orthoBackBucket;
        this.orthoBackBucket = sceneElementList;
        sceneElementList = this.opaqueBucket;
        this.opaqueBucket = this.opaqueBackBucket;
        this.opaqueBackBucket = sceneElementList;
    }

    public void renderBuckets() {
        this.renderOpaqueBucket();
        this.renderTransparentBucket();
        this.renderOrthoBucket();
    }

    private void renderOpaqueBucket() {
        this.opaqueBucket.sort();
        for (int i = 0; i < this.opaqueBucket.listSize; ++i) {
            this.opaqueBucket.list[i].draw(this.renderer);
        }
        this.opaqueBucket.clear();
    }

    private void renderTransparentBucket() {
        this.transparentBucket.sort();
        for (int i = 0; i < this.transparentBucket.listSize; ++i) {
            SceneElement sceneElement = this.transparentBucket.list[i];
            if (this.twoPassTransparent && sceneElement instanceof GeomBatch) {
                GeomBatch geomBatch = (GeomBatch)sceneElement;
                RenderState renderState = geomBatch.states[9];
                geomBatch.states[9] = this.tranCull;
                ZBufferState zBufferState = (ZBufferState)geomBatch.states[8];
                geomBatch.states[8] = this.tranZBuff;
                this.tranCull.setCullMode(1);
                sceneElement.draw(this.renderer);
                geomBatch.states[8] = zBufferState;
                this.tranCull.setCullMode(2);
                sceneElement.draw(this.renderer);
                geomBatch.states[9] = renderState;
            } else {
                sceneElement.draw(this.renderer);
            }
            sceneElement.queueDistance = Float.NEGATIVE_INFINITY;
        }
        this.transparentBucket.clear();
    }

    private void renderOrthoBucket() {
        this.orthoBucket.sort();
        if (this.orthoBucket.listSize > 0) {
            this.renderer.setOrtho();
            for (int i = 0; i < this.orthoBucket.listSize; ++i) {
                this.orthoBucket.list[i].draw(this.renderer);
            }
            this.renderer.unsetOrtho();
        }
        this.orthoBucket.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrthoComp
    implements Comparator<SceneElement> {
        private OrthoComp() {
        }

        @Override
        public int compare(SceneElement sceneElement, SceneElement sceneElement2) {
            if (sceneElement2.getZOrder() == sceneElement.getZOrder()) {
                return 0;
            }
            if (sceneElement2.getZOrder() < sceneElement.getZOrder()) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransparentComp
    implements Comparator<SceneElement> {
        private TransparentComp() {
        }

        @Override
        public int compare(SceneElement sceneElement, SceneElement sceneElement2) {
            float f;
            float f2 = RenderQueue.this.distanceToCam(sceneElement);
            if (f2 == (f = RenderQueue.this.distanceToCam(sceneElement2))) {
                return 0;
            }
            if (f2 < f) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OpaqueComp
    implements Comparator<SceneElement> {
        private OpaqueComp() {
        }

        @Override
        public int compare(SceneElement sceneElement, SceneElement sceneElement2) {
            float f;
            if ((sceneElement.getType() & 0x100 & sceneElement2.getType()) != 0) {
                return this.compareByStates((GeomBatch)sceneElement, (GeomBatch)sceneElement2);
            }
            float f2 = RenderQueue.this.distanceToCam(sceneElement);
            if (f2 == (f = RenderQueue.this.distanceToCam(sceneElement2))) {
                return 0;
            }
            if (f2 < f) {
                return -1;
            }
            return 1;
        }

        private int compareByStates(GeomBatch geomBatch, GeomBatch geomBatch2) {
            TextureState textureState = (TextureState)geomBatch.states[6];
            TextureState textureState2 = (TextureState)geomBatch2.states[6];
            if (textureState == textureState2) {
                return 0;
            }
            if (textureState == null && textureState2 != null) {
                return -1;
            }
            if (textureState2 == null && textureState != null) {
                return 1;
            }
            int n = Math.min(textureState.getNumberOfSetTextures(), textureState2.getNumberOfSetTextures());
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = textureState.getTextureID(i);
                if (n3 == (n2 = textureState2.getTextureID(i))) continue;
                if (n3 < n2) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SceneElementList {
        SceneElement[] list = new SceneElement[32];
        SceneElement[] tlist;
        int listSize = 0;
        private static final int DEFAULT_SIZE = 32;
        private Comparator<SceneElement> c;

        SceneElementList(Comparator<SceneElement> comparator) {
            this.c = comparator;
        }

        void add(SceneElement sceneElement) {
            if (this.listSize == this.list.length) {
                SceneElement[] sceneElementArray = new SceneElement[this.listSize * 2];
                System.arraycopy(this.list, 0, sceneElementArray, 0, this.listSize);
                this.list = sceneElementArray;
            }
            this.list[this.listSize++] = sceneElement;
        }

        void clear() {
            for (int i = 0; i < this.listSize; ++i) {
                this.list[i] = null;
            }
            if (this.tlist != null) {
                Arrays.fill(this.tlist, null);
            }
            this.listSize = 0;
        }

        void sort() {
            if (this.listSize > 1) {
                if (this.tlist == null || this.tlist.length != this.list.length) {
                    this.tlist = (SceneElement[])this.list.clone();
                } else {
                    System.arraycopy(this.list, 0, this.tlist, 0, this.list.length);
                }
                SortUtil.msort(this.tlist, this.list, 0, this.listSize, this.c);
            }
        }
    }
}

