/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.geometryinstancing;

import com.jme.math.Vector3f;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.geometryinstancing.GeometryBatchInstanceAttributes;
import com.jme.scene.geometryinstancing.instance.GeometryInstance;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryBatchInstance
extends GeometryInstance<GeometryBatchInstanceAttributes> {
    public TriangleBatch instanceBatch;
    Vector3f worldVector = new Vector3f();

    public GeometryBatchInstance(TriangleBatch triangleBatch, GeometryBatchInstanceAttributes geometryBatchInstanceAttributes) {
        super(geometryBatchInstanceAttributes);
        this.instanceBatch = triangleBatch;
    }

    @Override
    public void commit(TriangleBatch triangleBatch) {
        int n;
        FloatBuffer floatBuffer;
        if (triangleBatch == null || this.instanceBatch == null || this.getNumVerts() <= 0) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            floatBuffer = this.instanceBatch.getTextureBuffer(i);
            FloatBuffer floatBuffer2 = triangleBatch.getTextureBuffer(i);
            if (floatBuffer == null || floatBuffer2 == null) continue;
            floatBuffer.rewind();
            floatBuffer2.put(floatBuffer);
        }
        FloatBuffer floatBuffer3 = this.instanceBatch.getVertexBuffer();
        floatBuffer = triangleBatch.getVertexBuffer();
        if (floatBuffer3 != null && floatBuffer != null) {
            floatBuffer3.rewind();
            n2 = floatBuffer.position() / 3;
            for (int i = 0; i < this.instanceBatch.getVertexCount(); ++i) {
                this.worldVector.set(floatBuffer3.get(), floatBuffer3.get(), floatBuffer3.get());
                ((GeometryBatchInstanceAttributes)this.attributes).getWorldMatrix().mult(this.worldVector, this.worldVector);
                floatBuffer.put(this.worldVector.x);
                floatBuffer.put(this.worldVector.y);
                floatBuffer.put(this.worldVector.z);
            }
        }
        FloatBuffer floatBuffer4 = this.instanceBatch.getColorBuffer();
        FloatBuffer floatBuffer5 = triangleBatch.getColorBuffer();
        if (floatBuffer4 != null && floatBuffer5 != null) {
            floatBuffer4.rewind();
            for (n = 0; n < this.instanceBatch.getVertexCount(); ++n) {
                floatBuffer5.put(floatBuffer4.get() * ((GeometryBatchInstanceAttributes)this.attributes).getColor().r);
                floatBuffer5.put(floatBuffer4.get() * ((GeometryBatchInstanceAttributes)this.attributes).getColor().g);
                floatBuffer5.put(floatBuffer4.get() * ((GeometryBatchInstanceAttributes)this.attributes).getColor().b);
                floatBuffer5.put(floatBuffer4.get() * ((GeometryBatchInstanceAttributes)this.attributes).getColor().a);
            }
        } else if (floatBuffer5 != null) {
            for (n = 0; n < this.instanceBatch.getVertexCount(); ++n) {
                floatBuffer5.put(((GeometryBatchInstanceAttributes)this.attributes).getColor().r);
                floatBuffer5.put(((GeometryBatchInstanceAttributes)this.attributes).getColor().g);
                floatBuffer5.put(((GeometryBatchInstanceAttributes)this.attributes).getColor().b);
                floatBuffer5.put(((GeometryBatchInstanceAttributes)this.attributes).getColor().a);
            }
        }
        FloatBuffer floatBuffer6 = this.instanceBatch.getNormalBuffer();
        FloatBuffer floatBuffer7 = triangleBatch.getNormalBuffer();
        if (floatBuffer6 != null && floatBuffer7 != null) {
            floatBuffer6.rewind();
            for (int i = 0; i < this.instanceBatch.getVertexCount(); ++i) {
                this.worldVector.set(floatBuffer6.get(), floatBuffer6.get(), floatBuffer6.get());
                ((GeometryBatchInstanceAttributes)this.attributes).getNormalMatrix().mult(this.worldVector, this.worldVector);
                this.worldVector.normalizeLocal();
                floatBuffer7.put(this.worldVector.x);
                floatBuffer7.put(this.worldVector.y);
                floatBuffer7.put(this.worldVector.z);
            }
        }
        IntBuffer intBuffer = this.instanceBatch.getIndexBuffer();
        IntBuffer intBuffer2 = triangleBatch.getIndexBuffer();
        if (intBuffer != null && intBuffer2 != null) {
            intBuffer.rewind();
            for (int i = 0; i < this.instanceBatch.getMaxIndex(); ++i) {
                intBuffer2.put(n2 + intBuffer.get());
            }
        }
    }

    @Override
    public int getNumIndices() {
        if (this.instanceBatch == null) {
            return 0;
        }
        return this.instanceBatch.getMaxIndex();
    }

    @Override
    public int getNumVerts() {
        if (this.instanceBatch == null) {
            return 0;
        }
        return this.instanceBatch.getVertexCount();
    }
}

