/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.scene.SceneElement;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Stack;

public abstract class RenderState
implements Serializable,
Savable {
    public static final int RS_ALPHA = 0;
    public static final int RS_DITHER = 1;
    public static final int RS_FOG = 2;
    public static final int RS_LIGHT = 3;
    public static final int RS_MATERIAL = 4;
    public static final int RS_SHADE = 5;
    public static final int RS_TEXTURE = 6;
    public static final int RS_WIREFRAME = 7;
    public static final int RS_ZBUFFER = 8;
    public static final int RS_CULL = 9;
    public static final int RS_VERTEX_PROGRAM = 10;
    public static final int RS_FRAGMENT_PROGRAM = 11;
    public static final int RS_ATTRIBUTE = 12;
    public static final int RS_STENCIL = 13;
    public static final int RS_GLSL_SHADER_OBJECTS = 14;
    public static final int RS_COLORMASK_STATE = 15;
    public static final int RS_CLIP = 16;
    public static final int RS_MAX_STATE = 17;
    public static boolean[] QUICK_COMPARE = new boolean[17];
    private boolean enabled = true;
    private boolean needsRefresh = false;

    public abstract int getType();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.setNeedsRefresh(true);
    }

    public abstract void apply();

    public RenderState extract(Stack stack, SceneElement sceneElement) {
        return (RenderState)stack.peek();
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.enabled, "enabled", true);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.enabled = inputCapsule.readBoolean("enabled", true);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public abstract StateRecord createStateRecord();

    public boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void setNeedsRefresh(boolean bl) {
        this.needsRefresh = bl;
    }

    public static void setQuickCompares(boolean bl) {
        Arrays.fill(QUICK_COMPARE, bl);
    }

    static {
        RenderState.QUICK_COMPARE[0] = true;
        RenderState.QUICK_COMPARE[1] = true;
        RenderState.QUICK_COMPARE[2] = false;
        RenderState.QUICK_COMPARE[3] = false;
        RenderState.QUICK_COMPARE[4] = false;
        RenderState.QUICK_COMPARE[5] = true;
        RenderState.QUICK_COMPARE[6] = false;
        RenderState.QUICK_COMPARE[7] = false;
        RenderState.QUICK_COMPARE[8] = true;
        RenderState.QUICK_COMPARE[9] = false;
        RenderState.QUICK_COMPARE[10] = true;
        RenderState.QUICK_COMPARE[11] = true;
        RenderState.QUICK_COMPARE[12] = true;
        RenderState.QUICK_COMPARE[13] = true;
        RenderState.QUICK_COMPARE[14] = true;
        RenderState.QUICK_COMPARE[15] = true;
        RenderState.QUICK_COMPARE[16] = true;
    }
}

