/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.ClipState;
import com.jme.scene.state.lwjgl.records.ClipStateRecord;
import com.jme.system.DisplaySystem;
import java.nio.DoubleBuffer;
import org.lwjgl.opengl.GL11;

public class LWJGLClipState
extends ClipState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        ClipStateRecord clipStateRecord = (ClipStateRecord)renderContext.getStateRecord(16);
        renderContext.currentStates[16] = this;
        if (this.isEnabled()) {
            for (int i = 0; i < 6; ++i) {
                this.enableClipPlane(i, this.enabledClipPlanes[i], clipStateRecord);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.enableClipPlane(i, false, clipStateRecord);
            }
        }
        if (!clipStateRecord.isValid()) {
            clipStateRecord.validate();
        }
    }

    private void enableClipPlane(int n, boolean bl, ClipStateRecord clipStateRecord) {
        if (bl) {
            if (!clipStateRecord.isValid() || !clipStateRecord.planeEnabled[n]) {
                GL11.glEnable((int)(12288 + n));
                clipStateRecord.planeEnabled[n] = true;
            }
            clipStateRecord.buf.rewind();
            clipStateRecord.buf.put(this.planeEquations[n]);
            clipStateRecord.buf.flip();
            GL11.glClipPlane((int)(12288 + n), (DoubleBuffer)clipStateRecord.buf);
        } else if (!clipStateRecord.isValid() || clipStateRecord.planeEnabled[n]) {
            GL11.glDisable((int)(12288 + n));
            clipStateRecord.planeEnabled[n] = false;
        }
    }

    public ClipStateRecord createStateRecord() {
        return new ClipStateRecord();
    }
}

