/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.client.sample.SampleClient3;
import jp.sourceforge.mmosf.client.sample.SampleClientFrame;
import jp.sourceforge.mmosf.client.sample.jme.LoggingResponseTime;
import jp.sourceforge.mmosf.server.SocketManager;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.UpdateCache;
import jp.sourceforge.mmosf.server.packet.MessagePacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.packet.UpdatePacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PacketProcess {
    protected UserConnection conn;
    protected UpdateCache updateCache = new UpdateCache();
    protected boolean isLogout = false;
    protected LoggingResponseTime frame;
    protected int charactorId;
    private static Log log = LogFactory.getLog(PacketProcess.class);

    public abstract void receiveMessage(ChatMessage var1);

    public abstract void receiveUpdate(Mob var1, List<Mob> var2, List<Mob> var3);

    public abstract void receivePacket(Packet var1);

    private void parsePacket(Packet packet) throws PacketFormatException {
        switch (packet.getType()) {
            case 2: {
                this.frame.logTime(packet);
                this.receiveMessage(PacketFactory.parseMessagePacket((MessagePacket)packet));
                break;
            }
            case 6: {
                List<Mob> listUpdate = new LinkedList<Mob>();
                LinkedList<Mob> listDelete = new LinkedList<Mob>();
                PacketFactory.parseUpdatePacket((UpdatePacket)packet, listUpdate, listDelete);
                listUpdate = this.updateCache.update(listUpdate, listDelete);
                Mob self = this.updateCache.get(this.charactorId);
                this.receiveUpdate(self, listUpdate, listDelete);
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.frame.logTime(packet);
                this.receivePacket(packet);
            }
        }
    }

    public void send(Packet packet) {
        try {
            this.frame.startLogTime();
            this.conn.send(packet);
        }
        catch (Exception ex) {
            SampleClientFrame.log.error("send packet error.", ex);
        }
    }

    public void start() {
        block2: while (true) {
            try {
                while (true) {
                    this.process();
                    if (this.isLogout) break block2;
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                SampleClient3.log.error("receive error.", e);
                continue;
            }
            break;
        }
    }

    public void process() throws PacketFormatException {
        if (this.conn.isReceive()) {
            Packet pack = this.conn.receive();
            if (pack.getType() == 1) {
                System.out.println("logout");
                this.isLogout = true;
            }
            this.parsePacket(pack);
        }
    }

    public void sendMessage(String str) {
        Packet packet = null;
        if (str.equals("/camp")) {
            packet = PacketFactory.createLogoutPacket(true);
            this.frame.sendLog();
        } else {
            packet = PacketFactory.createMessagePacket(ChatMessage.createSay(null, str));
        }
        this.send(packet);
    }

    public boolean connect(SocketAddress addr, String connectId) throws IOException, PacketFormatException, InterruptedException {
        SocketManager man = new SocketManager(addr);
        UserConnection conn = new UserConnection(man);
        int charId = 0;
        Packet pac = PacketFactory.createConnectRequestPcaket(connectId);
        conn.send(pac);
        while (!conn.isReceive()) {
            Thread.sleep(100L);
        }
        Packet ret = conn.receive();
        if (ret.getType() != 5) {
            SampleClient3.log.error("invalid packet.");
            conn.close();
            return false;
        }
        charId = ret.getInt("charactorid");
        this.conn = conn;
        this.charactorId = charId;
        this.isLogout = false;
        return true;
    }

    public boolean isLogout() {
        return this.isLogout;
    }

    public void setFrame(LoggingResponseTime frame) {
        this.frame = frame;
    }
}

