/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jp.sourceforge.mmosf.server.loginserver.test.ClientConnection;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SampleLoginFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(SampleLoginFrame.class);
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_OK = 1;
    private JTextField id;
    private JTextField password;
    private JButton btnLogin;
    private JButton btnCancel;
    protected int result = 0;
    protected InetAddress loginAddr;
    protected int loginPort;
    protected InetSocketAddress connectAddr;
    protected String connectId;

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnLogin) {
            this.onLonginBtn();
        } else if (e.getSource() == this.btnCancel) {
            this.onCanselBtn();
        }
    }

    public SampleLoginFrame(String hostAddress, int port) throws UnknownHostException {
        InetAddress host = null;
        host = InetAddress.getByName(hostAddress);
        this.initUI();
        this.loginAddr = host;
        this.loginPort = port;
    }

    public SampleLoginFrame(InetAddress addr, int port) {
        this.initUI();
        this.loginAddr = addr;
        this.loginPort = port;
    }

    protected void initUI() {
        this.setTitle("\u30ed\u30b0\u30a4\u30f3");
        this.setBounds(10, 10, 300, 130);
        GridLayout layout = new GridLayout(3, 2, 0, 5);
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        JLabel label1 = new JLabel();
        label1.setText("ID");
        panel.add(label1);
        this.id = new JTextField();
        panel.add(this.id);
        JLabel label2 = new JLabel();
        label2.setText("Password");
        panel.add(label2);
        this.password = new JPasswordField();
        panel.add(this.password);
        this.btnLogin = new JButton();
        this.btnLogin.setText("\u30ed\u30b0\u30a4\u30f3");
        this.btnLogin.setMnemonic(10);
        panel.add(this.btnLogin);
        this.btnCancel = new JButton();
        this.btnCancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        panel.add(this.btnCancel);
        JPanel panel2 = new JPanel();
        GridBagLayout layout2 = new GridBagLayout();
        panel2.setLayout(layout2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(15, 40, 15, 40);
        layout2.setConstraints(panel, gbc);
        panel2.add(panel);
        this.getContentPane().add((Component)panel2, "Center");
        this.btnLogin.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    public void onLonginBtn() {
        if (this.id.getText().length() == 0) {
            this.messageBox("ID\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 2);
            return;
        }
        if (this.password.getText().length() == 0) {
            this.messageBox("\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 2);
            return;
        }
        try {
            ClientConnection conn = new ClientConnection(this.loginAddr, this.loginPort);
            Packet pac = PacketFactory.createHelloPcaket(null);
            conn.send(pac);
            String random = null;
            block6: while (true) {
                Packet recvPac;
                if (!conn.isReceive()) {
                    Thread.sleep(500L);
                }
                if ((recvPac = conn.receive()) == null) {
                    Thread.sleep(100L);
                    continue;
                }
                switch (recvPac.getType()) {
                    case 4: {
                        random = recvPac.getString("random");
                        String id = this.id.getText();
                        String password = this.password.getText();
                        Packet sendPac = PacketFactory.createLoginRequestPcaket(id, password, random);
                        conn.send(sendPac);
                        continue block6;
                    }
                    case 0: {
                        if (!recvPac.getBoolean("success")) {
                            this.messageBox("ID\u3001\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u9055\u3044\u307e\u3059\u3002", 0);
                            continue block6;
                        }
                        this.connectAddr = new InetSocketAddress(recvPac.getString("hostadress"), recvPac.getInt("loginPort"));
                        this.connectId = recvPac.getString("connectid");
                        this.result = 1;
                        conn.close();
                        this.setVisible(false);
                        return;
                    }
                }
                break;
            }
            throw new Exception("invalid packet type.");
        }
        catch (Exception e) {
            this.messageBox("\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", 0);
            log.error("connect error.", e);
            this.setVisible(false);
            return;
        }
    }

    protected void messageBox(String message, int type) {
        JLabel label = new JLabel(message);
        JOptionPane.showMessageDialog(this, label, this.getTitle(), type);
    }

    public void onCanselBtn() {
        this.setVisible(false);
    }

    public int getResult() {
        return this.result;
    }

    public InetSocketAddress getConnectAddr() {
        return this.connectAddr;
    }

    public String getConnectId() {
        return this.connectId;
    }

    public boolean start() {
        while (this.isShowing()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.getResult() != 0;
    }
}

