/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JListPanel<C extends JComponent>
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected List<C> listComponent;
    protected Class<C> genericClass;

    public JListPanel() {
        this.init();
    }

    public JListPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public JListPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public JListPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    protected void init() {
        this.listComponent = new LinkedList<C>();
    }

    public C addComponent(Class<C> comp) {
        JComponent newComp;
        for (JComponent cache : this.listComponent) {
            if (cache.isEnabled() && cache.isVisible()) continue;
            cache.setEnabled(true);
            cache.setVisible(true);
            return (C)cache;
        }
        try {
            newComp = (JComponent)comp.newInstance();
            newComp.setFocusable(false);
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        this.listComponent.add(newComp);
        this.add(newComp);
        newComp.setEnabled(true);
        newComp.setVisible(true);
        return (C)newComp;
    }

    public void removeComponent(C comp) {
        this.listComponent.remove(comp);
        this.remove((Component)comp);
    }

    public static void setComponentWidth(JComponent comp) {
        Dimension dim = comp.getMaximumSize();
        dim.width = Integer.MAX_VALUE;
        comp.setMaximumSize(new Dimension(Short.MAX_VALUE, dim.height));
    }

    public void resize() {
        for (JComponent comp : this.listComponent) {
            if (!comp.isEnabled() || !comp.isVisible()) continue;
            JListPanel.setComponentWidth(comp);
        }
    }

    public void clearComponent() {
        for (JComponent comp : this.listComponent) {
            comp.isFocusOwner();
            comp.setEnabled(false);
            comp.setVisible(false);
        }
    }
}

