/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.sourceforge.mmosf.server.UserConnection;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.UpdateCache;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.packet.UpdatePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectConnection
extends UserConnection {
    private BlockingQueue<Packet> serverResponseQueue;
    private BlockingQueue<Packet> serverRequestQueue = new LinkedBlockingQueue<Packet>();
    private UpdateCache updateCache;
    private List<Mob> listMob;
    private BlockingQueue<Mob> listDeleteMob;

    public DirectConnection() {
        this.serverResponseQueue = new LinkedBlockingQueue<Packet>();
        this.updateCache = new UpdateCache();
        this.listMob = new LinkedList<Mob>();
        this.listDeleteMob = new LinkedBlockingQueue<Mob>();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isFailedSending() {
        return false;
    }

    @Override
    public boolean isReceive() {
        return this.serverRequestQueue.size() > 0;
    }

    @Override
    public boolean isSendPacket() {
        return false;
    }

    @Override
    public Packet receive() {
        block3: {
            try {
                if (!this.serverRequestQueue.isEmpty()) break block3;
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return this.serverRequestQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Packet packet) throws IOException, PacketFormatException {
        if (packet.getType() == 6) {
            LinkedList<Mob> listDelete = new LinkedList<Mob>();
            DirectConnection directConnection = this;
            synchronized (directConnection) {
                LinkedList<Mob> listUpdate = new LinkedList<Mob>();
                PacketFactory.parseUpdatePacket((UpdatePacket)packet, listUpdate, listDelete);
                this.listMob = this.updateCache.update(listUpdate, listDelete);
            }
            for (Mob mob : listDelete) {
                try {
                    this.listDeleteMob.put(mob);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } else {
            try {
                this.serverResponseQueue.put(packet);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendPacket() throws IOException {
    }

    public void sendServerRequest(Packet packet) {
        try {
            this.serverRequestQueue.put(packet);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Packet receiveSreverResponse() {
        block3: {
            try {
                if (!this.serverResponseQueue.isEmpty()) break block3;
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return this.serverResponseQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Mob> getUpdateSnapshot() {
        DirectConnection directConnection = this;
        synchronized (directConnection) {
            return new LinkedList<Mob>(this.listMob);
        }
    }
}

