/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import java.util.Random;
import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;

public class MovingRnd
extends MovingVector {
    public int wait = -1;
    public Position nextPos = new Position();
    private static Random rd = null;

    public MovingRnd() {
        this.moveType = 2;
        this.speed = 1.0;
    }

    Vector getVector(int direction2) {
        int direction = direction2;
        switch (direction) {
            case 0: {
                return Vector.NORTH;
            }
            case 1: {
                return Vector.EAST;
            }
            case 2: {
                return Vector.SOUTH;
            }
            case 3: {
                return Vector.WEST;
            }
        }
        return Vector.ZERO;
    }

    private boolean isMovePosition(Position nowPos) {
        if (!this.nextPos.isValid()) {
            return false;
        }
        return !nowPos.equals(this.nextPos);
    }

    protected Vector getVector(Position nowPos) {
        if (this.isMovePosition(nowPos)) {
            Position next = new Position(nowPos);
            return next.getVector(this.nextPos, this.getSpeed());
        }
        return Vector.ZERO;
    }

    Vector getRndMoveVector(Mob mob, Perception prc) {
        int direction = this.getRd().nextInt(4);
        int length = 4;
        int secondDirection = -1;
        int secondLength = -1;
        int j = 0;
        while (j < 4) {
            Vector vec = this.getVector(direction);
            int count = this.isEnableDirection(mob, vec, 4, prc);
            if (count == 4) {
                secondLength = count;
                secondDirection = direction;
                break;
            }
            if (count > secondLength) {
                secondLength = count;
                secondDirection = direction;
            }
            direction = (direction + 1) % 4;
            ++j;
        }
        if (secondLength <= 0) {
            Mob.log.error("mob can't move, mob in box.");
            return Vector.ZERO;
        }
        Vector vec = new Vector(this.getVector(secondDirection));
        vec.x *= (double)secondLength;
        vec.y *= (double)secondLength;
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Mob mob, Perception prc) {
        MovingRnd movingRnd = this;
        synchronized (movingRnd) {
            if (this.nextPos.isValid() && !this.nextPos.equals(mob.getPos())) {
                super.move(mob, prc);
                return;
            }
            if (this.wait != -1) {
                --this.wait;
                Mob.log.trace("wait mob:" + mob.c);
                return;
            }
            Vector vec = this.getRndMoveVector(mob, prc);
            this.nextPos.set(mob.getPos());
            this.nextPos.move(vec);
            mob.direction.set(vec);
            Mob.log.trace("get direction mob:" + mob.c);
            this.wait = 4 + this.getRd().nextInt(4);
            return;
        }
    }

    protected void moveRnd(Mob mob, Perception prc) {
        Vector vec = this.getRndMoveVector(mob, prc);
        Position next = new Position(mob.getPos());
        next.move(vec);
        this.nextPos.set(next);
    }

    int isEnableDirection(Mob mob, Vector vec, int length, Perception prc) {
        MoveObject mo = new MoveObject(new Position(mob.getPos()), vec);
        int i = 0;
        i = 1;
        while (i <= length) {
            if (!prc.isEnableMove(mo)) {
                return i - 1;
            }
            mo.moveNewPositon();
            ++i;
        }
        return length;
    }

    public Random getRd() {
        if (rd == null) {
            rd = new Random(System.currentTimeMillis());
        }
        return rd;
    }
}

