/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jp.morpho.config.ConfigureException;
import org.xml.sax.Attributes;

public abstract class Node
extends Vector {
    private Node parent = null;
    private Map attributes = null;

    public Node(Node parent, Attributes attributes) {
        this.parent = parent;
        if (attributes != null) {
            this.attributes = new HashMap();
            int i = 0;
            while (i < attributes.getLength()) {
                String key = attributes.getLocalName(i);
                if (key == null || key.equals("")) {
                    key = attributes.getQName(i);
                }
                this.attributes.put(key, attributes.getValue(i));
                ++i;
            }
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public Node getParent() {
        return this.parent;
    }

    protected Class getNodeClass() throws ClassNotFoundException {
        String className = this.getAttribute("class");
        if (className == null) {
            return null;
        }
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    protected String getNodeName() {
        String name = this.getAttribute("name");
        if (name == null || name.length() == 0) {
            return "";
        }
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    protected Object getValue(Object obj) throws ConfigureException {
        try {
            if (this.size() == 0) {
                return null;
            }
            int first = 0;
            int last = this.size() - 1;
            String item = null;
            while (first <= last) {
                item = (String)this.get(first);
                if (!(item instanceof String) || (item = ((String)item).trim()).length() > 0) break;
                ++first;
            }
            while (first < last) {
                item = (String)this.get(last);
                if (!(item instanceof String) || (item = item.trim()).length() > 0) break;
                --last;
            }
            if (first > last) {
                return null;
            }
            Object value = null;
            if (first == last) {
                value = this.getItemValue(obj, this.get(first));
            } else {
                StringBuffer buf;
                StringBuffer stringBuffer = buf = new StringBuffer();
                synchronized (stringBuffer) {
                    int i = first;
                    while (i <= last) {
                        Object o = this.get(i);
                        buf.append(this.getItemValue(obj, o));
                        ++i;
                    }
                    value = buf.toString();
                }
            }
            if (value != null && value instanceof String) {
                return ((String)value).trim();
            }
            return value;
        }
        catch (Exception e) {
            throw new ConfigureException(e);
        }
    }

    protected Object getItemValue(Object obj, Object item) throws ConfigureException {
        try {
            if (item instanceof String) {
                return item;
            }
            Node node = (Node)item;
            return node.configure(obj);
        }
        catch (Exception e) {
            throw new ConfigureException(e);
        }
    }

    public abstract int getTag();

    public abstract Object configure(Object var1) throws ConfigureException;

    public void configure(Object obj, int index) throws ConfigureException {
        try {
            int i = index;
            while (i < this.size()) {
                Object o = this.get(i);
                if (!(o instanceof String)) {
                    Node node = (Node)o;
                    node.configure(obj);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ConfigureException(e);
        }
    }
}

