/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jp.morpho.config.Configuration;
import jp.morpho.lang.LifeCycle;
import jp.morpho.lang.LifeCycleException;
import jp.morpho.webapp.FrameworkException;
import jp.morpho.webapp.Plugin;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.impl.PluginContextImpl;

public class FrameworkContext
extends Vector
implements LifeCycle,
Serializable {
    private Logger log = Logger.getLogger("jp.morpho");
    private static final String ATTRIBUTE = "jp.morpho.webapp.FrameworkContext";
    private static final String CONFIG_PATH = "/WEB-INF/morpho-config.xml";
    private HashMap map = new HashMap();
    private boolean running = false;

    protected FrameworkContext() {
    }

    public static synchronized FrameworkContext getInstance(ServletContext sc) throws FrameworkException {
        try {
            FrameworkContext fc = (FrameworkContext)sc.getAttribute(ATTRIBUTE);
            if (fc == null) {
                fc = new FrameworkContext();
                URL configURL = sc.getResource(CONFIG_PATH);
                InputStream in = configURL.openStream();
                Configuration config = new Configuration();
                config.configure(fc, in);
                in.close();
                sc.setAttribute(ATTRIBUTE, (Object)fc);
            }
            return fc;
        }
        catch (Exception e) {
            throw new FrameworkException(e);
        }
    }

    private synchronized void checkInstance(Object obj) {
        if (!(obj instanceof Plugin)) {
            throw new IllegalArgumentException("Object is not a Plugin: " + obj);
        }
    }

    private synchronized void checkMapping(String key) {
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException("Plugin Key already exists: " + key);
        }
    }

    public synchronized void add(int index, Object element) {
        this.checkInstance(element);
        String key = ((Plugin)element).getPluginKey();
        this.checkMapping(key);
        this.map.put(key, element);
        super.add(index, element);
    }

    public synchronized boolean add(Object element) {
        this.checkInstance(element);
        String key = ((Plugin)element).getPluginKey();
        this.checkMapping(key);
        this.map.put(key, element);
        try {
            PluginContextImpl ctx = new PluginContextImpl();
            ctx.setFrameworkContext(this);
            ((Plugin)element).setPluginContext(ctx);
        }
        catch (PluginException e) {
            this.log.warning(e.getMessage());
        }
        return super.add(element);
    }

    public synchronized boolean addAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.checkInstance(o);
            String key = ((Plugin)o).getPluginKey();
            this.checkMapping(key);
            this.map.put(key, o);
        }
        return super.addAll(c);
    }

    public synchronized boolean addAll(int index, Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.checkInstance(o);
            String key = ((Plugin)o).getPluginKey();
            this.checkMapping(key);
            this.map.put(key, o);
        }
        return super.addAll(index, c);
    }

    public synchronized void addElement(Object element) {
        this.checkInstance(element);
        String key = ((Plugin)element).getPluginKey();
        this.checkMapping(key);
        this.map.put(key, element);
        super.addElement(element);
    }

    public synchronized void insertElementAt(Object element, int index) {
        this.checkInstance(element);
        String key = ((Plugin)element).getPluginKey();
        this.checkMapping(key);
        this.map.put(key, element);
        super.insertElementAt(element, index);
    }

    public synchronized Object remove(int index) {
        Object o = super.remove(index);
        if (o != null) {
            String key = ((Plugin)o).getPluginKey();
            this.map.remove(key);
        }
        return o;
    }

    public synchronized boolean remove(Object element) {
        boolean ret = super.remove(element);
        if (ret) {
            String key = ((Plugin)element).getPluginKey();
            this.map.remove(key);
        }
        return ret;
    }

    public synchronized boolean removeAll(Collection c) {
        boolean retAll = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            boolean ret = this.remove(o);
            boolean bl = retAll = ret ? ret : retAll;
        }
        return retAll;
    }

    public synchronized void removeAllElements() {
        this.map.clear();
        super.removeAllElements();
    }

    public synchronized boolean removeElement(Object element) {
        boolean ret = super.removeElement(element);
        if (ret) {
            String key = ((Plugin)element).getPluginKey();
            this.map.remove(key);
        }
        return ret;
    }

    public synchronized void removeElementAt(int index) {
        String key = ((Plugin)this.get(index)).getPluginKey();
        this.map.remove(key);
        super.removeElementAt(index);
    }

    public synchronized boolean retainAll(Collection c) {
        boolean ret = super.retainAll(c);
        Object[] keys = this.map.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String key = (String)keys[i];
            if (!this.contains(this.map.get(key))) {
                this.map.remove(key);
            }
            ++i;
        }
        return ret;
    }

    public synchronized Object set(int index, Object element) {
        this.checkInstance(element);
        String key = ((Plugin)this.get(index)).getPluginKey();
        this.map.remove(key);
        key = ((Plugin)element).getPluginKey();
        this.map.put(key, element);
        return super.set(index, element);
    }

    public synchronized void setElementAt(Object element, int index) {
        this.checkInstance(element);
        String key = ((Plugin)this.get(index)).getPluginKey();
        this.map.remove(key);
        key = ((Plugin)element).getPluginKey();
        this.map.put(key, element);
        super.setElementAt(element, index);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public synchronized void clear() {
        this.map.clear();
        super.clear();
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void start() throws LifeCycleException {
        if (this.isRunning()) {
            throw new LifeCycleException("Already started");
        }
        this.running = true;
        Plugin[] plugins = new Plugin[this.size()];
        plugins = this.toArray(plugins);
        int i = 0;
        while (i < plugins.length) {
            try {
                plugins[i].pluginActivate();
            }
            catch (PluginException pluginException) {
                // empty catch block
            }
            ++i;
        }
    }

    public synchronized void stop() throws LifeCycleException {
        this.running = false;
        Plugin[] plugins = new Plugin[this.size()];
        plugins = this.toArray(plugins);
        while (this.size() > 0) {
            try {
                plugins[this.size() - 1].pluginRemove();
            }
            catch (PluginException pluginException) {
                // empty catch block
            }
            this.remove(this.size() - 1);
        }
    }
}

