/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.File;
import java.net.URI;

/**
 * <P>
 * åץɥեΥѥ̾ɽǤ
 * </P>
 * @author Kumiko Hiroi
 */
public class UploadFile
	extends File
{

	/** 饤Ȥ򤷤եΥѥ̾ʸ */
	private String clientPath = null;

	/** åץɤ줿եΥƥķ */
	private String contentType = null;

	/**
	 * <P>
	 * ꤵ줿ѥ̾ʸݥѥ̾Ѵơ UploadFile Υ󥹥󥹤ޤ
	 * ꤵ줿ʸ󤬶ʸξ硢̤϶ݥѥ̾ˤʤޤ
	 * </P>
	 * @param pathname ѥ̾ʸ
	 * @exception NullPointerException pathname  null ξ
	 */
	public UploadFile(String pathname)
	{
		super(pathname);
	}

	/**
	 * <P>
	 * ƥѥ̾ʸ󤪤ӻҥѥ̾ʸ󤫤鿷 UploadFile Υ󥹥󥹤ޤ
	 * </P>
	 * <P>
	 * parent  null ξ硢 UploadFile Υ󥹥󥹤ϡꤵ줿 child ѥ̾ʸñ UploadFile 󥹥ȥ饯ƤӽФ褦ޤ
	 * </P>
	 * <P>
	 * Ǥʤ硢parent ѥ̾ʸϥǥ쥯ȥ򼨤child ѥ̾ʸϥǥ쥯ȥޤϥե򼨤ޤ
	 * child ѥ̾ʸФξ硢ϥƥ˰¸ˡХѥ̾Ѵޤ
	 * parent ʸξ硢 UploadFile Υ󥹥󥹤ϡchild ݥѥ̾Ѵη̤򥷥ƥ˰¸ǥեȥǥ쥯ȥ˲褹뤳Ȥޤ
	 * Ǥʤ硢ƥѥ̾ʸݥѥ̾Ѵ졢ݥѥ̾ϿƤ˲褵ޤ
	 * </P>
	 * @param parent ƥѥ̾ʸ
	 * @param child ҥѥ̾ʸ
	 * @exception NullPointerException child  null ξ
	 */
	public UploadFile(String parent, String child)
	{
		super(parent, child);
	}

	/**
	 * <P>
	 * ݥѥ̾ӻҥѥ̾ʸ󤫤鿷 UploadFile Υ󥹥󥹤ޤ
	 * </P>
	 * <P>
	 * parent  null ξ硢 UploadFile Υ󥹥󥹤ϡꤵ줿 child ѥ̾ʸñ UploadFile 󥹥ȥ饯ƤӽФ褦ޤ
	 * </P>
	 * <P>
	 * Ǥʤ硢parent ݥѥ̾ϥǥ쥯ȥ򼨤child ѥ̾ʸϥǥ쥯ȥޤϥե򼨤ޤ
	 * child ѥ̾ʸФξ硢ϥƥ˰¸ˡХѥ̾Ѵޤ
	 * parent ݥѥ̾ξ硢 UploadFile Υ󥹥󥹤ϡchild ݥѥ̾Ѵη̤򥷥ƥ˰¸ǥեȥǥ쥯ȥ˲褹뤳Ȥޤ
	 * Ǥʤ硢ƥѥ̾ʸݥѥ̾Ѵ졢ݥѥ̾ϿƤ˲褵ޤ
	 * </P>
	 * @param parent ݥѥ̾
	 * @param child ҥѥ̾ʸ
	 * @exception NullPointerException child  null ξ
	 */
	public UploadFile(File parent, String child)
	{
		super(parent, child);
	}

	/**
	 * <P>
	 * ꤵ줿 file: URI ݥѥ̾Ѵơ UploadFile Υ󥹥󥹤ޤ
	 * </P>
	 * <P>
	 * file: URI ηϥƥ˰¸뤿ᡢΥ󥹥ȥ饯ԤѴ⥷ƥ˰¸ޤ
	 * </P>
	 * <P>
	 * ꤵ줿ݥѥ̾ <I>f</I> ξϡΤ褦Ѵޤ
	 * <BLOCKQUOTE><TT>
	 * new File(<I>f</I>.toURI()).equals(<I>f</I>)
	 * </TT></BLOCKQUOTE>
	 * ξ硢ݥѥ̾URIӿݥѥ̾ϡƱ Java ۥޥʣθƤӽФǺɬפޤ
	 * 륪ڥ졼ƥ󥰥ƥβۥޥǺ file: URI ̤Υڥ졼ƥ󥰥ƥβۥޥݥѥ̾Ѵ硢̾ϤΤ褦Ѵޤ
	 * </P>
	 * @param uri ط URIϡ"file"ѥ¡꡼ե饰ȡѥɬꤹ롣¡꡼ӥե饰Ȥʤ
	 * @exception NullPointerException uri  null ξ
	 * @exception IllegalArgumentException 嵭Υѥ᡼郎Ƥʤ
	 */
	public UploadFile(URI uri)
	{
		super(uri);
	}

	/**
	 * <P>
	 * 饤Ȥ򤷤եΥѥ̾ʸ֤ޤ
	 * </P>
	 * @return 饤Ȥ򤷤եΥѥ̾ʸ
	 */
	public String getClientPath()
	{
		return (clientPath != null) ? clientPath : "";
	}

	/**
	 * <P>
	 * 饤Ȥ򤷤եΥѥ̾ʸꤷޤ
	 * </P>
	 * @param clientPath 饤Ȥ򤷤եΥѥ̾ʸ
	 */
	public void setClientPath(String clientPath)
	{
		this.clientPath = clientPath;
	}

	/**
	 * <P>
	 * åץɤ줿եΥƥķ֤ޤ
	 * </P>
	 * @return åץɤ줿եΥƥķ
	 */
	public String getContentType()
	{
		return (contentType != null) ? contentType : "";
	}

	/**
	 * <P>
	 * åץɤ줿եΥƥķꤷޤ
	 * </P>
	 * @param contentType åץɤ줿եΥƥķ
	 */
	public void setContentType(String contentType)
	{
		this.contentType = contentType;
	}

}
