/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * <P>
 * ޥåפФѹäȯԤμǥ֥饹ˤĥǽȤ롢Map 󥿥եδʰפʼ󶡤ޤ
 * Υ饹ϡåѡޤϥǥ졼Υѥ˴ŤƼƤޤ
 * ƥ᥽åɤϡåפ줿ޥåץ֥ȤΥ᥽åɤǥեȤǸƤӽФޤ
 * </P>
 * @author Kenichi Fukuda
 */
public class MapWrapper
	implements Map
{

	//åפޥå
	private Map wrapped = null;

	/**
	 * <P>
	 * ꤵ줿ޥåפåפޥåץ֥Ȥۤޤ
	 * </P>
	 * @param map åפޥå
	 * @exception IllegalArgumentException ޥåפ null ξ
	 */
	public MapWrapper(Map map)
	{
		super();

		//ޥåפ null ξ IllegalArgumentException 򥹥ޤ
		if (map == null)
		{
			throw new IllegalArgumentException("map must not null");
		}

		this.wrapped = map;
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ size() ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#size()
	 */
	public synchronized int size()
	{
		return wrapped.size();
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ isEmpty() ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#isEmpty()
	 */
	public synchronized boolean isEmpty()
	{
		return wrapped.isEmpty();
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ containsKey(Object) ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#containsKey(Object)
	 */
	public synchronized boolean containsKey(Object key)
	{
		return wrapped.containsKey(key);
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ containsValue(Object) ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#containsValue(Object)
	 */
	public synchronized boolean containsValue(Object key)
	{
		return wrapped.containsValue(key);
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ get(Object) ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#get(Object)
	 */
	public synchronized Object get(Object key)
	{
		return wrapped.get(key);
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ put(Object, Object) ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#put(Object, Object)
	 */
	public synchronized Object put(Object key, Object value)
	{
		return wrapped.put(key, value);
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ remove(Object) ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#remove(Object)
	 */
	public synchronized Object remove(Object key)
	{
		return wrapped.remove(key);
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ putAll(Map) ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#putAll(Map)
	 */
	public synchronized void putAll(Map map)
	{
		wrapped.putAll(map);
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ clear() ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#clear()
	 */
	public synchronized void clear()
	{
		wrapped.clear();
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ keySet() ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#keySet()
	 */
	public synchronized Set keySet()
	{
		return wrapped.keySet();
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ values() ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#values()
	 */
	public synchronized Collection values()
	{
		return wrapped.values();
	}

	/**
	 * <P>
	 * Υ᥽åɤΥǥեȤưϡåפ줿ޥåץ֥ȤФ entrySet() ƤӽФȤǤ
	 * <P>
	 * @see java.util.Map#entrySet()
	 */
	public synchronized Set entrySet()
	{
		return wrapped.entrySet();
	}

}
