/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet;

import java.io.Serializable;
import java.util.logging.Logger;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import jp.morpho.webapp.FrameworkContext;

/**
 * <P>
 * WebApplicationContextListener 饹ϡ° Web ץꥱΥ֥åȥƥȤФѹΤݥץ饹Ǥ
 * Υ٥Ȥˤϡ Web ץꥱФһˤΥ饹ꤵƤɬפޤ
 * </P>
 * <P>
 * Υ饹Υ᥽åɤϤ٤ƶǤ
 * Υ饹ˤäơꥹʡ֥Ȥκưפˤʤޤ
 * </P>
 * @author Kenichi Fukuda
 */
public class WebApplicationContextListener
	implements ServletContextListener, Serializable
{

	private Logger log = Logger.getLogger("jp.morpho");

	/**
	 * <P>
	 * WebApplicationContextListener ޤ
	 * </P>
	 */
	public WebApplicationContextListener()
	{
		super();
	}

	/**
	 * <P>
	 * Web ץꥱ׵ǤȤΤǤ
	 * </P>
	 * @param event ֥åȥƥȥ٥
	 * @see javax.servlet.ServletContextListener#contextInitialized(ServletContextEvent)
	 */
	public void contextInitialized(ServletContextEvent sce)
	{
		log.info("contextInitialized: " + sce.getServletContext().getServletContextName());
		try
		{
			FrameworkContext fc = FrameworkContext.getInstance(sce.getServletContext());
			fc.start();
		}
		catch (Exception e)
		{
		}
	}

	/**
	 * <P>
	 * ֥åȥƥȤåȥ뤳ȤΤǤ
	 * </P>
	 * @param event ֥åȥƥȥ٥
	 * @see javax.servlet.ServletContextListener#contextDestroyed(ServletContextEvent)
	 */
	public void contextDestroyed(ServletContextEvent sce)
	{
		log.info("contextDestroyed: " + sce.getServletContext().getServletContextName());
		try
		{
			FrameworkContext fc = FrameworkContext.getInstance(sce.getServletContext());
			fc.stop();
		}
		catch (Exception e)
		{
		}
	}

}
