/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.http;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import jp.morpho.io.UploadFile;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.ActionRequestAttributeNames;

/**
 * <P>
 * HttpActionRequest 饹ϡHTTP ֥åѤ׵󶡤 HttpServletRequest 󥿥եμǤ
 * Υ饹ϡåѡޤϥǥ졼Υѥ˴ŤƼƤޤ
 * ƥ᥽åɤϡåפ줿׵ᥪ֥ȤΥ᥽åɤǥեȤǸƤӽФޤ
 * </P>
 * <P>
 * HttpActionRequest 饹ˤϡ׵뤿ɬפʥ䥹ơ뤿Υ᥽åɤ󶡤ޤ
 * </P>
 * @author Kenichi Fukuda
 */
public class HttpActionRequest
	extends HttpServletRequestWrapper
{

	/**
	 * <P>
	 * ꤵ줿׵åפ HttpActionRequest ۤޤ
	 * </P>
	 * @param request ֥åȤؤ׵
	 * @exception IllegalArgumentException ׵᤬ null ξ
	 */
	public HttpActionRequest(HttpServletRequest request)
	{
		super(request);
	}

	/**
	 * <P>
	 * ׵륢ͤޤ
	 * </P>
	 * @return ׵륢
	 */
	public String getAction()
	{
		return (String)this.getAttribute(ActionRequestAttributeNames.action);
	}

	/**
	 * <P>
	 * ׵륢ͤꤷޤ
	 * </P>
	 * @param action ׵륢
	 */
	public void setAction(String action)
	{
		this.setAttribute(ActionRequestAttributeNames.action, action);
	}

	/**
	 * <P>
	 * ׵륹ơͤޤ
	 * </P>
	 * @return ׵륹ơ
	 */
	public String getStatus()
	{
		return (String)this.getAttribute(ActionRequestAttributeNames.status);
	}

	/**
	 * <P>
	 * ׵륹ơͤꤷޤ
	 * </P>
	 * @param status ׵륹ơ
	 */
	public void setStatus(String status)
	{
		this.setAttribute(ActionRequestAttributeNames.status, status);
	}

	/**
	 * եࡦѥ᡼ޤ<br>
	 *
	 * @return եࡦѥ᡼
	 */
	public Map getParameterMap()
	{
		Map formValues = (Map)this.getAttribute(ActionRequestAttributeNames.form);
		if (formValues == null)
		{
			formValues = new ConversionMap();
		}
		return formValues;
	}

	/**
	 * եࡦѥ᡼ꤷޤ<br>
	 *
	 * @param formValues եࡦѥ᡼
	 */
	public void setParameterMap(Map formValues)
	{
		this.setAttribute(ActionRequestAttributeNames.form, formValues);
	}

	/**
	 * եࡦѥ᡼򥯥ꥢޤ<br>
	 * <br>
	 *
	 */
	public void clearFormValues()
	{
		this.removeAttribute(ActionRequestAttributeNames.form);
	}

	/**
	 * @see javax.servlet.ServletRequest#getParameter(String)
	 */
	public String getParameter(String key)
	{
		ConversionMap formValues = ConversionMap.valueOf(this.getParameterMap());

		if (formValues.getObject(key) instanceof UploadFile)
		{
			return null;
		}
		if (formValues.isArray(key))
		{
			Object[] objs = (Object[])formValues.getObject(key);
			return objs[0].toString();
		}
		return formValues.getString(key);
	}

}
