/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.http;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionMappingManager;

/**
 * <P>
 * Web ץꥱŬ HTTP ֥åȤ󶡤ޤ
 * </P>
 * <P>
 * HttpActionServlet Ѥȡ֥åȤκפˤʤޤ
 * Υ饹ϡ׵륢ϥɥθƤӽФȲܤƤޤ
 * </P>
 * @author Kenichi Fukuda
 */
public class HttpActionServlet
	extends javax.servlet.http.HttpServlet
{
	private ActionHandlerChain ActionHandlerChain;

	/**
	 * <P>
	 * HttpActionServlet ޤ
	 * </P>
	 */
	public HttpActionServlet()
	{
		super();
	}

	/**
	 * <P>
	 * ֥åȤ GET ׵ݤˡservice ᥽åɷͳǥФ˸ƤӽФޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤϡdoAction ᥽åɤƤӽФޤ
	 * </P>
	 * @param req 饤Ȥ֥åȤ˹Ԥ׵ޤ HttpServletRequest ֥
	 * @param resp ֥åȤ饤Ȥޤ HttpServletResponse ֥
	 * @exception IOException ֥åȤ GET ׵Ȥˡϥ顼Ф줿
	 * @exception ServletException GET ׵Ǥʤä
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest, HttpServletResponse)
	 */
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException, IOException
	{
		doAction(req, resp);
	}

	/**
	 * <P>
	 * ֥åȤ POST ׵ݤˡservice ᥽åɷͳǥФˤäƸƤӽФޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤϡdoAction ᥽åɤƤӽФޤ
	 * </P>
	 * @param req 饤Ȥ֥åȤ˹Ԥ׵ޤ HttpServletRequest ֥
	 * @param resp ֥åȤ饤Ȥޤ HttpServletResponse ֥
	 * @exception IOException ֥åȤ POST ׵Ȥˡϥ顼Ф줿
	 * @exception ServletException POST ׵Ǥʤä
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest, HttpServletResponse)
	 */
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException, IOException
	{
		doAction(req, resp);
	}

	/**
	 * <P>
	 * Υ᥽åɤϡ饤Ȥ׵˱Ŭڤʥϥɥ¹ԤܤԤޤ
	 * </P>
	 * @param req 饤Ȥ֥åȤ˹Ԥ׵ޤ HttpServletRequest ֥
	 * @param resp ֥åȤ饤Ȥޤ HttpServletResponse ֥
	 * @exception IOException ֥åȤ ׵Ȥˡϥ顼Ф줿
	 * @exception ServletException ׵Ǥʤä
	 */
	protected void doAction(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException, IOException
	{
		try
		{
			HttpActionRequest request = new HttpActionRequest(req);
			HttpActionResponse response = new HttpActionResponse(resp);
			FrameworkContext fc = FrameworkContext.getInstance(req.getSession().getServletContext());
			ActionMappingManager amm = (ActionMappingManager)fc.get(PluginKeys.actionMappingManager);
			ActionHandlerChain chain = amm.getActionHandlerChain(request.getServletPath(), request.getStatus(), request.getAction());
			chain.doActionHandler(request, response);
		}
		catch (Exception e)
		{
			throw new ServletException(e);
		}
	}

}
