/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import javax.servlet.jsp.JspException;

import jp.morpho.webapp.action.ActionMappingManager;

/**
 * <P>
 * ܥޤ
 * ActionButtonTag ˤϡ׵륢ȥơꤹ뤿 action ° status °ޤ
 * ActionButtonTag ϡȥơեꤹ뤿ΥץȤonclick °ꤷޤ
 * </P>
 * @author Kumiko Hiroi
 */
public class ActionButtonTag
	extends InputTag
{

	/**
	 * <P>
	 * ActionButtonTag ޤ
	 * </P>
	 */
	public ActionButtonTag()
	{
		super();
	}

	/**
	 * <P>
	 * action °֤ޤ
	 * </P>
	 * @return action °
	 */
	public String getAction()
	{
		return this.getAttributeMap().getString("action");
	}

	/**
	 * <P>
	 * form °֤ޤ
	 * </P>
	 * @return form °
	 */
	public String getForm()
	{
		return this.getAttributeMap().getString("form");
	}

	/**
	 * <P>
	 * status °֤ޤ
	 * </P>
	 * @return status °
	 */
	public String getStatus()
	{
		return this.getAttributeMap().getString("status");
	}

	/**
	 * <P>
	 * action °ꤷޤ
	 * </P>
	 * @param action action °
	 */
	public void setAction(String action)
	{
		this.getAttributeMap().setString("action", action);
	}

	/**
	 * <P>
	 * form °ꤷޤ
	 * </P>
	 * @param form form °
	 */
	public void setForm(String form)
	{
		this.getAttributeMap().setString("form", form);
	}

	/**
	 * <P>
	 * status °ꤷޤ
	 * </P>
	 * @param status status °
	 */
	public void setStatus(String status)
	{
		this.getAttributeMap().setString("status", status);
	}

	/**
	 * <P>
	 * ΥΥפ֤ޤ
	 * </P>
	 * @return ΥΥ
	 * @see jp.morpho.webapp.servlet.jsp.tagext.TagTemplate#getTagType()
	 */
	public String getTagType()
	{
		return "jp.morpho.webapp.servlet.jsp.tagext.html.ActionButtonTag";
	}

	/**
	 * <P>
	 * ϥνǤ
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		this.setType("button");
		if (!this.getAttributeMap().containsKey("form"))
		{
			throw new JspException("form attribute is not found.");
		}
		if (!this.getAttributeMap().containsKey("action"))
		{
			throw new JspException("action attribute is not found.");
		}

		ActionMappingManager amm = getActionMappingManager();
		HtmlEncoder encoder = this.getTagManager().getHtmlEncoder();
		StringBuffer buf = new StringBuffer();
		String formName = this.getForm();

		//action
		buf.append("document.").append(formName).append(".").append(amm.getActionParameterName())
			.append(".value='").append(encoder.encode(this.getAction())).append("';");

		//status
		if (this.getAttributeMap().containsKey("status"))
		{
			buf.append("document.").append(formName).append(".").append(amm.getStatusParameterName())
				.append(".value='").append(encoder.encode(this.getStatus())).append("';");
		}

		buf.append("document.").append(formName).append(".submit();");

		this.setOnclick(buf.toString());

		this.getAttributeMap().remove("action");
		this.getAttributeMap().remove("status");
		this.getAttributeMap().remove("form");

		return super.doStartTag();
	}

}
