/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

/**
 * <P>
 * Generic Attributes  events ɽޤ
 * </P>
 * <P>
 * events  HTML 4 ϼΤȤǤ
 * <PRE>
 * &lt;!ENTITY % events
 *  "onclick     %Script;       #IMPLIED  -- a pointer button was clicked --
 *   ondblclick  %Script;       #IMPLIED  -- a pointer button was double clicked--
 *   onmousedown %Script;       #IMPLIED  -- a pointer button was pressed down --
 *   onmouseup   %Script;       #IMPLIED  -- a pointer button was released --
 *   onmouseover %Script;       #IMPLIED  -- a pointer was moved onto --
 *   onmousemove %Script;       #IMPLIED  -- a pointer was moved within --
 *   onmouseout  %Script;       #IMPLIED  -- a pointer was moved away --
 *   onkeypress  %Script;       #IMPLIED  -- a key was pressed and released --
 *   onkeydown   %Script;       #IMPLIED  -- a key was pressed down --
 *   onkeyup     %Script;       #IMPLIED  -- a key was released --"
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public interface Events
{
	/**
	 * Returns the onclick.
	 * @return String
	 */
	public String getOnclick();

	/**
	 * Returns the ondblclick.
	 * @return String
	 */
	public String getOndblclick();

	/**
	 * Returns the onkeydown.
	 * @return String
	 */
	public String getOnkeydown();

	/**
	 * Returns the onkeypress.
	 * @return String
	 */
	public String getOnkeypress();

	/**
	 * Returns the onkeyup.
	 * @return String
	 */
	public String getOnkeyup();

	/**
	 * Returns the onmousedown.
	 * @return String
	 */
	public String getOnmousedown();

	/**
	 * Returns the onmousemove.
	 * @return String
	 */
	public String getOnmousemove();

	/**
	 * Returns the onmouseout.
	 * @return String
	 */
	public String getOnmouseout();

	/**
	 * Returns the onmouseover.
	 * @return String
	 */
	public String getOnmouseover();

	/**
	 * Returns the onmouseup.
	 * @return String
	 */
	public String getOnmouseup();

	/**
	 * Sets the onclick.
	 * @param onclick The onclick to set
	 */
	public void setOnclick(String onclick);

	/**
	 * Sets the ondblclick.
	 * @param ondblclick The ondblclick to set
	 */
	public void setOndblclick(String ondblclick);

	/**
	 * Sets the onkeydown.
	 * @param onkeydown The onkeydown to set
	 */
	public void setOnkeydown(String onkeydown);

	/**
	 * Sets the onkeypress.
	 * @param onkeypress The onkeypress to set
	 */
	public void setOnkeypress(String onkeypress);

	/**
	 * Sets the onkeyup.
	 * @param onkeyup The onkeyup to set
	 */
	public void setOnkeyup(String onkeyup);

	/**
	 * Sets the onmousedown.
	 * @param onmousedown The onmousedown to set
	 */
	public void setOnmousedown(String onmousedown);

	/**
	 * Sets the onmousemove.
	 * @param onmousemove The onmousemove to set
	 */
	public void setOnmousemove(String onmousemove);

	/**
	 * Sets the onmouseout.
	 * @param onmouseout The onmouseout to set
	 */
	public void setOnmouseout(String onmouseout);

	/**
	 * Sets the onmouseover.
	 * @param onmouseover The onmouseover to set
	 */
	public void setOnmouseover(String onmouseover);

	/**
	 * Sets the onmouseup.
	 * @param onmouseup The onmouseup to set
	 */
	public void setOnmouseup(String onmouseup);
}
