/*
 * Decompiled with CFR 0.152.
 */
package atmuoSession;

import atmuoSession.ProjectInfo;
import atmuoSession.ProjectInfoMap;
import commonData.CommonStatic;
import jScheduleData.OneDayScheduleData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import scheduleData.ScheduleData;
import sessionCommon.FormAnalyser;
import sessionCommon.HttpHeaderInfo;
import sessionCommon.HttpSession;
import sessionCommon.InputInfoHolder;
import sessionCommon.PostParamData;
import sessionCommon.SelectInfoHolder;

public class AtmuoUpdateKintaiDetail {
    public int execUpdateKintaiDetail(HttpHeaderInfo httpHeaderInfo, String urlName, String yyyy, String mm, String dd, ProjectInfoMap projectInfoMap, boolean addStartEndTime, boolean addRestTime, OneDayScheduleData odsd, CommonStatic.AtMuoPhaseKind atMuoPhaseKind, CommonStatic.AtMuoWorkKind atMuoWorkKind) {
        HttpURLConnection urlConnection;
        block4: {
            CookieHandler.setDefault(httpHeaderInfo.getCookieManager());
            HttpSession connection = new HttpSession();
            urlConnection = connection.create_connection(urlName);
            if (urlConnection == null) {
                return -1;
            }
            try {
                urlConnection.setRequestMethod("POST");
                PrintWriter urlOut = new PrintWriter(urlConnection.getOutputStream());
                urlOut.print(this.createMessage(httpHeaderInfo.getFormAnalyser(), yyyy, mm, dd, projectInfoMap, addStartEndTime, addRestTime, odsd, atMuoPhaseKind, atMuoWorkKind));
                urlOut.close();
                if (urlConnection.getResponseCode() == 200) break block4;
                return -2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -3;
            }
        }
        httpHeaderInfo.getFormAnalyser().allClear();
        BufferedReader urlIn = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        httpHeaderInfo.getFormAnalyser().setFormData(urlIn);
        return 0;
    }

    private String createMessage(FormAnalyser formInfo, String yyyy, String mm, String dd, ProjectInfoMap projectInfoMap, boolean addStartEndTime, boolean addRestTime, OneDayScheduleData odsd, CommonStatic.AtMuoPhaseKind atMuoPhaseKind, CommonStatic.AtMuoWorkKind atMuoWorkKind) {
        ArrayList<PostParamData> paramList = new UpdateKintaiHeader().careateHeader(0, formInfo, addStartEndTime, addRestTime, odsd);
        paramList.addAll(new UpdateKintaiBody().createBody(odsd.getSdList(), projectInfoMap, atMuoPhaseKind, atMuoWorkKind));
        return this.makePostMessage(formInfo.getHiddenPostParamList(0), paramList);
    }

    private String makePostMessage(ArrayList<PostParamData> paramHidden, ArrayList<PostParamData> paramBody) {
        String msg = "";
        for (PostParamData hidden : paramHidden) {
            boolean finded = false;
            for (PostParamData body : paramBody) {
                if (!hidden.getName().equals(body.getName())) continue;
                finded = true;
                break;
            }
            if (finded) continue;
            msg = String.valueOf(msg) + hidden.makeMessageURLEncode2SJIS();
        }
        for (PostParamData body : paramBody) {
            msg = String.valueOf(msg) + body.makeMessageURLEncode2SJIS();
        }
        return msg;
    }

    private class UpdateKintaiBody {
        ArrayList<String> paramNameList = new ArrayList();

        UpdateKintaiBody() {
            this.initParamNameList();
        }

        private void initParamNameList() {
        }

        public ArrayList<PostParamData> createBody(ArrayList<ScheduleData> scheduleList, ProjectInfoMap projectInfoMap, CommonStatic.AtMuoPhaseKind atMuoPhaseKind, CommonStatic.AtMuoWorkKind atMuoWorkKind) {
            ArrayList<PostParamData> paramList = new ArrayList<PostParamData>();
            ArrayList<ScheduleData> scheduleList2 = this.excludeUnFixedSchedule(scheduleList);
            ArrayList<UpdateKintaiParam> ukpList = this.comvKintaiParam(scheduleList2, projectInfoMap, atMuoPhaseKind, atMuoWorkKind);
            int count = 0;
            Iterator<UpdateKintaiParam> i = ukpList.iterator();
            while (i.hasNext()) {
                paramList.addAll(this.createOneData(i.next(), count, "1"));
                ++count;
            }
            UpdateKintaiParam dumyUkp = new UpdateKintaiParam();
            int i2 = count;
            while (i2 < 20) {
                paramList.addAll(this.createOneData(dumyUkp, i2, ""));
                ++i2;
            }
            paramList.add(new PostParamData("prjWorkSize", Integer.toString(count)));
            paramList.addAll(this.createFooter(scheduleList));
            return paramList;
        }

        private ArrayList<ScheduleData> excludeUnFixedSchedule(ArrayList<ScheduleData> scheduleList) {
            ArrayList<ScheduleData> resultList = new ArrayList<ScheduleData>();
            for (ScheduleData sd : scheduleList) {
                if (sd.isUnFixed()) continue;
                resultList.add(sd);
            }
            return resultList;
        }

        private ArrayList<UpdateKintaiParam> comvKintaiParam(ArrayList<ScheduleData> scheduleList, ProjectInfoMap projectInfoMap, CommonStatic.AtMuoPhaseKind atMuoPhaseKind, CommonStatic.AtMuoWorkKind atMuoWorkKind) {
            ArrayList<UpdateKintaiParam> resultList = new ArrayList<UpdateKintaiParam>();
            for (ScheduleData sd : scheduleList) {
                ProjectInfo projectInfo = projectInfoMap.getProjectInfo(sd.getPrj_code());
                if (projectInfo != null) {
                    UpdateKintaiParam ukp = new UpdateKintaiParam();
                    ukp.projectInfo = projectInfo.clone();
                    ukp.phaseName = atMuoPhaseKind == CommonStatic.AtMuoPhaseKind.UNIT ? sd.getProjectUnitName() : (atMuoPhaseKind == CommonStatic.AtMuoPhaseKind.TITLE ? sd.getTitle() : String.valueOf(sd.getWbsNo()) + "." + sd.getPhaseName());
                    ukp.workName = atMuoWorkKind == CommonStatic.AtMuoWorkKind.TITLE ? sd.getTitle() : sd.getWork();
                    ukp.workTimeHour = sd.getTimeHour();
                    ukp.workTimeMinute = sd.getTimeMinute();
                    ukp.workTime = sd.getTimeByHour();
                    resultList.add(ukp);
                    continue;
                }
                System.err.println("projectCode is not found in ProjectInfoMap " + sd.getPrj_code());
            }
            return this.getAddUpSchedule(resultList);
        }

        private ArrayList<UpdateKintaiParam> getAddUpSchedule(ArrayList<UpdateKintaiParam> ukpList) {
            ArrayList<UpdateKintaiParam> resultList = new ArrayList<UpdateKintaiParam>();
            for (UpdateKintaiParam inUkp : ukpList) {
                boolean findFlg = false;
                for (UpdateKintaiParam ukp : resultList) {
                    if (!inUkp.compare4Atmuo(ukp)) continue;
                    ukp.workTimeHour += inUkp.workTimeHour;
                    ukp.workTimeMinute += inUkp.workTimeMinute;
                    if (ukp.workTimeMinute > 60) {
                        ukp.workTimeMinute -= 60;
                        ++ukp.workTimeHour;
                    }
                    ukp.workTime += inUkp.workTime;
                    findFlg = true;
                    break;
                }
                if (findFlg) continue;
                resultList.add(inUkp);
            }
            return resultList;
        }

        private ArrayList<PostParamData> createOneData(UpdateKintaiParam ukp, int count, String changePrj) {
            ArrayList<PostParamData> wkParamList = new ArrayList<PostParamData>();
            String paramName1 = "ls[xxxxx].prjCd";
            String value1 = ukp.projectInfo.getCode();
            wkParamList.add(new PostParamData(paramName1, value1));
            String paramName2 = "ls[xxxxx].prjId";
            String value2 = ukp.projectInfo.getId();
            wkParamList.add(new PostParamData(paramName2, value2));
            String paramName3 = "ls[xxxxx].prjName";
            String value3 = ukp.projectInfo.getName();
            wkParamList.add(new PostParamData(paramName3, value3));
            String paramName4 = "ls[xxxxx].workTimeHour";
            String value4 = Integer.toString(ukp.workTimeHour);
            wkParamList.add(new PostParamData(paramName4, value4));
            String paramName5 = "ls[xxxxx].workTimeMinute";
            String value5 = Integer.toString(ukp.workTimeMinute);
            wkParamList.add(new PostParamData(paramName5, value5));
            String paramName6 = "ls[xxxxx].workTime";
            DecimalFormat df = new DecimalFormat("#.##");
            String value6 = df.format(ukp.workTime);
            wkParamList.add(new PostParamData(paramName6, value6));
            String paramName7 = "ls[xxxxx].phase";
            String value7 = ukp.getPhaseName20();
            wkParamList.add(new PostParamData(paramName7, value7));
            String paramName8 = "ls[xxxxx].workClassification";
            String value8 = ukp.getWorkName20();
            wkParamList.add(new PostParamData(paramName8, value8));
            String paramName9 = "changePrj[xxxxx]";
            String value9 = changePrj;
            wkParamList.add(new PostParamData(paramName9, value9));
            String paramName10 = "savePrjId[xxxxx]";
            String value10 = "";
            wkParamList.add(new PostParamData(paramName10, value10));
            String paramName11 = "saveWorkTime[xxxxx]";
            String value11 = "";
            wkParamList.add(new PostParamData(paramName11, value11));
            String paramName12 = "savePhase[xxxxx]";
            String value12 = "";
            wkParamList.add(new PostParamData(paramName12, value12));
            String paramName13 = "saveWorkClassification[xxxxx]";
            String value13 = "";
            wkParamList.add(new PostParamData(paramName13, value13));
            ArrayList<PostParamData> paramList = new ArrayList<PostParamData>();
            for (PostParamData paramData : wkParamList) {
                String newName = paramData.getName().replace("xxxxx", Integer.toString(count));
                paramData.setName(newName);
                paramList.add(paramData);
            }
            return paramList;
        }

        private ArrayList<PostParamData> createFooter(ArrayList<ScheduleData> scheduleList) {
            int timeSumHour = 0;
            int timeSumMinute = 0;
            double timeSum = 0.0;
            int wkHour = 0;
            int wkMinute = 0;
            for (ScheduleData sd : scheduleList) {
                wkHour += sd.getTimeHour();
                wkMinute += sd.getTimeMinute();
            }
            timeSumHour = wkHour + wkMinute / 60;
            timeSumMinute = wkMinute % 60;
            timeSum = (double)timeSumHour + (double)timeSumMinute / 60.0;
            DecimalFormat df = new DecimalFormat("#.##");
            String value = df.format(timeSum);
            ArrayList<PostParamData> paramList = new ArrayList<PostParamData>();
            paramList.add(new PostParamData("timeSumHour", Integer.toString(timeSumHour)));
            paramList.add(new PostParamData("timeSumMinute", Integer.toString(timeSumMinute)));
            paramList.add(new PostParamData("timeSum", value));
            return paramList;
        }

        private class UpdateKintaiParam {
            public ProjectInfo projectInfo = new ProjectInfo();
            public int workTimeHour = 0;
            public int workTimeMinute = 0;
            public double workTime = 0.0;
            public String workName = "";
            public String phaseName = "";

            private UpdateKintaiParam() {
            }

            public boolean compare4Atmuo(UpdateKintaiParam ukp) {
                String ukpPrjId = "";
                ukpPrjId = ukp.projectInfo.getId().length() > 20 ? ukp.projectInfo.getId().substring(0, 19) : ukp.projectInfo.getId();
                String ukpPhaseName = "";
                ukpPhaseName = ukp.phaseName.length() > 20 ? ukp.phaseName.substring(0, 19) : ukp.phaseName;
                String ukpWorkName = "";
                ukpWorkName = ukp.workName.length() > 20 ? ukp.workName.substring(0, 19) : ukp.workName;
                String thisPrjId = "";
                thisPrjId = this.projectInfo.getId().length() > 20 ? this.projectInfo.getId().substring(0, 19) : this.projectInfo.getId();
                String thisPhaseName = "";
                thisPhaseName = this.phaseName.length() > 20 ? this.phaseName.substring(0, 19) : this.phaseName;
                String thisWorkName = "";
                thisWorkName = this.workName.length() > 20 ? this.workName.substring(0, 19) : this.workName;
                return ukpPrjId.equals(thisPrjId) && ukpPhaseName.equals(thisPhaseName) && ukpWorkName.equals(thisWorkName);
            }

            public String getPhaseName20() {
                if (this.phaseName.length() > 20) {
                    return this.phaseName.substring(0, 19);
                }
                return this.phaseName;
            }

            public String getWorkName20() {
                if (this.workName.length() > 20) {
                    return this.workName.substring(0, 19);
                }
                return this.workName;
            }
        }
    }

    private class UpdateKintaiHeader {
        ArrayList<String> paramNameList = new ArrayList();

        UpdateKintaiHeader() {
            this.initParamNameList();
        }

        private void initParamNameList() {
            this.paramNameList.add("notifyStatus");
            this.paramNameList.add("ignoreUnload");
            this.paramNameList.add("employeeId");
            this.paramNameList.add("employeeName");
            this.paramNameList.add("YMD");
            this.paramNameList.add("searchYmd");
            this.paramNameList.add("kintaiProcessingDate");
            this.paramNameList.add("muCd");
            this.paramNameList.add("dispMonthDay");
            this.paramNameList.add("thisMonthDate");
            this.paramNameList.add("fiscalYear");
            this.paramNameList.add("detailPlanChangeFlag");
            this.paramNameList.add("detailResultChangeFlag");
            this.paramNameList.add("detailNoteChangeFlag");
            this.paramNameList.add("detailPrjChangeFlag");
            this.paramNameList.add("BShiftFlag");
            this.paramNameList.add("c1ShiftFlag");
            this.paramNameList.add("c2ShiftFlag");
            this.paramNameList.add("workCalendarDayFlag");
            this.paramNameList.add("defaultWorkPlaceCd");
            this.paramNameList.add("defaultPrjId");
            this.paramNameList.add("companyCd");
            this.paramNameList.add("changeAppKbnFlag");
            this.paramNameList.add("reloadCalendarFlag");
            this.paramNameList.add("addRestTime");
            this.paramNameList.add("planSickAndWoundLeave");
            this.paramNameList.add("resultSickAndWoundLeave");
            this.paramNameList.add("roundPatternDaily");
            this.paramNameList.add("roundThresholdDaily");
            this.paramNameList.add("roundPatternMonthly");
            this.paramNameList.add("roundThresholdMonthly");
            this.paramNameList.add("tomorrowHolidayFlag");
            this.paramNameList.add("autoHolidayFlag");
            this.paramNameList.add("workPatternCd");
            this.paramNameList.add("workFormCd");
            this.paramNameList.add("workInstructionCd");
            this.paramNameList.add("openingTime");
            this.paramNameList.add("closingTime");
            this.paramNameList.add("mastWorkedHours");
            this.paramNameList.add("mastRest");
            this.paramNameList.add("mastBShiftFlag");
            this.paramNameList.add("mastC1ShiftFlag");
            this.paramNameList.add("mastC2ShiftFlag");
            this.paramNameList.add("topOpeningTime");
            this.paramNameList.add("topClosingTime");
            this.paramNameList.add("topRestTime");
            this.paramNameList.add("topWorkedHours");
            this.paramNameList.add("schedulSize");
            this.paramNameList.add("hideResultApplicationKbnCd1");
            this.paramNameList.add("planApproval");
            this.paramNameList.add("planRest");
            this.paramNameList.add("planOvertime");
            this.paramNameList.add("planWorkedHours");
            this.paramNameList.add("planHolidayWorkTime");
            this.paramNameList.add("planStartHour");
            this.paramNameList.add("planStartMinute");
            this.paramNameList.add("planEndHour");
            this.paramNameList.add("planEndMinute");
            this.paramNameList.add("hidePlanStartHour");
            this.paramNameList.add("hidePlanStartMinute");
            this.paramNameList.add("hidePlanEndHour");
            this.paramNameList.add("hidePlanEndMinute");
            this.paramNameList.add("hideNote");
            this.paramNameList.add("planWorkPlaceCd");
            this.paramNameList.add("planApplicationKbnCd1");
            this.paramNameList.add("planApplicationKbnCd2");
            this.paramNameList.add("planApplicationKbnCd3");
            this.paramNameList.add("note");
            this.paramNameList.add("futureFlag");
            this.paramNameList.add("resultApproval");
            this.paramNameList.add("hideResultStartHour");
            this.paramNameList.add("hideResultStartMinute");
            this.paramNameList.add("hideResultEndHour");
            this.paramNameList.add("hideResultEndMinute");
            this.paramNameList.add("resultWorkPlaceCd");
            this.paramNameList.add("resultApplicationKbnCd1");
            this.paramNameList.add("resultApplicationKbnCd2");
            this.paramNameList.add("resultApplicationKbnCd3");
            this.paramNameList.add("nightShiftTimeHour");
            this.paramNameList.add("nightShiftTimeMinute");
            this.paramNameList.add("nightShiftTime");
            this.paramNameList.add("holidayWorkTimeHour");
            this.paramNameList.add("holidayWorkTimeMinute");
            this.paramNameList.add("holidayWorkTime");
            this.paramNameList.add("hideResultOvertime");
            this.paramNameList.add("hideResultRest");
            this.paramNameList.add("hideNightShiftTime");
            this.paramNameList.add("hideDeductionTime");
            this.paramNameList.add("beforeHolidayWorkTime");
            this.paramNameList.add("workedHours");
            this.paramNameList.add("deductionTimeHour");
            this.paramNameList.add("deductionTimeMinute");
            this.paramNameList.add("deductionTime");
        }

        public ArrayList<PostParamData> careateHeader(int formNo, FormAnalyser formInfo, boolean addStartEndTime, boolean addRestTime, OneDayScheduleData odsd) {
            ArrayList<PostParamData> paramList = new ArrayList<PostParamData>();
            paramList.add(new PostParamData("detailPrjChangeFlag", "1"));
            paramList.add(new PostParamData("detailResultChangeFlag", "1"));
            InputInfoHolder iih = null;
            iih = formInfo.getInputInfo(formNo, "planStartHour");
            if (iih != null) {
                paramList.add(new PostParamData("planStartHour", iih.getValue()));
            }
            iih = null;
            iih = formInfo.getInputInfo(formNo, "planStartMinute");
            if (iih != null) {
                paramList.add(new PostParamData("planStartMinute", iih.getValue()));
            }
            iih = null;
            iih = formInfo.getInputInfo(formNo, "planEndHour");
            if (iih != null) {
                paramList.add(new PostParamData("planEndHour", iih.getValue()));
            }
            iih = null;
            iih = formInfo.getInputInfo(formNo, "planEndMinute");
            if (iih != null) {
                paramList.add(new PostParamData("planEndMinute", iih.getValue()));
            }
            if (addStartEndTime) {
                paramList.add(new PostParamData("resultStartHour", odsd.getStartHH()));
                paramList.add(new PostParamData("resultStartMinute", odsd.getStartMM()));
                paramList.add(new PostParamData("resultEndHour", odsd.getEndHH()));
                paramList.add(new PostParamData("resultEndMinute", odsd.getEndMM()));
            } else {
                iih = null;
                iih = formInfo.getInputInfo(formNo, "resultStartHour");
                if (iih != null) {
                    paramList.add(new PostParamData("resultStartHour", iih.getValue()));
                }
                iih = null;
                iih = formInfo.getInputInfo(formNo, "resultStartMinute");
                if (iih != null) {
                    paramList.add(new PostParamData("resultStartMinute", iih.getValue()));
                }
                iih = null;
                iih = formInfo.getInputInfo(formNo, "resultEndHour");
                if (iih != null) {
                    paramList.add(new PostParamData("resultEndHour", iih.getValue()));
                }
                iih = null;
                iih = formInfo.getInputInfo(formNo, "resultEndMinute");
                if (iih != null) {
                    paramList.add(new PostParamData("resultEndMinute", iih.getValue()));
                }
            }
            if (addRestTime) {
                paramList.add(new PostParamData("resultRestHour", odsd.getRestTimeHH()));
                paramList.add(new PostParamData("resultRestMinute", odsd.getRestTimeMM()));
                paramList.add(new PostParamData("resultRest", odsd.getRestTimeByHour()));
            } else {
                iih = null;
                iih = formInfo.getInputInfo(formNo, "resultRestHour");
                if (iih != null) {
                    paramList.add(new PostParamData("resultRestHour", iih.getValue()));
                }
                iih = null;
                iih = formInfo.getInputInfo(formNo, "resultRestMinute");
                if (iih != null) {
                    paramList.add(new PostParamData("resultRestMinute", iih.getValue()));
                }
            }
            SelectInfoHolder sih = null;
            sih = formInfo.getSelectInfo(formNo, "planWorkPlaceCd");
            if (sih != null) {
                paramList.add(new PostParamData("planWorkPlaceCd", sih.getSelected().getValue()));
            }
            sih = null;
            sih = formInfo.getSelectInfo(formNo, "resultWorkPlaceCd");
            if (sih != null) {
                paramList.add(new PostParamData("resultWorkPlaceCd", sih.getSelected().getValue()));
            }
            sih = null;
            sih = formInfo.getSelectInfo(formNo, "planApplicationKbnCd1");
            if (sih != null) {
                paramList.add(new PostParamData("planApplicationKbnCd1", sih.getSelected().getValue()));
            }
            sih = null;
            sih = formInfo.getSelectInfo(formNo, "planApplicationKbnCd2");
            if (sih != null) {
                paramList.add(new PostParamData("planApplicationKbnCd2", sih.getSelected().getValue()));
            }
            sih = null;
            sih = formInfo.getSelectInfo(formNo, "planApplicationKbnCd3");
            if (sih != null) {
                paramList.add(new PostParamData("planApplicationKbnCd3", sih.getSelected().getValue()));
            }
            sih = null;
            sih = formInfo.getSelectInfo(formNo, "resultApplicationKbnCd1");
            if (sih != null) {
                paramList.add(new PostParamData("resultApplicationKbnCd1", sih.getSelected().getValue()));
            }
            sih = null;
            sih = formInfo.getSelectInfo(formNo, "resultApplicationKbnCd2");
            if (sih != null) {
                paramList.add(new PostParamData("resultApplicationKbnCd2", sih.getSelected().getValue()));
            }
            sih = null;
            sih = formInfo.getSelectInfo(formNo, "resultApplicationKbnCd3");
            if (sih != null) {
                paramList.add(new PostParamData("resultApplicationKbnCd3", sih.getSelected().getValue()));
            }
            InputInfoHolder textareaInfo = null;
            textareaInfo = formInfo.getTextareaInfo(formNo, "note");
            if (textareaInfo != null) {
                paramList.add(new PostParamData("note", textareaInfo.getValue()));
            }
            return paramList;
        }
    }
}

