/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.GoogleBaseAttributesExtension;
import com.google.api.gbase.client.GoogleBaseEntry;
import com.google.api.gbase.client.GoogleBaseFeed;
import com.google.api.gbase.client.GoogleBaseMediaEntry;
import com.google.api.gbase.client.GoogleBaseMediaFeed;
import com.google.api.gbase.client.GoogleBaseNamespaces;
import com.google.gdata.client.Query;
import com.google.gdata.client.Service;
import com.google.gdata.client.batch.BatchInterruptedException;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.batch.BatchOperationType;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.Version;
import java.io.IOException;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleBaseService
extends MediaService {
    public static final String GOOGLE_BASE_SERVICE = "gbase";
    public static final String GOOGLE_BASE_SERVICE_VERSION = "GBase-Java/" + GoogleBaseService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(GoogleBaseService.class, Versions.V2);
    protected String application;

    public GoogleBaseService(String applicationName) {
        super(GOOGLE_BASE_SERVICE, applicationName);
        this.application = applicationName;
        this.addExtensions();
    }

    public GoogleBaseService(String applicationName, String developerKey) {
        this(applicationName);
    }

    public GoogleBaseService(String applicationName, String protocol, String domainName) {
        super(GOOGLE_BASE_SERVICE, applicationName, protocol, domainName);
        this.application = applicationName;
        this.addExtensions();
    }

    public GoogleBaseService(String applicationName, String developerKey, String protocol, String domainName) {
        this(applicationName, protocol, domainName);
    }

    public GoogleBaseFeed getFeed(URL feedUrl, DateTime ifModifiedSince) throws IOException, ServiceException {
        return (GoogleBaseFeed)this.getFeed(feedUrl, GoogleBaseFeed.class, ifModifiedSince);
    }

    public GoogleBaseFeed getFeed(URL feedUrl) throws IOException, ServiceException {
        return (GoogleBaseFeed)this.getFeed(feedUrl, GoogleBaseFeed.class);
    }

    public GoogleBaseMediaFeed getMediaFeed(URL feedUrl) throws IOException, ServiceException {
        return (GoogleBaseMediaFeed)((Object)this.getFeed(feedUrl, GoogleBaseMediaFeed.class));
    }

    public GoogleBaseMediaFeed getMediaFeed(URL feedUrl, DateTime ifModifiedSince) throws IOException, ServiceException {
        return (GoogleBaseMediaFeed)((Object)this.getFeed(feedUrl, GoogleBaseMediaFeed.class, ifModifiedSince));
    }

    public GoogleBaseEntry getEntry(URL entryUrl, DateTime ifModifiedSince) throws IOException, ServiceException {
        return (GoogleBaseEntry)this.getEntry(entryUrl, GoogleBaseEntry.class, ifModifiedSince);
    }

    public GoogleBaseEntry getEntry(URL entryUrl) throws IOException, ServiceException {
        return (GoogleBaseEntry)this.getEntry(entryUrl, GoogleBaseEntry.class);
    }

    public GoogleBaseMediaEntry getMediaEntry(URL entryUrl) throws IOException, ServiceException {
        return (GoogleBaseMediaEntry)((Object)this.getEntry(entryUrl, GoogleBaseMediaEntry.class));
    }

    public GoogleBaseMediaEntry getMediaEntry(URL entryUrl, DateTime ifModifiedSince) throws IOException, ServiceException {
        return (GoogleBaseMediaEntry)((Object)this.getEntry(entryUrl, GoogleBaseMediaEntry.class, ifModifiedSince));
    }

    public GoogleBaseFeed query(Query query, DateTime ifModifiedSince) throws IOException, ServiceException {
        return (GoogleBaseFeed)this.query(query, GoogleBaseFeed.class, ifModifiedSince);
    }

    public GoogleBaseFeed query(Query query) throws IOException, ServiceException {
        return (GoogleBaseFeed)this.query(query, GoogleBaseFeed.class);
    }

    public <E extends IEntry> E update(URL url, E e) throws IOException, ServiceException {
        this.addApplicationAttribute(e);
        return (E)super.update(url, e);
    }

    public <E extends IEntry> E insert(URL url, E e) throws IOException, ServiceException {
        this.addApplicationAttribute(e);
        return (E)super.insert(url, e);
    }

    public <F extends IFeed> F batch(URL url, F f) throws IOException, ServiceException, BatchInterruptedException {
        this.addApplicationAttribute(f);
        return (F)super.batch(url, f);
    }

    private void addApplicationAttribute(IEntry iEntry) {
        if (!(iEntry instanceof BaseEntry)) {
            throw new IllegalArgumentException("Unexpected entry type: " + iEntry.getClass());
        }
        BaseEntry e = (BaseEntry)iEntry;
        GoogleBaseAttributesExtension attrs = e.getExtension(GoogleBaseAttributesExtension.class);
        if (attrs == null) {
            return;
        }
        attrs.setApplication(this.application);
    }

    private void addApplicationAttribute(IFeed iFeed) {
        if (!(iFeed instanceof BaseFeed)) {
            throw new IllegalArgumentException("Unexpected feed type: " + iFeed);
        }
        BaseFeed batchFeed = (BaseFeed)iFeed;
        BatchOperationType defaultType = BatchUtils.getBatchOperationType(batchFeed);
        if (defaultType == null) {
            defaultType = BatchOperationType.INSERT;
        }
        List entries = batchFeed.getEntries();
        for (BaseEntry entry : entries) {
            BatchOperationType type = BatchUtils.getBatchOperationType(entry);
            if (type == null) {
                type = defaultType;
            }
            if (type != BatchOperationType.INSERT && type != BatchOperationType.UPDATE) continue;
            this.addApplicationAttribute(entry);
        }
    }

    private void addExtensions() {
        ExtensionProfile extensionProfile = this.getExtensionProfile();
        GoogleBaseNamespaces.declareAllExtensions(extensionProfile);
        BatchUtils.declareExtensions(extensionProfile);
    }

    public String getServiceVersion() {
        return GOOGLE_BASE_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static class Versions {
        public static final Version V1 = new Version(GoogleBaseService.class, "1.0", Service.Versions.V1);
        public static final Version V2 = new Version(GoogleBaseService.class, "2.0", Service.Versions.V2);
    }
}

