/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Serialization;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractImmutableMultimap<K, V, C extends ImmutableCollection<V>>
implements Multimap<K, V>,
Serializable {
    final transient ImmutableMap<K, C> map;
    final transient int size;
    private transient ImmutableCollection<Map.Entry<K, V>> entries;
    private transient ImmutableMultiset<K> keys;
    private transient ImmutableCollection<V> values;

    AbstractImmutableMultimap(ImmutableMap<K, C> map, int size) {
        this.map = map;
        this.size = size;
    }

    public C removeAll(Object key) {
        throw new UnsupportedOperationException();
    }

    public C replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Collection values = (Collection)this.map.get(key);
        return values != null && values.contains(value);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        for (ImmutableCollection valueCollection : this.map.values()) {
            if (!valueCollection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return this.map.equals(that.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public ImmutableMap<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    public ImmutableCollection<Map.Entry<K, V>> entries() {
        ImmutableCollection<Map.Entry<K, V>> result = this.entries;
        return result == null ? (this.entries = new EntryCollection(this)) : result;
    }

    @Override
    public ImmutableMultiset<K> keys() {
        ImmutableMultiset<K> result = this.keys;
        return result == null ? (this.keys = new ImmutableMultiset(new CountMap(this), this.size)) : result;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> result = this.values;
        return result == null ? (this.values = new Values(this)) : result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values<V>
    extends ImmutableCollection<V> {
        final Multimap<?, V> multimap;
        private static final long serialVersionUID = 0L;

        Values(Multimap<?, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            final Iterator<Map.Entry<?, V>> entryIterator = this.multimap.entries().iterator();
            return new UnmodifiableIterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIterator.next()).getValue();
                }
            };
        }

        @Override
        public int size() {
            return this.multimap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountMap<K, V, C extends ImmutableCollection<V>>
    extends ImmutableMap<K, Integer> {
        final AbstractImmutableMultimap<K, V, C> multimap;
        transient ImmutableSet<Map.Entry<K, Integer>> entrySet;
        private static final long serialVersionUID = 0L;

        CountMap(AbstractImmutableMultimap<K, V, C> multimap) {
            this.multimap = multimap;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.multimap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new AssertionError();
        }

        @Override
        public Integer get(Object key) {
            Collection valueCollection = (Collection)this.multimap.map.get(key);
            return valueCollection == null ? 0 : valueCollection.size();
        }

        @Override
        public ImmutableSet<K> keySet() {
            return this.multimap.keySet();
        }

        @Override
        public ImmutableCollection<Integer> values() {
            throw new AssertionError();
        }

        @Override
        public boolean isEmpty() {
            return this.multimap.isEmpty();
        }

        @Override
        public int size() {
            return this.multimap.map.size();
        }

        @Override
        public ImmutableSet<Map.Entry<K, Integer>> entrySet() {
            ImmutableSet<Map.Entry<K, Integer>> result = this.entrySet;
            return result == null ? (this.entrySet = new EntrySet<K, V, C>(this.multimap)) : result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class EntrySet<K, V, C extends ImmutableCollection<V>>
        extends ImmutableSet<Map.Entry<K, Integer>> {
            final AbstractImmutableMultimap<K, V, C> multimap;
            private static final long serialVersionUID = 0L;

            EntrySet(AbstractImmutableMultimap<K, V, C> multimap) {
                this.multimap = multimap;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<K, Integer>> iterator() {
                final Iterator mapIterator = ((ImmutableSet)this.multimap.map.entrySet()).iterator();
                return new UnmodifiableIterator<Map.Entry<K, Integer>>(){

                    @Override
                    public boolean hasNext() {
                        return mapIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Integer> next() {
                        Map.Entry entry = (Map.Entry)mapIterator.next();
                        return Maps.immutableEntry(entry.getKey(), ((ImmutableCollection)entry.getValue()).size());
                    }
                };
            }

            @Override
            public int size() {
                return this.multimap.map.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryCollection<K, V, C extends ImmutableCollection<V>>
    extends ImmutableCollection<Map.Entry<K, V>> {
        final AbstractImmutableMultimap<K, V, C> multimap;
        private static final long serialVersionUID = 0L;

        EntryCollection(AbstractImmutableMultimap<K, V, C> multimap) {
            this.multimap = multimap;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            final Iterator mapIterator = ((ImmutableSet)this.multimap.map.entrySet()).iterator();
            return new UnmodifiableIterator<Map.Entry<K, V>>(){
                K key;
                Iterator<V> valueIterator;

                @Override
                public boolean hasNext() {
                    return this.key != null && this.valueIterator.hasNext() || mapIterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.key == null || !this.valueIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)mapIterator.next();
                        this.key = entry.getKey();
                        this.valueIterator = ((ImmutableCollection)entry.getValue()).iterator();
                    }
                    return Maps.immutableEntry(this.key, this.valueIterator.next());
                }
            };
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }
    }

    static class FieldSettersHolder {
        static final Serialization.FieldSetter<AbstractImmutableMultimap> MAP_FIELD_SETTER = Serialization.getFieldSetter(AbstractImmutableMultimap.class, "map");
        static final Serialization.FieldSetter<AbstractImmutableMultimap> SIZE_FIELD_SETTER = Serialization.getFieldSetter(AbstractImmutableMultimap.class, "size");

        FieldSettersHolder() {
        }
    }
}

