/*
 * Decompiled with CFR 0.152.
 */
package config;

import config.ui.ButtonPanel;
import config.ui.ConfigPanel;
import configInfo.GaroonUserConfig;
import configInfo.JSchedulerConfig;
import configInfo.JschedulerDigesterCtl;
import configInfo.ProjectUnitConfig;
import configInfo.ProjectUnitConfigs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.io.BeanWriter;
import org.xml.sax.SAXException;

public class ConfigDialog
extends JDialog
implements ActionListener {
    private ConfigPanel cfgPanel;
    private ButtonPanel btnPanel;
    private JSchedulerConfig jconfig;
    private String configFileName;
    private File configFile;
    private boolean isButtonPressed;

    public boolean isButtonPressed() {
        return this.isButtonPressed;
    }

    public ConfigDialog(Frame owner, String configFileName) {
        this(owner, configFileName, "mScheduler\u8a2d\u5b9a - " + configFileName);
    }

    public ConfigDialog(Frame owner, String configFileName, String title) {
        super(owner, title, true);
        this.configFileName = configFileName;
        this.configFile = new File(configFileName);
        this.init();
    }

    private void init() {
        this.createComponents();
        this.loadConfig();
        this.setConfig();
    }

    private void setConfig() {
        this.cfgPanel.setScheduleFileName(this.jconfig.getJSchedulerDataConfig().getFileName());
        this.cfgPanel.setUserName(this.jconfig.getJSchedulerDataConfig().getUserName());
        this.cfgPanel.setGaroonUserId(this.jconfig.getGaroonConfig().getUser_id());
        this.cfgPanel.setGaroonPassword(this.jconfig.getGaroonConfig().getPassword());
        this.cfgPanel.setAtmuoUserId(this.jconfig.getAtmuo_config().getUser_id());
        this.cfgPanel.setAtmuoPassword(this.jconfig.getAtmuo_config().getPass_word());
        this.cfgPanel.setAtmuoCompanyCode(this.jconfig.getAtmuo_config().getCompany_code());
        this.cfgPanel.setAtmuoCompanyName(this.jconfig.getAtmuo_config().getCompany_name());
        this.cfgPanel.setHorizontalRatio(this.jconfig.get_month_panel_config().getHolizontal_ratio());
        this.cfgPanel.setGridMinute(this.jconfig.get_month_panel_config().getDnd_ratio());
        this.cfgPanel.setStartHour(this.jconfig.get_month_panel_config().getStart_HH());
        this.cfgPanel.setEndHour(this.jconfig.get_month_panel_config().getEnd_HH());
        for (GaroonUserConfig config : this.jconfig.getGaroon_user_configs().getGaroonUserConfigList()) {
            this.cfgPanel.addGaroonUserFileName(config.getFileName());
        }
        ProjectUnitConfigs prjunits = this.jconfig.getProjectUnitConfigs();
        for (ProjectUnitConfig prjunit : prjunits.getProjectUnitConfigList()) {
            this.cfgPanel.addPrjUnitFileName(prjunit.getFileName());
        }
        this.cfgPanel.setNotesIDFileName(this.jconfig.getNotesConfig().getNotesIdFile());
        this.cfgPanel.setNotesPassword(this.jconfig.getNotesConfig().getPassword());
        this.cfgPanel.setNotesServerName(this.jconfig.getNotesConfig().getNotesServer());
        this.cfgPanel.setNotesDBName(this.jconfig.getNotesConfig().getNotesFile());
    }

    private void loadConfig() {
        JschedulerDigesterCtl c = new JschedulerDigesterCtl();
        this.jconfig = c.configRead(this.configFileName);
    }

    private void createComponents() {
        this.cfgPanel = new ConfigPanel();
        this.btnPanel = new ButtonPanel();
        this.btnPanel.getBtnOK().addActionListener(this);
        this.btnPanel.getBtnCancel().addActionListener(this);
        JLabel label = new JLabel("\u203b\u5909\u66f4\u306e\u53cd\u6620\u306b\u306f\u518d\u8d77\u52d5\u304c\u5fc5\u8981\u3067\u3059");
        label.setForeground(Color.RED);
        this.setLayout(new BorderLayout());
        this.add((Component)label, "North");
        this.add((Component)this.cfgPanel, "Center");
        this.add((Component)this.btnPanel, "South");
        this.setResizable(false);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnPanel.getBtnOK()) {
            this.setConfigBean();
            try {
                this.backupConfig();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog((Component)e.getSource(), "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\n" + this.configFile.getAbsolutePath(), "error", 0);
                e1.printStackTrace();
            }
            try {
                this.saveConfig();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog((Component)e.getSource(), "\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u8fbc\u307f\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\n" + this.configFile.getAbsolutePath(), "error", 0);
                e1.printStackTrace();
            }
        }
        this.isButtonPressed = true;
        this.dispose();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("\u5f15\u6570\u306b\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        final String filename = args[0];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ConfigDialog.setLookAndFeel();
                ConfigDialog main = new ConfigDialog((Frame)frame, filename, "mScheduler\u8a2d\u5b9a - " + filename);
                main.setVisible(true);
                frame.dispose();
            }
        });
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void backupConfig() throws IOException {
        String distDir = this.configFile.getAbsoluteFile().getParent();
        File distFile = new File(distDir, String.valueOf(this.configFile.getName()) + ".bak");
        FileChannel sch = new FileInputStream(this.configFile).getChannel();
        FileChannel dch = new FileOutputStream(distFile).getChannel();
        try {
            sch.transferTo(0L, sch.size(), dch);
        }
        finally {
            sch.close();
            dch.close();
        }
    }

    private void setConfigBean() {
        this.jconfig.getJSchedulerDataConfig().setFile_name(this.cfgPanel.getScheduleFileName());
        this.jconfig.getJSchedulerDataConfig().setUser_name(this.cfgPanel.getUserName());
        this.jconfig.getGaroonConfig().setUser_id(this.cfgPanel.getGaroonUserId());
        this.jconfig.getGaroonConfig().setPassword(this.cfgPanel.getGaroonPassword());
        this.jconfig.getAtmuo_config().setUser_id(this.cfgPanel.getAtmuoUserId());
        this.jconfig.getAtmuo_config().setPass_word(this.cfgPanel.getAtmuoPassword());
        this.jconfig.getAtmuo_config().setCompany_code(this.cfgPanel.getAtmuoCompanyCode());
        this.jconfig.getAtmuo_config().setCompany_name(this.cfgPanel.getAtmuoCompanyName());
        this.jconfig.get_month_panel_config().setHolizontal_ratio(this.cfgPanel.getHorizontalRatio());
        this.jconfig.get_month_panel_config().setDnd_ratio(this.cfgPanel.getGridMinute());
        this.jconfig.get_month_panel_config().setStart_HH(this.cfgPanel.getStartHour());
        this.jconfig.get_month_panel_config().setEnd_HH(this.cfgPanel.getEndHour());
        ArrayList<GaroonUserConfig> garoonUserConfs = new ArrayList<GaroonUserConfig>();
        Enumeration<String> garoonUserFileNames = this.cfgPanel.getGaroonUserFileNames();
        while (garoonUserFileNames.hasMoreElements()) {
            GaroonUserConfig conf = new GaroonUserConfig();
            conf.setFile_name(garoonUserFileNames.nextElement());
            garoonUserConfs.add(conf);
        }
        this.jconfig.getGaroon_user_configs().setGaroonUserConfigList(garoonUserConfs);
        ArrayList<ProjectUnitConfig> prjUnitConfs = new ArrayList<ProjectUnitConfig>();
        Enumeration<String> prjUnitFileNames = this.cfgPanel.getPrjUnitFileNames();
        while (prjUnitFileNames.hasMoreElements()) {
            ProjectUnitConfig conf = new ProjectUnitConfig();
            conf.setFile_name(prjUnitFileNames.nextElement());
            prjUnitConfs.add(conf);
        }
        this.jconfig.getProjectUnitConfigs().setProjectUnitConfigList(prjUnitConfs);
        this.jconfig.getNotesConfig().setNotes_id_file(this.cfgPanel.getNotesIDFileName());
        this.jconfig.getNotesConfig().setPassword(this.cfgPanel.getNotesPassword());
        this.jconfig.getNotesConfig().setNotes_server(this.cfgPanel.getNotesServerName());
        this.jconfig.getNotesConfig().setNotes_file(this.cfgPanel.getNotesDBName());
    }

    private void saveConfig() throws IOException {
        BindingConfiguration bconf = new BindingConfiguration();
        bconf.setMapIDs(false);
        BeanWriter writer = new BeanWriter((Writer)new FileWriter(this.configFile));
        writer.setBindingConfiguration(bconf);
        writer.enablePrettyPrint();
        writer.writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
        try {
            writer.write((Object)this.jconfig);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        writer.close();
    }
}

