/*
 * Decompiled with CFR 0.152.
 */
package config.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class FileListEditorPanel
extends JPanel {
    private static final String BTN_ADD_TEXT = "\u8ffd\u52a0...";
    private static final String BTN_DEL_TEXT = "\u524a\u9664";
    JList list;
    JFileChooser chooser;

    public FileListEditorPanel(JList list) {
        this.list = list;
        this.chooser = new JFileChooser();
        JScrollPane scroller = new JScrollPane(this.list);
        scroller.setPreferredSize(new Dimension(300, 100));
        JPanel panelBtn = new JPanel();
        panelBtn.setLayout(new BoxLayout(panelBtn, 1));
        JButton btnAdd = new JButton(BTN_ADD_TEXT);
        btnAdd.addActionListener(new AddBtnListener());
        JButton btnDel = new JButton(BTN_DEL_TEXT);
        btnDel.addActionListener(new DelBtnListener());
        panelBtn.add(btnAdd);
        panelBtn.add(btnDel);
        this.setLayout(new FlowLayout());
        this.add(scroller);
        this.add(panelBtn);
        Dimension size = this.getPreferredSize();
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
    }

    public FileListEditorPanel(JList list, FileFilter filter) {
        this(list);
        this.chooser.setFileFilter(filter);
    }

    private class AddBtnListener
    implements ActionListener {
        private AddBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rtn = FileListEditorPanel.this.chooser.showOpenDialog((Component)e.getSource());
            if (rtn == 0) {
                ((DefaultListModel)FileListEditorPanel.this.list.getModel()).addElement(FileListEditorPanel.this.chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class DelBtnListener
    implements ActionListener {
        private DelBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FileListEditorPanel.this.list.isSelectionEmpty()) {
                ((DefaultListModel)FileListEditorPanel.this.list.getModel()).remove(FileListEditorPanel.this.list.getSelectedIndex());
            }
        }
    }
}

