/*
 * Decompiled with CFR 0.152.
 */
package evmResultData;

import java.text.DecimalFormat;
import scheduleData.DateInfo;

public class OneEvmResultData {
    private String phaseCodeName;
    private DateInfo resultStartDateInfo = new DateInfo("0000", "00", "00", "00", "00");
    private DateInfo resultEndDateInfo = new DateInfo("", "", "", "", "");
    private int resultWorkTime;
    private int progressRatio;

    public OneEvmResultData(String phaseCodeName) {
        this.phaseCodeName = new String(phaseCodeName);
        this.resultWorkTime = 0;
        this.progressRatio = 0;
    }

    public void addResult(DateInfo di, int workTime, int progressRatio) {
        if (this.resultStartDateInfo.compareDateInfo(di) == -1) {
            this.resultStartDateInfo = (DateInfo)di.clone();
        }
        this.resultWorkTime += workTime;
        if (this.progressRatio < progressRatio) {
            this.progressRatio = progressRatio;
        }
        if (progressRatio == 100) {
            this.resultEndDateInfo = (DateInfo)di.clone();
        }
    }

    public DateInfo getStartDateInfo() {
        return this.resultStartDateInfo;
    }

    public DateInfo getEndDateInfo() {
        return this.resultEndDateInfo;
    }

    public String getPhaseCodeName() {
        return this.phaseCodeName;
    }

    public int getWorkTime() {
        return this.resultWorkTime;
    }

    public String getWorkTimeHour() {
        if (this.resultWorkTime == 0) {
            return "";
        }
        DecimalFormat df = new DecimalFormat();
        df.applyLocalizedPattern("#0.00");
        return df.format(this.resultWorkTime / 60);
    }

    public int getProgressRatio() {
        return this.progressRatio;
    }
}

