/*
 * Decompiled with CFR 0.152.
 */
package garoonSchedule;

import configInfo.GaroonConfig;
import garoonSession.GaroonAdd;
import garoonSession.GaroonHeaderInfo;
import garoonSession.GaroonHttpResult;
import garoonSession.GaroonLightMonthSchedule;
import garoonSession.GaroonLogin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;

public class GaroonScheduleData4SOA {
    private ArrayList<ScheduleData> scheduleList = new ArrayList();
    private boolean scheduleReaded = false;
    private GaroonHeaderInfo h_info = new GaroonHeaderInfo();
    private DateInfo scopeDateInfo;
    private GaroonConfig garoonConfig;

    public GaroonScheduleData4SOA(GaroonConfig garoonConfig, DateInfo di) {
        this.garoonConfig = garoonConfig;
        this.scopeDateInfo = di;
    }

    public int schedule_read(String yyyy, String mm, String dd, String[] userIdList) {
        DateInfo di = new DateInfo(yyyy, mm, dd, "00", "00");
        GaroonLogin g_login = new GaroonLogin();
        GaroonHttpResult h_result = g_login.garoon_login(this.garoonConfig.getUrl_login(), this.garoonConfig.getUser_id(), this.garoonConfig.getPassword());
        if (h_result.result < 0) {
            System.err.println(String.valueOf(this.getClass().getName()) + " schedule_read garoon_login error " + h_result.result);
            return -1;
        }
        this.h_info = h_result.headerInfo;
        while (this.checkScope(this.scopeDateInfo, di.getYyyy(), di.getMm())) {
            int i = 0;
            while (i < userIdList.length) {
                GaroonLightMonthSchedule glms = new GaroonLightMonthSchedule();
                h_result = glms.read(this.garoonConfig.getUrl_month(), this.h_info.getCookieManager(), userIdList[i], this.h_info.gid, di.getYyyy(), di.getMm(), di.getDd());
                if (h_result.result < 0) {
                    System.err.println("readMonthSchedule failed. index:" + i);
                }
                Iterator<ScheduleData> j = glms.getScheduleList().iterator();
                while (j.hasNext()) {
                    this.scheduleList.add(j.next());
                }
                ++i;
            }
            di.incrementMm();
        }
        this.scheduleReaded = true;
        return 0;
    }

    public int schedule_add(String url_name, List<ScheduleData> schedule_list) {
        Iterator<ScheduleData> i = schedule_list.iterator();
        while (i.hasNext()) {
            GaroonAdd g_add = new GaroonAdd();
            ScheduleData sd = i.next();
            GaroonHttpResult h_result = g_add.add(url_name, this.h_info, sd);
            this.scheduleList.add(sd);
            this.h_info = h_result.headerInfo;
        }
        return 0;
    }

    public ArrayList<ScheduleData> getScheduleList() {
        return this.scheduleList;
    }

    private boolean checkScope(DateInfo scopeDateInfo, String yyyy, String mm) {
        int scope = Integer.valueOf(scopeDateInfo.getYyyy()) * 10 + Integer.valueOf(scopeDateInfo.getMm());
        int target = Integer.valueOf(yyyy) * 10 + Integer.valueOf(mm);
        return target <= scope;
    }

    public boolean isScheduleReaded() {
        return this.scheduleReaded;
    }

    public void printAll() {
        int count = 0;
        System.out.println("---- GaroonScheduleData4SOA");
        for (ScheduleData sd : this.scheduleList) {
            System.out.println("[" + count + "] " + sd.getS_date().createDateInfoKey() + "-" + sd.getE_date().createDateInfoKey() + "," + sd.getTitle());
            ++count;
        }
    }
}

