/*
 * Decompiled with CFR 0.152.
 */
package garoonUserInfo;

import commonData.UserInfo;
import configInfo.GaroonUserConfig;
import configInfo.GaroonUserConfigs;
import garoonUserInfo.GaroonUserIndex;
import garoonUserInfo.GaroonUserIndexes;
import garoonUserInfo.GaroonUserIndexesDigesterCtl;
import userInfoData.UserInfoData;

public class GaroonUserIndexCreator {
    public int createGaroonUserIndex(GaroonUserConfigs gucs, UserInfoData userInfoData) {
        UserInfo garoonRootUserInfo = this.createGaroonRootUser(userInfoData);
        for (GaroonUserConfig guc : gucs.getGaroonUserConfigList()) {
            this.analyseGaroonUserConfig(guc, garoonRootUserInfo);
        }
        return 0;
    }

    private UserInfo createGaroonRootUser(UserInfoData userInfoData) {
        UserInfo garoonRootUser = new UserInfo("garoon_root", "Garoon\u30e6\u30fc\u30b6", false, false, false);
        garoonRootUser.setGaoonUser(true);
        garoonRootUser.setHasScheduleData(false);
        UserInfo targetUserInfo = userInfoData.getRootUserInfo().serchUserInfo(garoonRootUser);
        if (targetUserInfo == null) {
            userInfoData.getRootUserInfo().add(garoonRootUser);
            targetUserInfo = garoonRootUser;
        }
        return targetUserInfo;
    }

    private void analyseGaroonUserConfig(GaroonUserConfig guc, UserInfo garoonRootUserInfo) {
        GaroonUserIndexesDigesterCtl guidc;
        GaroonUserIndexes gui;
        if (!guc.getFileName().equals("") && (gui = (guidc = new GaroonUserIndexesDigesterCtl()).executeParse(guc.getFileName())) != null) {
            this.createUserInfo(guc, gui, garoonRootUserInfo);
        }
    }

    private void createUserInfo(GaroonUserConfig guc, GaroonUserIndexes gui, UserInfo userInfo) {
        UserInfo mySelfUserInfo = new UserInfo(guc.getUser_name(), guc.getUser_name(), false, false, false);
        mySelfUserInfo.setGaoonUser(true);
        if (guc.getParentName().equals("")) {
            userInfo.add(mySelfUserInfo);
        } else {
            UserInfo targetUserInfo = userInfo.serchUserInfoByUserId(guc.getParentName());
            if (targetUserInfo != null) {
                targetUserInfo.add(mySelfUserInfo);
            } else {
                userInfo.add(mySelfUserInfo);
            }
        }
        this.addGaroonUserInfoList(mySelfUserInfo, gui);
    }

    private void addGaroonUserInfoList(UserInfo currentUserInfo, GaroonUserIndexes guies) {
        for (GaroonUserIndex gui : guies.getUserIndex()) {
            this.addGaroonUserInfo2(currentUserInfo, gui);
        }
    }

    private UserInfo addGaroonUserInfo2(UserInfo currentUserInfo, GaroonUserIndex gui) {
        UserInfo mySelfUserInfo = new UserInfo(gui.getGaroonUserId(), gui.getGaroonUserName(), false, true, true);
        mySelfUserInfo.setGaoonUser(true);
        mySelfUserInfo.setGaroonUid(gui.getGaroonUserId());
        mySelfUserInfo.setGaroonGid(gui.getGaroonGroupId());
        currentUserInfo.add(mySelfUserInfo);
        for (GaroonUserIndex lgui : gui) {
            this.addGaroonUserInfo2(mySelfUserInfo, lgui);
        }
        return mySelfUserInfo;
    }
}

