/*
 * Decompiled with CFR 0.152.
 */
package ithdSchedulerUserInfo;

import commonData.UserInfo;
import configInfo.IthdSchedulerUserConfig;
import configInfo.IthdSchedulerUserConfigs;
import ithdSchedulerUserInfo.IthdSchedulerUserIndex;
import ithdSchedulerUserInfo.IthdSchedulerUserIndexes;
import ithdSchedulerUserInfo.IthdSchedulerUserIndexesDigesterCtl;
import userInfoData.UserInfoData;

public class IthdSchedulerUserIndexCreator {
    public int createIthdSchdulerUserIndex(IthdSchedulerUserConfigs isucs, UserInfoData userInfoData) {
        UserInfo ithdSchedulerRootUserInfo = this.createIthdSchedulerRootUser(userInfoData);
        for (IthdSchedulerUserConfig isuc : isucs.getIthdSchedulerUserConfigList()) {
            this.analyseIthdSchedulerUserConfig(isuc, ithdSchedulerRootUserInfo);
        }
        return 0;
    }

    private UserInfo createIthdSchedulerRootUser(UserInfoData userInfoData) {
        UserInfo ithdSchedulerRootUser = new UserInfo("ithdScheduler_root", "ITHDScheduler", false, false, false);
        ithdSchedulerRootUser.setGaoonUser(true);
        ithdSchedulerRootUser.setHasScheduleData(false);
        UserInfo targetUserInfo = userInfoData.getRootUserInfo().serchUserInfo(ithdSchedulerRootUser);
        if (targetUserInfo == null) {
            userInfoData.getRootUserInfo().add(ithdSchedulerRootUser);
            targetUserInfo = ithdSchedulerRootUser;
        }
        return targetUserInfo;
    }

    private void analyseIthdSchedulerUserConfig(IthdSchedulerUserConfig isuc, UserInfo ithdSchedulerRootUserInfo) {
        IthdSchedulerUserIndexesDigesterCtl isuidc;
        IthdSchedulerUserIndexes isui;
        if (!isuc.getFileName().equals("") && (isui = (isuidc = new IthdSchedulerUserIndexesDigesterCtl()).executeParse(isuc.getFileName())) != null) {
            this.createUserInfo(isuc, isui, ithdSchedulerRootUserInfo);
        }
    }

    private void createUserInfo(IthdSchedulerUserConfig isuc, IthdSchedulerUserIndexes isui, UserInfo userInfo) {
        UserInfo mySelfUserInfo = new UserInfo(isuc.getUser_name(), isuc.getUser_name(), false, false, false);
        mySelfUserInfo.setGaoonUser(true);
        userInfo.add(mySelfUserInfo);
        this.addIthdSchedulerUserIndexes(mySelfUserInfo, isui);
    }

    private void addIthdSchedulerUserIndexes(UserInfo currentUserInfo, IthdSchedulerUserIndexes isuis) {
        for (IthdSchedulerUserIndex isui : isuis.getIthdSchedulerUserIndexList()) {
            this.addIthdSchedulerUserInfo(currentUserInfo, isui);
        }
    }

    private UserInfo addIthdSchedulerUserInfo(UserInfo currentUserInfo, IthdSchedulerUserIndex isui) {
        UserInfo mySelfUserInfo = new UserInfo(isui.getUser_id(), isui.getUser_name(), false, true, true);
        mySelfUserInfo.setIthdSchedulerUser(true);
        mySelfUserInfo.setIthdUserid(isui.getUser_id());
        mySelfUserInfo.setIthdCompany(isui.getCompany());
        mySelfUserInfo.setIthdBusho(isui.getBusho());
        mySelfUserInfo.setIthdCAkubun(isui.getCAkubun());
        mySelfUserInfo.setIthdCSite(isui.getCSite());
        if (isui.getIsConferenceRoom() != null && isui.getIsConferenceRoom().equals("true")) {
            mySelfUserInfo.setConferenceRoom(true);
            mySelfUserInfo.setEditMode(true);
        }
        currentUserInfo.add(mySelfUserInfo);
        for (IthdSchedulerUserIndex lisui : isui) {
            this.addIthdSchedulerUserInfo(mySelfUserInfo, lisui);
        }
        return mySelfUserInfo;
    }
}

