/*
 * Decompiled with CFR 0.152.
 */
package ithdSession;

import commonData.HHMMHolder;
import commonData.ThSync;
import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import configInfo.IthdSchedulerConfig;
import ithdSession.IBISOneDayReaderListener;
import ithdSession.IthdAuthData;
import ithdSession.IthdScheduleInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scheduleData.ScheduleData;
import sessionCommon.HttpSession;

public class IBISOneDayReader
implements Runnable {
    private IthdSchedulerConfig isc;
    private ArrayList<ScheduleData> scheduleDataList;
    private UserInfo userInfo;
    private YyyyMmDdHolder yyyyMmDd;
    private IBISOneDayReaderListener iorl;
    private ThSync thSync;

    public IBISOneDayReader(IthdSchedulerConfig isc, UserInfo userInfo, YyyyMmDdHolder yyyyMmDd, IBISOneDayReaderListener iorl, ThSync thSync) {
        this.isc = isc;
        this.userInfo = userInfo;
        this.yyyyMmDd = yyyyMmDd;
        this.iorl = iorl;
        this.thSync = thSync;
        this.scheduleDataList = new ArrayList();
    }

    @Override
    public void run() {
        this.thSync.addCount();
        this.readOneDetailSchedule(this.yyyyMmDd);
        this.iorl.sendScheduleDataList(this.scheduleDataList);
        this.thSync.delCount();
    }

    public int readOneDetailSchedule(YyyyMmDdHolder yyyyMmDd) {
        HttpURLConnection urlConnection;
        block4: {
            HttpSession gcon = new HttpSession();
            urlConnection = gcon.create_connection(this.createDetailUrl(yyyyMmDd));
            if (urlConnection == null) {
                return -1;
            }
            IthdAuthData iad = new IthdAuthData(this.isc);
            urlConnection.setRequestProperty("Authorization", iad.createAuthorizationString());
            try {
                urlConnection.setRequestMethod("GET");
                if (urlConnection.getResponseCode() == 200) break block4;
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        BufferedReader buff = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "JISAutoDetect"));
        this.extractScheduleData(buff, yyyyMmDd);
        return 0;
    }

    private String createDetailUrl(YyyyMmDdHolder yyyyMmDd) {
        String result = "";
        result = this.isc.getUrlMonth();
        result = String.valueOf(result) + IthdScheduleInfo.createCScheduleInfo(this.isc, this.userInfo, yyyyMmDd, "4");
        return result;
    }

    private int extractScheduleData(BufferedReader buff, YyyyMmDdHolder yyyyMmDd) {
        String inputLine = "";
        String strTitle = "<A HREF=\"w0027.PageDetail.+>([^<>].+?)<";
        Pattern patternTitle = Pattern.compile(strTitle);
        String strTitle2 = "(\u975e\u516c\u958b)";
        Pattern patternTitle2 = Pattern.compile(strTitle2);
        try {
            while ((inputLine = buff.readLine()) != null) {
                Matcher matcherTitle = patternTitle.matcher(inputLine);
                if (matcherTitle.find()) {
                    ScheduleData sd = new ScheduleData();
                    if (matcherTitle.group(1) != null) {
                        sd.setTitle(this.extractTitle(matcherTitle.group(1)));
                    }
                    sd.setCNum(this.extractCNum(inputLine));
                    this.extractDetailScheduleData(buff, yyyyMmDd, sd);
                    continue;
                }
                Matcher matcherTitle2 = patternTitle2.matcher(inputLine);
                if (!matcherTitle2.find()) continue;
                ScheduleData sd = new ScheduleData();
                if (matcherTitle2.group(1) != null) {
                    sd.setTitle(this.extractTitle(matcherTitle2.group(1)));
                }
                sd.setCNum(this.extractCNum(inputLine));
                this.extractDetailScheduleData(buff, yyyyMmDd, sd);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private String extractTitle(String title) {
        String result = title.replaceAll("&nbsp;$", "");
        int index = result.indexOf("@");
        if (index > 0) {
            return result.substring(0, title.indexOf("@"));
        }
        return result;
    }

    private int extractDetailScheduleData(BufferedReader buff, YyyyMmDdHolder yyyyMmDd, ScheduleData sd) {
        String inputLine;
        String comment;
        String place;
        block8: {
            block7: {
                place = "";
                comment = "";
                inputLine = "";
                try {
                    inputLine = buff.readLine();
                    if (inputLine == null) break block7;
                    HHMMHolder startTime = this.extractHHMM(inputLine);
                    if (startTime != null) {
                        sd.getS_date().setYyyy(yyyyMmDd.getYyyy());
                        sd.getS_date().setMm(yyyyMmDd.getMm());
                        sd.getS_date().setDd(yyyyMmDd.getDd());
                        sd.getS_date().setHH(startTime.getHH());
                        sd.getS_date().setMM(startTime.getMM());
                        break block7;
                    }
                    return -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            inputLine = buff.readLine();
            if (inputLine == null) break block8;
            HHMMHolder endTime = this.extractHHMM(inputLine);
            if (endTime != null) {
                sd.getE_date().setYyyy(yyyyMmDd.getYyyy());
                sd.getE_date().setMm(yyyyMmDd.getMm());
                sd.getE_date().setDd(yyyyMmDd.getDd());
                sd.getE_date().setHH(endTime.getHH());
                sd.getE_date().setMM(endTime.getMM());
                break block8;
            }
            return -1;
        }
        inputLine = buff.readLine();
        if (inputLine != null) {
            place = this.extractPrace(inputLine);
            sd.setPlace(place.replaceAll("&nbsp;", ""));
        }
        comment = this.extractTD(buff);
        sd.setComment(comment);
        System.out.printf("detail sd is : \"%s\"\n", sd.createScheduleDataKey());
        this.scheduleDataList.add(sd);
        return 0;
    }

    private String extractCNum(String input) {
        String strCNum = "cNum=([0-9]+)";
        Pattern cNumPattern = Pattern.compile(strCNum);
        try {
            Matcher matcherCNum = cNumPattern.matcher(input);
            if (matcherCNum.find() && matcherCNum.group(1) != null) {
                return matcherCNum.group(1);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HHMMHolder extractHHMM(String input) {
        HHMMHolder hhmm;
        block5: {
            hhmm = new HHMMHolder();
            String timeLabel = "([0-9]+):([0-9]+)";
            Pattern timeLabelPattern = Pattern.compile(timeLabel);
            try {
                Matcher matcherLabel = timeLabelPattern.matcher(input);
                if (matcherLabel.find()) {
                    if (matcherLabel.group(1) != null) {
                        hhmm.setHH(matcherLabel.group(1));
                    }
                    if (matcherLabel.group(2) != null) {
                        hhmm.setMM(matcherLabel.group(2));
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return hhmm;
    }

    private String extractPrace(String input) {
        String strStdTd = "<TD CLASS=\"COL\"[^>]*>([^<]*)</TD>";
        Pattern patternStdTd = Pattern.compile(strStdTd);
        try {
            Matcher matcherPlace = patternStdTd.matcher(input);
            if (matcherPlace.find() && matcherPlace.group(1) != null) {
                String result = matcherPlace.group(1);
                result.replace("&nbsp;", "");
                return matcherPlace.group(1);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String extractTD(BufferedReader br) {
        char[] wkChar = new char[4096];
        try {
            int wk;
            int count = 0;
            while ((wk = br.read()) > 0) {
                if (wk == 10 || wk == 13) continue;
                wkChar[count] = (char)wk;
                ++count;
                if (this.extratctTdData(String.valueOf(wkChar)) == null) continue;
                wkChar = new char[1024];
                count = 0;
                return String.valueOf(wkChar);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String extratctTdData(String targetStr) {
        String strTd = "<TD .+?>(.*?)</TD>";
        Pattern patternStrTd = Pattern.compile(strTd);
        Matcher matcherTitle = patternStrTd.matcher(targetStr);
        if (matcherTitle.find() && matcherTitle.group(1) != null) {
            return matcherTitle.group(1);
        }
        return null;
    }
}

