/*
 * Decompiled with CFR 0.152.
 */
package ithdSession;

import commonData.ScheduleTitleWithPlace;
import configInfo.IthdSchedulerConfig;
import ithdSession.IthdAuthData;
import ithdSession.IthdScheduleInfo;
import java.io.PrintWriter;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import scheduleData.ScheduleData;
import sessionCommon.HttpSession;
import sessionCommon.J2gCookieManager;
import sessionCommon.J2gCookiePolicy;
import sessionCommon.J2gCookieStore2;
import sessionCommon.PostParamData;

public class IthdAddSchedule {
    private IthdSchedulerConfig isc;

    public IthdAddSchedule(IthdSchedulerConfig isc) {
        if (CookieHandler.getDefault() == null) {
            J2gCookieStore2 cookie_store = new J2gCookieStore2();
            J2gCookiePolicy cookie_policy = new J2gCookiePolicy();
            J2gCookieManager manager = new J2gCookieManager(cookie_store, cookie_policy);
            CookieHandler.setDefault(manager);
        }
        if (isc.getPassword() == null) {
            isc.setPassword(this.inputPassword());
        }
        this.isc = isc;
    }

    public int addSchedules(ArrayList<ScheduleData> sdList) {
        int result = 0;
        for (ScheduleData sd : sdList) {
            this.addSchedule(sd);
        }
        return result;
    }

    private int addSchedule(ScheduleData sd) {
        int result = 0;
        HttpSession connection = new HttpSession();
        HttpURLConnection urlConnection = connection.create_connection(this.isc.getUrlInsert());
        if (urlConnection == null) {
            return -1;
        }
        try {
            urlConnection.setRequestMethod("POST");
            PostData pd = new PostData();
            IthdAuthData iad = new IthdAuthData(this.isc);
            urlConnection.setRequestProperty("Authorization", iad.createAuthorizationString());
            PrintWriter urlOut = new PrintWriter(urlConnection.getOutputStream());
            urlOut.print(pd.createPostData(this.isc, sd));
            urlOut.close();
            if (urlConnection.getResponseCode() != 200) {
                return -2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -3;
        }
        return result;
    }

    private String inputPassword() {
        return JOptionPane.showInputDialog("Please input password");
    }

    private class PostData {
        public String createPostData(IthdSchedulerConfig isc, ScheduleData sd) {
            String result = "";
            ArrayList<PostParamData> ppdList = this.createPostParamDataList(isc, sd);
            for (PostParamData ppd : ppdList) {
                result = String.valueOf(result) + ppd.makeMessageURLEncode2SJIS();
            }
            return result;
        }

        private ArrayList<PostParamData> createPostParamDataList(IthdSchedulerConfig isc, ScheduleData sd) {
            ArrayList<PostParamData> ppdList = new ArrayList<PostParamData>();
            try {
                ppdList.add(new PostParamData("cTourokuType", "0"));
                ppdList.add(new PostParamData("cAkubun", "3"));
                ppdList.add(new PostParamData("cAcode", isc.getUserid()));
                IthdScheduleInfo isi = new IthdScheduleInfo();
                ppdList.add(new PostParamData("cScheduleInfo", isi.createScheduleInfo(isc, sd.getS_date())));
                ppdList.add(new PostParamData("cDate", String.valueOf(sd.getS_date().getYyyy()) + sd.getS_date().getMm() + sd.getS_date().getDd()));
                ppdList.add(new PostParamData("cRepeatFlg", "0"));
                if (isc.getAdd_place_in_title() != null) {
                    ScheduleTitleWithPlace stwp = new ScheduleTitleWithPlace();
                    stwp.setTitle(sd.getTitle());
                    stwp.setPlace(sd.getPlace());
                    stwp.setSeparater(isc.getAdd_place_in_title());
                    ppdList.add(new PostParamData("cTitle", stwp.getTitleWithPlace()));
                } else {
                    ppdList.add(new PostParamData("cTitle", sd.getTitle()));
                }
                ppdList.add(new PostParamData("cDate1Y", sd.getS_date().getYyyy()));
                ppdList.add(new PostParamData("cDate1M", sd.getS_date().getMm()));
                ppdList.add(new PostParamData("cDate1D", sd.getS_date().getDd()));
                ppdList.add(new PostParamData("cTime1H", sd.getS_date().getHH()));
                ppdList.add(new PostParamData("cTime1M", sd.getS_date().getMM()));
                ppdList.add(new PostParamData("cDate2Y", sd.getE_date().getYyyy()));
                ppdList.add(new PostParamData("cDate2M", sd.getE_date().getMm()));
                ppdList.add(new PostParamData("cDate2D", sd.getE_date().getDd()));
                ppdList.add(new PostParamData("cTime2H", sd.getE_date().getHH()));
                ppdList.add(new PostParamData("cTime2M", sd.getE_date().getMM()));
                ppdList.add(new PostParamData("cPlace", sd.getPlace()));
                ppdList.add(new PostParamData("cKaigiType", "0"));
                String visible = "";
                visible = sd.isClosed() ? "0" : "1";
                ppdList.add(new PostParamData("cSyokai", visible));
                ppdList.add(new PostParamData("cNaiyou", sd.getComment()));
                ppdList.add(new PostParamData("cKaigiVisible", "1"));
                ppdList.add(new PostParamData("cTFlg1", "1"));
                ppdList.add(new PostParamData("cTFlg1Value", "2"));
                ppdList.add(new PostParamData("cFormSubmitFlg", "1"));
                ppdList.add(new PostParamData("cMember_count", "5"));
                ppdList.add(new PostParamData("cOtherCount", "10"));
                ppdList.add(new PostParamData("cOption1", "0"));
                ppdList.add(new PostParamData("cRepeat", "0"));
                ppdList.add(new PostParamData("cRepeat2", "+"));
                ppdList.add(new PostParamData("cRepeat3", "+"));
                ppdList.add(new PostParamData("cRepeat_e1", "+"));
                ppdList.add(new PostParamData("cRepeat_e2", "+"));
                ppdList.add(new PostParamData("cRepeat_e3", "+"));
                ppdList.add(new PostParamData("cOption2", "0"));
                ppdList.add(new PostParamData("cData0", "******2,*,*,1,\u5546\u8ac7"));
                ppdList.add(new PostParamData("cData1", "******5,*,*,1,\u5f80\u8a2a"));
                ppdList.add(new PostParamData("cData2", "******1,*,*,9,\u4f1a\u8b70"));
                ppdList.add(new PostParamData("cData3", "******3,2,*,*,\u51fa\u5f35"));
                ppdList.add(new PostParamData("cData4", "******4,2,*,*,\u76f4\u884c"));
                ppdList.add(new PostParamData("cData5", "******6,*,*,*,\u6765\u8a2a"));
                ppdList.add(new PostParamData("cData6", "******7,4,*,*,\u4f11\u6687"));
                ppdList.add(new PostParamData("cData7", "******8,4,*,*,\u6709\u7d66\u4f11\u6687"));
                ppdList.add(new PostParamData("cDataCount", "8"));
                ppdList.add(new PostParamData("cDefDate", "*"));
                ppdList.add(new PostParamData("cDefTime1", "*"));
                ppdList.add(new PostParamData("cDefTime2", "*"));
                ppdList.add(new PostParamData("cOption2", "0"));
                ppdList.add(new PostParamData("cOption2", "0"));
                ppdList.add(new PostParamData("cOption2", "0"));
                ppdList.add(new PostParamData("cParamDate", String.valueOf(sd.getS_date().getYyyy()) + sd.getS_date().getMm() + sd.getS_date().getDd()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ppdList;
        }
    }
}

