/*
 * Decompiled with CFR 0.152.
 */
package ithdSession;

import configInfo.IthdSchedulerConfig;
import ithdSession.IthdAuthData;
import ithdSession.IthdScheduleInfo;
import java.io.PrintWriter;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import scheduleData.ScheduleData;
import sessionCommon.HttpSession;
import sessionCommon.J2gCookieManager;
import sessionCommon.J2gCookiePolicy;
import sessionCommon.J2gCookieStore2;
import sessionCommon.PostParamData;

public class IthdDeleteSchedule {
    private IthdSchedulerConfig isc;

    public IthdDeleteSchedule(IthdSchedulerConfig isc) {
        if (CookieHandler.getDefault() == null) {
            J2gCookieStore2 cookie_store = new J2gCookieStore2();
            J2gCookiePolicy cookie_policy = new J2gCookiePolicy();
            J2gCookieManager manager = new J2gCookieManager(cookie_store, cookie_policy);
            CookieHandler.setDefault(manager);
        }
        if (isc.getPassword() == null) {
            isc.setPassword(this.inputPassword());
        }
        this.isc = isc;
    }

    public int deleteSchedule(ArrayList<ScheduleData> sdList) {
        int result = 0;
        for (ScheduleData sd : sdList) {
            this.delSchedule(sd);
        }
        return result;
    }

    private int delSchedule(ScheduleData sd) {
        int result = 0;
        HttpSession connection = new HttpSession();
        HttpURLConnection urlConnection = connection.create_connection(this.isc.getUrlDelete());
        if (urlConnection == null) {
            return -1;
        }
        try {
            urlConnection.setRequestMethod("POST");
            PostData pd = new PostData();
            IthdAuthData iad = new IthdAuthData(this.isc);
            urlConnection.setRequestProperty("Authorization", iad.createAuthorizationString());
            PrintWriter urlOut = new PrintWriter(urlConnection.getOutputStream());
            urlOut.print(pd.createPostData(this.isc, sd));
            urlOut.close();
            if (urlConnection.getResponseCode() != 200) {
                return -2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -3;
        }
        return result;
    }

    private String inputPassword() {
        return JOptionPane.showInputDialog("Please input password");
    }

    private class PostData {
        private PostData() {
        }

        public String createPostData(IthdSchedulerConfig isc, ScheduleData sd) {
            String result = "";
            ArrayList<PostParamData> ppdList = this.createPostParamDataList(isc, sd);
            for (PostParamData ppd : ppdList) {
                result = String.valueOf(result) + ppd.makeMessageURLEncode2SJIS();
            }
            return result;
        }

        private ArrayList<PostParamData> createPostParamDataList(IthdSchedulerConfig isc, ScheduleData sd) {
            ArrayList<PostParamData> ppdList = new ArrayList<PostParamData>();
            try {
                ppdList.add(new PostParamData("cDelFlg1", "1"));
                ppdList.add(new PostParamData("cDelFlg2", "2"));
                IthdScheduleInfo isi = new IthdScheduleInfo();
                ppdList.add(new PostParamData("cScheduleInfo", isi.createScheduleInfo(isc, sd.getS_date())));
                ppdList.add(new PostParamData("cSite", isc.getCSite()));
                ppdList.add(new PostParamData("cNum", sd.getCNum()));
                ppdList.add(new PostParamData("cEda", "000"));
                ppdList.add(new PostParamData("cDate", String.valueOf(sd.getS_date().getYyyy()) + sd.getS_date().getMm() + sd.getS_date().getDd()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ppdList;
        }

        private ArrayList<PostParamData> createPostParamDataList2(IthdSchedulerConfig isc, ScheduleData sd) {
            ArrayList<PostParamData> ppdList = new ArrayList<PostParamData>();
            try {
                ppdList.add(new PostParamData("cDelFlg1", "1"));
                ppdList.add(new PostParamData("cDelFlg2", "2"));
                ppdList.add(new PostParamData("cTourokuType", "0"));
                ppdList.add(new PostParamData("cAkubun", isc.getCAkubun()));
                ppdList.add(new PostParamData("cAcode", isc.getUserid()));
                IthdScheduleInfo isi = new IthdScheduleInfo();
                ppdList.add(new PostParamData("cScheduleInfo", isi.createScheduleInfo(isc, sd.getS_date())));
                ppdList.add(new PostParamData("cCompany", isc.getCompany()));
                ppdList.add(new PostParamData("cDept", isc.getBusho()));
                ppdList.add(new PostParamData("cType", "1"));
                ppdList.add(new PostParamData("cCodet", isc.getBusho()));
                ppdList.add(new PostParamData("cTargetType", "3"));
                ppdList.add(new PostParamData("cTargetCode", isc.getBusho()));
                ppdList.add(new PostParamData("cTargetCompany", isc.getCompany()));
                ppdList.add(new PostParamData("cFormat", "3"));
                ppdList.add(new PostParamData("cDate", String.valueOf(sd.getS_date().getYyyy()) + sd.getS_date().getMm() + sd.getS_date().getDd()));
                ppdList.add(new PostParamData("cSite", isc.getCSite()));
                ppdList.add(new PostParamData("cNum", sd.getCNum()));
                ppdList.add(new PostParamData("cEda", "000"));
                ppdList.add(new PostParamData("cRoomSelected", "0"));
                ppdList.add(new PostParamData("cRepeatFlg", "0"));
                ppdList.add(new PostParamData("cOption1", "0"));
                ppdList.add(new PostParamData("cOption2", "0"));
                ppdList.add(new PostParamData("cOption3", "0"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ppdList;
        }
    }
}

