/*
 * Decompiled with CFR 0.152.
 */
package ithdSession;

import commonData.HHMMHolder;
import commonData.ScheduleTitleWithPlace;
import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import commonData.YyyyMmHolder;
import configInfo.IthdSchedulerConfig;
import ithdSession.IIthdMonthSchedule;
import ithdSession.IthdAuthData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import scheduleData.ScheduleData;
import sessionCommon.HttpSession;
import sessionCommon.J2gCookieManager;
import sessionCommon.J2gCookiePolicy;
import sessionCommon.J2gCookieStore2;

public class IthdMonthSchedule
implements IIthdMonthSchedule {
    private IthdSchedulerConfig isc;
    private ArrayList<ScheduleData> scheduleDataList;
    private UserInfo userInfo;

    @Override
    public void setConfig(IthdSchedulerConfig isc, UserInfo userInfo) {
        if (CookieHandler.getDefault() == null) {
            J2gCookieStore2 cookie_store = new J2gCookieStore2();
            J2gCookiePolicy cookie_policy = new J2gCookiePolicy();
            J2gCookieManager manager = new J2gCookieManager(cookie_store, cookie_policy);
            CookieHandler.setDefault(manager);
        }
        if (isc.getPassword() == null) {
            isc.setPassword(this.inputPassword());
        }
        this.isc = isc;
        this.scheduleDataList = new ArrayList();
        this.userInfo = userInfo;
    }

    @Override
    public int read(YyyyMmHolder yyyyMm) {
        HttpURLConnection urlConnection;
        block5: {
            String yyyy = yyyyMm.getYyyy();
            String mm = yyyyMm.getMm();
            HttpSession gcon = new HttpSession();
            String urlData = this.makeMonthGetParam(this.isc.getUrlMonth(), this.isc.getUserid(), this.isc.getCompany(), this.isc.getBusho(), this.isc.getCAkubun(), this.isc.getCSite(), yyyy, mm, this.userInfo);
            urlConnection = gcon.create_connection(urlData);
            if (urlConnection == null) {
                return -1;
            }
            IthdAuthData iad = new IthdAuthData(this.isc);
            urlConnection.setRequestProperty("Authorization", iad.createAuthorizationString());
            try {
                urlConnection.setRequestMethod("GET");
                if (urlConnection.getResponseCode() == 200) break block5;
                return -2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -3;
            }
        }
        BufferedReader buff = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "SJIS"));
        ArrayList<String> detailUrlList = this.extractDetailScheduleURL(buff);
        if (detailUrlList != null) {
            this.readDetailSchedules(detailUrlList);
        }
        return 0;
    }

    private void readDetailSchedules(ArrayList<String> dtlUrlList) {
        for (String urlData : dtlUrlList) {
            ScheduleData sd = this.readDetailSchedule(String.valueOf(this.isc.getUrlBase()) + urlData);
            if (sd == null) continue;
            System.out.printf("detail sd is : \"%s\"\n", sd.createScheduleDataKey());
            this.scheduleDataList.add(sd);
        }
    }

    private ScheduleData readDetailSchedule(String urlData) {
        HttpURLConnection urlConnection;
        block4: {
            HttpSession gcon = new HttpSession();
            urlConnection = gcon.create_connection(urlData);
            if (urlConnection == null) {
                return null;
            }
            IthdAuthData iad = new IthdAuthData(this.isc);
            urlConnection.setRequestProperty("Authorization", iad.createAuthorizationString());
            try {
                urlConnection.setRequestMethod("GET");
                if (urlConnection.getResponseCode() == 200) break block4;
                System.err.println(String.valueOf(this.getClass().getName()) + " " + Thread.currentThread().getStackTrace()[1].getMethodName() + " urlResponce " + urlConnection.getResponseCode() + " urlData " + urlData);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        BufferedReader buff = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "SJIS"));
        return this.extractScheduleData(buff);
    }

    private String makeMonthGetParam(String urlName, String userId, String company, String busho, String cAkubun, String cSite, String yyyy, String mm, UserInfo userInfo) {
        String result = "";
        result = userInfo.isIthdSchedulerUser() ? String.valueOf(urlName) + userInfo.getIthdCompany() + "," + userInfo.getIthdBusho() + "," + userInfo.getIthdCSite() + "," + userInfo.getIthdBusho() + "," + userInfo.getIthdCAkubun() + "," + userInfo.getIthdUserid() + "," + "3" + "," + yyyy + mm + "01," + userInfo.getIthdCompany() + "," : String.valueOf(urlName) + company + "," + busho + "," + cSite + "," + busho + "," + cAkubun + "," + userId + "," + "3" + "," + yyyy + mm + "01," + company + ",";
        return result;
    }

    private int printBuff(BufferedReader buff) {
        String inputLine = "";
        try {
            while ((inputLine = buff.readLine()) != null) {
                System.out.println(inputLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private ArrayList<String> extractDetailScheduleURL(BufferedReader urlIn) {
        String inputLine = "";
        ArrayList<String> detailUrlList = new ArrayList<String>();
        String scheduleInfo = "<A HREF=\"(w0027.PageDetail\\?cSite[^>]+)\">";
        Pattern schedulePattern = Pattern.compile(scheduleInfo);
        try {
            while ((inputLine = urlIn.readLine()) != null) {
                Matcher matcher = schedulePattern.matcher(inputLine);
                while (matcher.find()) {
                    if (matcher.group(1) == null) continue;
                    detailUrlList.add(matcher.group(1));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return detailUrlList;
    }

    private ScheduleData extractScheduleData(BufferedReader buff) {
        String inputLine = "";
        HashMap<String, String> scheduleDataMap = new HashMap<String, String>();
        String scheduleInfoLabel = ">(\u65e5\u4ed8|\u6642\u9593|\u30bf\u30a4\u30c8\u30eb|\u5834\u6240|\u5185\u5bb9|\u7167\u4f1a\u533a\u5206|\u66f4\u65b0\u62c5\u5f53)<";
        Pattern schedulePatternLabel = Pattern.compile(scheduleInfoLabel);
        String scheduleInfoValue = "^[^>]+>(.+)<[^<]+$";
        Pattern schedulePatternValue = Pattern.compile(scheduleInfoValue);
        String cNumInfo = "NAME=\"cNum\" VALUE=\"(\\d+)\"";
        Pattern cNumPattern = Pattern.compile(cNumInfo);
        try {
            while ((inputLine = buff.readLine()) != null) {
                Matcher matcherLabel = schedulePatternLabel.matcher(inputLine);
                if (matcherLabel.find()) {
                    String label = "";
                    if (matcherLabel.group(1) != null) {
                        label = matcherLabel.group(1);
                    }
                    String str = this.extractContentsFromLines(buff);
                    scheduleDataMap.put(label, str.replaceAll("\u3000$", ""));
                    continue;
                }
                Matcher matcherCNum = cNumPattern.matcher(inputLine);
                if (!matcherCNum.find()) continue;
                String cNum = "";
                if (matcherCNum.group(1) != null) {
                    cNum = matcherCNum.group(1);
                }
                scheduleDataMap.put("cNum", cNum);
            }
            return this.makeScheduleData(scheduleDataMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String extractContentsFromLines(BufferedReader buff) {
        String inputLine = "";
        String result = "";
        String standardValue = "^[^>]+>(.+)<[^<]+$";
        Pattern standardValuePattern = Pattern.compile(standardValue);
        String startValue = "<TD[^>]+>(.+)$";
        Pattern startValuePattern = Pattern.compile(startValue);
        String terminalValue = "^(.+)</TD>$";
        Pattern terminalValuePattern = Pattern.compile(terminalValue);
        try {
            while ((inputLine = buff.readLine()) != null) {
                Matcher matcherStandard = standardValuePattern.matcher(inputLine);
                if (matcherStandard.find()) {
                    if (matcherStandard.group(1) != null) {
                        result = matcherStandard.group(1);
                    }
                    return result;
                }
                Matcher matcherStart = startValuePattern.matcher(inputLine);
                if (!matcherStart.find()) continue;
                if (matcherStart.group(1) != null) {
                    result = matcherStart.group(1);
                }
                while ((inputLine = buff.readLine()) != null) {
                    Matcher matcherTerminate = terminalValuePattern.matcher(inputLine);
                    if (matcherTerminate.find()) {
                        if (matcherTerminate.group(1) != null) {
                            result = String.valueOf(result) + matcherTerminate.group(1);
                        }
                        return result;
                    }
                    result = String.valueOf(result) + inputLine;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    private ScheduleData makeScheduleData(HashMap<String, String> scheduleDataMap) {
        ScheduleData sd = new ScheduleData();
        if (scheduleDataMap.containsKey("\u30bf\u30a4\u30c8\u30eb")) {
            ScheduleTitleWithPlace stwp = new ScheduleTitleWithPlace();
            stwp.setTitleWithPlace(scheduleDataMap.get("\u30bf\u30a4\u30c8\u30eb"), this.isc.getAdd_place_in_title());
            sd.setTitle(stwp.getTitle());
        }
        if (scheduleDataMap.containsKey("\u5834\u6240")) {
            sd.setPlace(scheduleDataMap.get("\u5834\u6240"));
        }
        if (scheduleDataMap.containsKey("\u65e5\u4ed8")) {
            YyyyMmDdHolder yyyyMmDd = this.extractYyyyMmDd(scheduleDataMap.get("\u65e5\u4ed8"));
            sd.getS_date().setYyyy(yyyyMmDd.getYyyy());
            sd.getS_date().setMm(yyyyMmDd.getMm());
            sd.getS_date().setDd(yyyyMmDd.getDd());
            sd.getE_date().setYyyy(yyyyMmDd.getYyyy());
            sd.getE_date().setMm(yyyyMmDd.getMm());
            sd.getE_date().setDd(yyyyMmDd.getDd());
        }
        if (scheduleDataMap.containsKey("\u65e5\u4ed8")) {
            HHMMHolder starthhmm = this.extractHHMM(scheduleDataMap.get("\u65e5\u4ed8"), true);
            if (starthhmm == null) {
                return null;
            }
            sd.getS_date().setHH(starthhmm.getHH());
            sd.getS_date().setMM(starthhmm.getMM());
            HHMMHolder endhhmm = this.extractHHMM(scheduleDataMap.get("\u65e5\u4ed8"), false);
            if (endhhmm != null) {
                sd.getE_date().setHH(this.exchangeEndHour(starthhmm.getHH(), endhhmm.getHH()));
                sd.getE_date().setMM(endhhmm.getMM());
            } else {
                return null;
            }
        }
        if (scheduleDataMap.containsKey("\u5185\u5bb9")) {
            sd.setComment(scheduleDataMap.get("\u5185\u5bb9"));
        }
        if (scheduleDataMap.containsKey("cNum")) {
            sd.setCNum(scheduleDataMap.get("cNum"));
        }
        if (scheduleDataMap.containsKey("\u7167\u4f1a\u533a\u5206")) {
            if (scheduleDataMap.get("\u7167\u4f1a\u533a\u5206").equals("\u516c\u958b")) {
                sd.setClosed(false);
            } else {
                sd.setClosed(true);
            }
        }
        if (scheduleDataMap.containsKey("\u66f4\u65b0\u62c5\u5f53")) {
            sd.setUpdatePerson(scheduleDataMap.get("\u66f4\u65b0\u62c5\u5f53"));
        }
        return sd;
    }

    private String exchangeEndHour(String startHh, String endHh) {
        String resultHh = endHh;
        if (Integer.valueOf(startHh) > Integer.valueOf(endHh)) {
            resultHh = new String(Integer.toString(Integer.valueOf(endHh) + 24));
        }
        return resultHh;
    }

    private YyyyMmDdHolder extractYyyyMmDd(String input) {
        YyyyMmDdHolder yyyyMmDd;
        block6: {
            yyyyMmDd = new YyyyMmDdHolder();
            String dateLabel = "(\\d+)\u5e74(\\d+)\u6708(\\d+)\u65e5";
            Pattern dateLabelPattern = Pattern.compile(dateLabel);
            try {
                Matcher matcherLabel = dateLabelPattern.matcher(input);
                if (matcherLabel.find()) {
                    if (matcherLabel.group(1) != null) {
                        yyyyMmDd.setYyyy(matcherLabel.group(1));
                    }
                    if (matcherLabel.group(2) != null) {
                        yyyyMmDd.setMm(matcherLabel.group(2));
                    }
                    if (matcherLabel.group(3) != null) {
                        yyyyMmDd.setDd(matcherLabel.group(3));
                    }
                    break block6;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return yyyyMmDd;
    }

    private HHMMHolder extractHHMM(String input, boolean isStart) {
        HHMMHolder hhmm;
        block9: {
            hhmm = new HHMMHolder();
            String timeLabel = "([0-9]+):([0-9]+).+?([0-9]+):([0-9]+)";
            Pattern timeLabelPattern = Pattern.compile(timeLabel);
            try {
                Matcher matcherLabel = timeLabelPattern.matcher(input);
                if (matcherLabel.find()) {
                    if (isStart) {
                        if (matcherLabel.group(1) != null) {
                            hhmm.setHH(matcherLabel.group(1));
                        }
                        if (matcherLabel.group(2) != null) {
                            hhmm.setMM(matcherLabel.group(2));
                        }
                    } else {
                        if (matcherLabel.group(3) != null) {
                            hhmm.setHH(matcherLabel.group(3));
                        }
                        if (matcherLabel.group(4) != null) {
                            hhmm.setMM(matcherLabel.group(4));
                        }
                    }
                    break block9;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return hhmm;
    }

    private String inputPassword() {
        return JOptionPane.showInputDialog("Please input password");
    }

    @Override
    public ArrayList<ScheduleData> getScheduleDataList() {
        return this.scheduleDataList;
    }
}

