/*
 * Decompiled with CFR 0.152.
 */
package ithdSession;

import commonData.ThSync;
import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import commonData.YyyyMmHolder;
import configInfo.IthdSchedulerConfig;
import ithdSession.IBISOneDayReader;
import ithdSession.IBISOneDayReaderListener;
import ithdSession.IIthdMonthSchedule;
import ithdSession.IthdAuthData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import scheduleData.ScheduleData;
import sessionCommon.HttpSession;
import sessionCommon.J2gCookieManager;
import sessionCommon.J2gCookiePolicy;
import sessionCommon.J2gCookieStore2;

public class IthdMonthScheduleByDay
implements IIthdMonthSchedule,
IBISOneDayReaderListener {
    private IthdSchedulerConfig isc;
    private ArrayList<ScheduleData> scheduleDataList;
    private UserInfo userInfo;

    @Override
    public void setConfig(IthdSchedulerConfig isc, UserInfo userInfo) {
        if (CookieHandler.getDefault() == null) {
            J2gCookieStore2 cookie_store = new J2gCookieStore2();
            J2gCookiePolicy cookie_policy = new J2gCookiePolicy();
            J2gCookieManager manager = new J2gCookieManager(cookie_store, cookie_policy);
            CookieHandler.setDefault(manager);
        }
        if (isc.getPassword() == null) {
            isc.setPassword(this.inputPassword());
        }
        this.isc = isc;
        this.scheduleDataList = new ArrayList();
        this.userInfo = userInfo;
    }

    @Override
    public int read(YyyyMmHolder yyyyMm) {
        HttpURLConnection urlConnection;
        int result;
        block5: {
            String yyyy = yyyyMm.getYyyy();
            String mm = yyyyMm.getMm();
            result = 0;
            HttpSession gcon = new HttpSession();
            String urlData = this.makeMonthGetParam(this.isc.getUrlMonth(), this.isc.getUserid(), this.isc.getCompany(), this.isc.getBusho(), this.isc.getCAkubun(), this.isc.getCSite(), yyyy, mm, this.userInfo);
            urlConnection = gcon.create_connection(urlData);
            if (urlConnection == null) {
                return -1;
            }
            IthdAuthData iad = new IthdAuthData(this.isc);
            urlConnection.setRequestProperty("Authorization", iad.createAuthorizationString());
            try {
                urlConnection.setRequestMethod("GET");
                if (urlConnection.getResponseCode() == 200) break block5;
                return -2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -3;
            }
        }
        BufferedReader buff = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "SJIS"));
        result = this.readDetailScheduleByDay(buff, yyyyMm);
        if (result < 0) {
            return result;
        }
        return 0;
    }

    private int readDetailScheduleByDay(BufferedReader buff, YyyyMmHolder yyyyMm) {
        HashMap<Integer, String> dayMap = this.extractDayInfo(buff);
        if (dayMap == null) {
            return -1;
        }
        ThSync thSync = new ThSync();
        Set<Integer> dayInfoSet = dayMap.keySet();
        for (Integer dayInfo : dayInfoSet) {
            YyyyMmDdHolder yyyyMmDd = new YyyyMmDdHolder(yyyyMm.getYyyy(), yyyyMm.getMm(), dayInfo.toString());
            IBISOneDayReader ior = new IBISOneDayReader(this.isc, this.userInfo, yyyyMmDd, this, thSync);
            Thread t = new Thread(ior);
            t.start();
        }
        thSync.waitSync();
        return 0;
    }

    private HashMap<Integer, String> extractDayInfo(BufferedReader buff) {
        String strDayInfo = "<TD><FONT.*?>([0-9]{1,2})</FONT></TD>";
        Pattern patternDayInfo = Pattern.compile(strDayInfo);
        String strLink2Detail = "w0027\\.PageDetail";
        Pattern patternLink2Detail = Pattern.compile(strLink2Detail);
        HashMap<Integer, String> dayMap = new HashMap<Integer, String>();
        String inputLine = "";
        int nowDay = 0;
        try {
            while ((inputLine = buff.readLine()) != null) {
                Matcher matcherLink2Detail;
                Matcher matcherDayInfo = patternDayInfo.matcher(inputLine);
                if (matcherDayInfo.find() && matcherDayInfo.group(1) != null) {
                    nowDay = Integer.valueOf(matcherDayInfo.group(1));
                }
                if (!(matcherLink2Detail = patternLink2Detail.matcher(inputLine)).find() || dayMap.containsKey(nowDay)) continue;
                dayMap.put(nowDay, "true");
            }
            return dayMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String makeMonthGetParam(String urlName, String userId, String company, String busho, String cAkubun, String cSite, String yyyy, String mm, UserInfo userInfo) {
        String result = "";
        result = userInfo.isIthdSchedulerUser() ? String.valueOf(urlName) + userInfo.getIthdCompany() + "," + userInfo.getIthdBusho() + "," + userInfo.getIthdCSite() + "," + userInfo.getIthdBusho() + "," + userInfo.getIthdCAkubun() + "," + userInfo.getIthdUserid() + "," + "3" + "," + yyyy + mm + "01," + userInfo.getIthdCompany() + "," : String.valueOf(this.isc.getUrlMonth()) + this.isc.getCompany() + "," + busho + "," + cSite + "," + busho + "," + cAkubun + "," + userId + "," + "3" + "," + yyyy + mm + "01," + company + ",";
        return result;
    }

    private String inputPassword() {
        return JOptionPane.showInputDialog("Please input password");
    }

    @Override
    public ArrayList<ScheduleData> getScheduleDataList() {
        return this.scheduleDataList;
    }

    @Override
    public synchronized void sendScheduleDataList(ArrayList<ScheduleData> scheduleDataList) {
        for (ScheduleData sd : scheduleDataList) {
            this.scheduleDataList.add(sd);
        }
    }
}

