/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import commonData.MmDdHolder;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HolidayInfo {
    private HashMap<String, String> holidayInfoMap = new HashMap();
    private final String HOLIDAY = "HOLIDAY";

    public int readHolidayInfo(String dirName) {
        String inputLine = "";
        String targetYyyy = "0000";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(dirName) + "HOLIDAY.txt"), "JISAutoDetect"));
            while ((inputLine = br.readLine()) != null) {
                if (inputLine.length() < 3) continue;
                String tmpStr = "";
                Pattern commentPattern = Pattern.compile("([^;]*);");
                Matcher matcher = commentPattern.matcher(inputLine);
                tmpStr = matcher.find() ? (matcher.group(1) != null ? matcher.group(1) : inputLine) : inputLine;
                Pattern yyyyPattern = Pattern.compile(".*\\[(\\d{4})].*");
                Matcher matcherYyyy = yyyyPattern.matcher(tmpStr);
                if (matcherYyyy.find()) {
                    if (matcherYyyy.group(1) == null) continue;
                    String tmpTargetYyyy = new String(matcherYyyy.group(1));
                    try {
                        targetYyyy = new String(String.format("%04d", Integer.valueOf(tmpTargetYyyy)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Pattern periodPattern = Pattern.compile("(.*) *- *(.*)");
                Matcher matcherPeriod = periodPattern.matcher(tmpStr);
                if (matcherPeriod.find()) {
                    String startDay = "";
                    String endDay = "";
                    if (matcherPeriod.group(1) == null) continue;
                    startDay = matcherPeriod.group(1);
                    if (matcherPeriod.group(2) == null) continue;
                    endDay = matcherPeriod.group(2);
                    this.analysePeriod(targetYyyy, startDay, endDay);
                    continue;
                }
                Pattern dayPattern = Pattern.compile("(\\d+) */ *(\\d+)");
                Matcher matcherDay = dayPattern.matcher(tmpStr);
                if (!matcherDay.find()) continue;
                this.analyseOneDay(targetYyyy, tmpStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private void analysePeriod(String yyyy, String startDay, String endDay) {
        MmDdHolder endMmDdHolder;
        MmDdHolder targetMmDdHolder = this.extractMmDd(startDay);
        if (targetMmDdHolder != null && (endMmDdHolder = this.extractMmDd(endDay)) != null) {
            while (targetMmDdHolder.compareUnder(endMmDdHolder)) {
                this.setHoliday(yyyy, targetMmDdHolder.getTargetMm(), targetMmDdHolder.getTargetDd());
                targetMmDdHolder.incrementDd(yyyy);
            }
        }
    }

    private void analyseOneDay(String yyyy, String inputStr) {
        MmDdHolder mmDdHolder = this.extractMmDd(inputStr);
        if (mmDdHolder != null) {
            this.setHoliday(yyyy, mmDdHolder.getTargetMm(), mmDdHolder.getTargetDd());
        }
    }

    private void setHoliday(String yyyy, String mm, String dd) {
        this.holidayInfoMap.put(this.createKey(yyyy, mm, dd), "HOLIDAY");
    }

    private String createKey(String yyyy, String mm, String dd) {
        String targetYyyy = "";
        targetYyyy = yyyy.equals("") ? "0000" : String.format("%04d", Integer.valueOf(yyyy));
        String targetMm = String.format("%02d", Integer.valueOf(mm));
        String targetDd = String.format("%02d", Integer.valueOf(dd));
        return String.valueOf(targetYyyy) + targetMm + targetDd;
    }

    private MmDdHolder extractMmDd(String inputStr) {
        MmDdHolder mmDdHolder = new MmDdHolder();
        Pattern dayPattern = Pattern.compile("(\\d+) */ *(\\d+)");
        Matcher matcherDay = dayPattern.matcher(inputStr);
        if (matcherDay.find()) {
            String targetMm = "";
            String targetDd = "";
            if (matcherDay.group(1) != null && !mmDdHolder.setTargetMm(targetMm = matcherDay.group(1))) {
                return null;
            }
            if (matcherDay.group(2) != null && !mmDdHolder.setTargetDd(targetDd = matcherDay.group(2))) {
                return null;
            }
            return mmDdHolder;
        }
        return null;
    }

    public boolean isHoliday(String yyyy, String mm, String dd) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.valueOf(yyyy));
        cal.set(2, Integer.valueOf(mm) - 1);
        cal.set(5, Integer.valueOf(dd));
        MmDdHolder mmDd = new MmDdHolder(mm, dd);
        if (cal.get(7) == 7 || cal.get(7) == 1) {
            return true;
        }
        if (this.holidayInfoMap.containsKey(String.valueOf(yyyy) + mmDd.getTargetMm() + mmDd.getTargetDd())) {
            return true;
        }
        return this.holidayInfoMap.containsKey("0000" + mmDd.getTargetMm() + mmDd.getTargetDd());
    }

    public void debugPrintOut() {
        System.out.println("----> for debug HOLIDAY HolidayInfo");
        int count = 0;
        Set<String> set = this.holidayInfoMap.keySet();
        for (String yyyyMmDd : set) {
            System.out.println("[" + count + "] " + yyyyMmDd);
            ++count;
        }
    }
}

