/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import jScheduleData.JScheduleDataHeader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Set;
import java.util.TreeMap;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import workMasterData.ProjectItem;

public abstract class JScheduleData {
    private TreeMap<String, TreeMap<String, TreeMap<String, ScheduleData>>> scheduleDataMap;
    private TreeMap<String, ArrayList<ScheduleData>> dayScheduleMap;
    protected UserInfo userInfo;
    private JScheduleDataHeader jScheduleDataHeader;
    private boolean offLineMode = false;

    public JScheduleData(UserInfo userInfo) {
        this.createDataMap();
        this.userInfo = userInfo;
    }

    private ArrayList<ScheduleData> getYearScheduleList(String yyyy) {
        ArrayList<ScheduleData> resultList = new ArrayList<ScheduleData>();
        if (this.scheduleDataMap.containsKey(yyyy)) {
            Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
            for (String mm : mmList) {
                Set<String> sdKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
                for (String sdKey : sdKeyList) {
                    resultList.add(this.scheduleDataMap.get(yyyy).get(mm).get(sdKey));
                }
            }
        }
        return resultList;
    }

    private ArrayList<ScheduleData> getMonthScheduleList(String yyyy, String mm) {
        ArrayList<ScheduleData> resultList = new ArrayList<ScheduleData>();
        if (this.scheduleDataMap.containsKey(yyyy) && this.scheduleDataMap.get(yyyy).containsKey(mm)) {
            Set<String> sdKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
            for (String sdKey : sdKeyList) {
                resultList.add(this.scheduleDataMap.get(yyyy).get(mm).get(sdKey));
            }
        }
        return resultList;
    }

    public TreeMap<String, ScheduleData> getMonthSchedule(String yyyy, String mm) {
        if (this.scheduleDataMap.containsKey(yyyy) && this.scheduleDataMap.get(yyyy).containsKey(mm)) {
            return this.scheduleDataMap.get(yyyy).get(mm);
        }
        return new TreeMap<String, ScheduleData>();
    }

    public ArrayList<ScheduleData> getDayScheduleList2(YyyyMmDdHolder yyyyMmDd) {
        ArrayList<ScheduleData> result = new ArrayList<ScheduleData>();
        DateInfo di = new DateInfo(yyyyMmDd.getYyyy(), yyyyMmDd.getMm(), yyyyMmDd.getDd(), "00", "00");
        if (this.dayScheduleMap.containsKey(di.createYyyyMmDdKey())) {
            for (ScheduleData sd : this.dayScheduleMap.get(di.createYyyyMmDdKey())) {
                result.add(sd);
            }
        }
        return result;
    }

    public ArrayList<ScheduleData> getScheduleListAfterDateInfo(DateInfo dateInfo) {
        ArrayList<ScheduleData> resultList = new ArrayList<ScheduleData>();
        String targetYyyy = dateInfo.getYyyy();
        String targetMm = dateInfo.getMm();
        Set<String> yyyyList = this.scheduleDataMap.keySet();
        for (String yyyy : yyyyList) {
            if (Integer.valueOf(targetYyyy) < Integer.valueOf(yyyy)) {
                resultList.addAll(this.getYearScheduleList(yyyy));
                continue;
            }
            if (Integer.valueOf(targetYyyy).intValue() != Integer.valueOf(yyyy).intValue()) continue;
            Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
            for (String mm : mmList) {
                if (Integer.valueOf(targetMm) < Integer.valueOf(mm)) {
                    resultList.addAll(this.getMonthScheduleList(yyyy, mm));
                    continue;
                }
                if (Integer.valueOf(targetMm).intValue() != Integer.valueOf(mm).intValue()) continue;
                for (ScheduleData sd : this.getMonthScheduleList(yyyy, mm)) {
                    if (!this.s_date_check(dateInfo, sd.getS_date()).booleanValue()) continue;
                    resultList.add(sd);
                }
            }
        }
        return resultList;
    }

    public ArrayList<ScheduleData> getDayScheduleList(String yyyy, String mm, String dd) {
        YyyyMmDdHolder yyyyMmDd = new YyyyMmDdHolder();
        yyyyMmDd.setYyyy(yyyy);
        yyyyMmDd.setMm(mm);
        yyyyMmDd.setDd(dd);
        return this.getDayScheduleList2(yyyyMmDd);
    }

    public int readScheduleData() {
        if (!this.userInfo.isHasScheduleData()) {
            return 0;
        }
        DateInfo sDateScope = new DateInfo("0000", "00", "00", "00", "00");
        return this.readScheduleData(sDateScope);
    }

    public abstract int readScheduleData(DateInfo var1);

    public void addSchedule(ScheduleData sd) {
        this.addSchedule2ScheduleDataMap2(sd);
        this.addSchedule2DayScheduleDataMap(sd);
        ArrayList<ScheduleData> sdList = new ArrayList<ScheduleData>();
        sdList.add(sd);
        this.addScheduleData(sdList);
    }

    public void delSchedule(ScheduleData sd) {
        this.delScheduleFromScheduleDataMap(sd);
        this.delScheduleFromDayScheduleDataMap(sd);
        ArrayList<ScheduleData> sdList = new ArrayList<ScheduleData>();
        sdList.add(sd);
        this.delScheduleData(sdList);
    }

    private void delScheduleFromScheduleDataMap(ScheduleData sd) {
        this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).remove(sd.createScheduleDataKey());
        if (this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).size() == 0) {
            this.scheduleDataMap.get(sd.getS_date().getYyyy()).remove(sd.getS_date().getMm());
            if (this.scheduleDataMap.get(sd.getS_date().getYyyy()).size() == 0) {
                this.scheduleDataMap.remove(sd.getS_date().getYyyy());
            }
        }
    }

    private void delScheduleFromDayScheduleDataMap(ScheduleData sd) {
        this.dayScheduleMap.get(sd.getS_date().createYyyyMmDdKey()).remove(sd);
    }

    public String getUserName() {
        return this.userInfo.getUserName();
    }

    public DateInfo getMaxSchduleDate() {
        String yyyy = this.getMaxYyyy();
        String mm = this.getMaxMm(yyyy);
        return this.getMaxDateInfo(yyyy, mm);
    }

    private String getMaxYyyy() {
        String maxYyyy = "0";
        Set<String> yyyyList = this.scheduleDataMap.keySet();
        for (String yyyy : yyyyList) {
            if (Integer.valueOf(maxYyyy) >= Integer.valueOf(yyyy)) continue;
            maxYyyy = yyyy;
        }
        return maxYyyy;
    }

    private String getMaxMm(String yyyy) {
        String maxMm = "0";
        if (this.scheduleDataMap.containsKey(yyyy)) {
            Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
            for (String mm : mmList) {
                if (Integer.valueOf(maxMm) >= Integer.valueOf(mm)) continue;
                maxMm = mm;
            }
        }
        return maxMm;
    }

    private DateInfo getMaxDateInfo(String yyyy, String mm) {
        DateInfo maxDateInfo = new DateInfo("0", "0", "0", "0", "0");
        if (this.scheduleDataMap.containsKey(yyyy) && this.scheduleDataMap.get(yyyy).containsKey(mm)) {
            Set<String> sdKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
            for (String sdKey : sdKeyList) {
                DateInfo targetDateInfo = this.scheduleDataMap.get(yyyy).get(mm).get(sdKey).getS_date();
                if (maxDateInfo.compareDateInfo(targetDateInfo) != -1) continue;
                maxDateInfo = targetDateInfo;
            }
        }
        return maxDateInfo;
    }

    protected void addSchedule2ScheduleDataMap2(ScheduleData sd) {
        if (this.scheduleDataMap.containsKey(sd.getS_date().getYyyy())) {
            if (this.scheduleDataMap.get(sd.getS_date().getYyyy()).containsKey(sd.getS_date().getMm())) {
                if (this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).containsKey(sd.createScheduleDataKey())) {
                    ScheduleData beforSd = this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).get(sd.createScheduleDataKey());
                    this.copyOriginalInformation(beforSd, sd);
                } else {
                    this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).put(sd.createScheduleDataKey(), sd);
                }
            } else {
                TreeMap<String, ScheduleData> mapScheduleKey = new TreeMap<String, ScheduleData>();
                mapScheduleKey.put(sd.createScheduleDataKey(), sd);
                this.scheduleDataMap.get(sd.getS_date().getYyyy()).put(sd.getS_date().getMm(), mapScheduleKey);
            }
        } else {
            TreeMap<String, ScheduleData> mapScheduleKey = new TreeMap<String, ScheduleData>();
            mapScheduleKey.put(sd.createScheduleDataKey(), sd);
            TreeMap<String, TreeMap<String, ScheduleData>> mapMm = new TreeMap<String, TreeMap<String, ScheduleData>>();
            mapMm.put(sd.getS_date().getMm(), mapScheduleKey);
            this.scheduleDataMap.put(sd.getS_date().getYyyy(), mapMm);
        }
    }

    protected abstract void copyOriginalInformation(ScheduleData var1, ScheduleData var2);

    protected void addSchedule2DayScheduleDataMap(ScheduleData sd) {
        String mapKey = sd.getS_date().createYyyyMmDdKey();
        if (this.dayScheduleMap.containsKey(mapKey)) {
            this.dayScheduleMap.get(mapKey).add(sd);
        } else {
            ArrayList<ScheduleData> sdList = new ArrayList<ScheduleData>();
            sdList.add(sd);
            this.dayScheduleMap.put(mapKey, sdList);
        }
    }

    private Boolean s_date_check(DateInfo s_date_scope, DateInfo s_date) {
        Boolean result = false;
        try {
            Integer wk_yyyy = Integer.valueOf(s_date_scope.getYyyy());
            Integer wk_mm = Integer.valueOf(s_date_scope.getMm());
            Integer wk_dd = Integer.valueOf(s_date_scope.getDd());
            Integer wk_HH = Integer.valueOf(s_date_scope.getHH());
            Integer wk_MM = Integer.valueOf(s_date_scope.getMM());
            Calendar cal = Calendar.getInstance();
            cal.set(wk_yyyy, wk_mm, wk_dd, wk_HH, wk_MM);
            Integer wk2_yyyy = Integer.valueOf(s_date.getYyyy());
            Integer wk2_mm = Integer.valueOf(s_date.getMm());
            Integer wk2_dd = Integer.valueOf(s_date.getDd());
            Integer wk2_HH = Integer.valueOf(s_date.getHH());
            Integer wk2_MM = Integer.valueOf(s_date.getMM());
            Calendar cal2 = Calendar.getInstance();
            cal2.set(wk2_yyyy, wk2_mm, wk2_dd, wk2_HH, wk2_MM);
            if (cal.before(cal2)) {
                result = true;
            }
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    public void printScheduleData() {
        int count = 0;
        System.out.println("====> scheduleDataMap");
        Set<String> yyyyList = this.scheduleDataMap.keySet();
        for (String yyyy : yyyyList) {
            Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
            for (String mm : mmList) {
                Set<String> scheduleKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
                for (String scheduleKey : scheduleKeyList) {
                    System.out.println("[" + ++count + "]" + ":" + scheduleKey);
                }
            }
        }
        System.out.println("====> dayScheduleDataMap");
        Set<String> yyyyMmDdList = this.dayScheduleMap.keySet();
        for (String yyyyMmDd : yyyyMmDdList) {
            count = 0;
            for (ScheduleData sd : this.dayScheduleMap.get(yyyyMmDd)) {
                System.out.println("[" + count + "]" + ":" + sd.createScheduleDataKey());
                ++count;
            }
        }
    }

    public abstract int addScheduleData(ArrayList<ScheduleData> var1);

    public abstract int delScheduleData(ArrayList<ScheduleData> var1);

    public void setOffLineMode(boolean offLineMode) {
        this.offLineMode = offLineMode;
    }

    public boolean isOffLineMode() {
        return this.offLineMode;
    }

    public JScheduleDataHeader getJScheduleHeader() {
        return this.jScheduleDataHeader;
    }

    protected void setJScheduleDataHeader(JScheduleDataHeader jsdh) {
        this.jScheduleDataHeader = jsdh;
    }

    public void projectCodeConvert(YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd, ProjectItem beforeProject, ProjectItem afterProject) {
        YyyyMmDdHolder targetYyyyMmDd = new YyyyMmDdHolder();
        targetYyyyMmDd.setYyyy(startYyyyMmDd.getYyyy());
        targetYyyyMmDd.setMm(startYyyyMmDd.getMm());
        targetYyyyMmDd.setDd(startYyyyMmDd.getDd());
        ArrayList<ScheduleData> addSdList = new ArrayList<ScheduleData>();
        while (targetYyyyMmDd.compareYyyyMmDd(endYyyyMmDd) == -1 || targetYyyyMmDd.compareYyyyMmDd(endYyyyMmDd) == 0) {
            for (ScheduleData sd : this.getDayScheduleList2(targetYyyyMmDd)) {
                sd.convertProjectCode(beforeProject.getCode(), afterProject.getCode());
                addSdList.add(sd);
            }
            targetYyyyMmDd.inclementDd();
        }
        this.addScheduleData(addSdList);
    }

    protected TreeMap<String, TreeMap<String, TreeMap<String, ScheduleData>>> getScheduleDataMap() {
        return this.scheduleDataMap;
    }

    protected void createDataMap() {
        this.scheduleDataMap = new TreeMap();
        this.dayScheduleMap = new TreeMap();
    }

    protected UserInfo getUserInfo() {
        return this.userInfo;
    }
}

