/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JScheduleDataHeader {
    private ArrayList<String> headerStrList = new ArrayList();
    private String userName = "";
    private Point mainFramePoint = new Point(0, 0);
    private Dimension mainFrameDimension = new Dimension(0, 0);
    private Point detailDialogPoint = new Point(0, 0);
    private Dimension detailDialogDimension = new Dimension(0, 0);

    public int readHeader(File file) {
        return this.readHeader(file, "");
    }

    public int readHeader(File file, String userName) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getPath()), "JISAutoDetect"));
            return this.readHeader(br, userName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int readHeader(BufferedReader br, String userName) {
        try {
            int i = 0;
            while (i < 6) {
                String tmpStr = br.readLine();
                this.headerStrList.add(tmpStr);
                if (i == 1) {
                    if (!tmpStr.isEmpty() && userName.isEmpty()) {
                        this.userName = tmpStr;
                    } else if (!userName.isEmpty()) {
                        this.userName = userName;
                    }
                }
                if (i == 2) {
                    this.initPointDimension(tmpStr);
                }
                ++i;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private void initPointDimension(String tmpString) {
        Pattern patternName = Pattern.compile("\\((-?\\d+),(-?\\d+)\\)\\[(\\d+),(\\d+)\\]\\((-?\\d+),(-?\\d+)\\)\\[(\\d+),(\\d+)\\]");
        Matcher matcherName = patternName.matcher(tmpString);
        if (matcherName.find()) {
            if (matcherName.group(1) != null && matcherName.group(2) != null) {
                String mainPositionXStr = matcherName.group(1);
                int mainX = Integer.valueOf(mainPositionXStr);
                String mainPositionYStr = matcherName.group(2);
                int mainY = Integer.valueOf(mainPositionYStr);
                this.mainFramePoint = new Point(mainX, mainY);
            }
            if (matcherName.group(3) != null && matcherName.group(4) != null) {
                String mainWidthStr = matcherName.group(3);
                int mainWidth = Integer.valueOf(mainWidthStr);
                String mainHeightStr = matcherName.group(4);
                int mainHeight = Integer.valueOf(mainHeightStr);
                this.mainFrameDimension = new Dimension(mainWidth, mainHeight);
            }
            if (matcherName.group(5) != null && matcherName.group(6) != null) {
                String detailPositionXStr = matcherName.group(5);
                int detailX = Integer.valueOf(detailPositionXStr);
                String detailPositionYStr = matcherName.group(6);
                int detailY = Integer.valueOf(detailPositionYStr);
                this.detailDialogPoint = new Point(detailX, detailY);
            }
            if (matcherName.group(7) != null && matcherName.group(8) != null) {
                String detailWidthStr = matcherName.group(7);
                int detailWidth = Integer.valueOf(detailWidthStr);
                String detailHeightStr = matcherName.group(8);
                int detailHeight = Integer.valueOf(detailHeightStr);
                this.detailDialogDimension = new Dimension(detailWidth, detailHeight);
            }
        }
    }

    public void createDummyHeader(String userName) {
        this.headerStrList.add("\u5716");
        this.headerStrList.add(userName);
        this.headerStrList.add("(0,0)[1030,719],(0,0)[526,367],0,1,0,2");
        this.headerStrList.add("\u5716");
        this.headerStrList.add("0000000000000000000000000");
        this.headerStrList.add("");
        this.setMainFramePoint(new Point(0, 0));
        this.setMainFrameDimension(new Dimension(1030, 719));
        this.setDetailDialogPoint(new Point(0, 0));
        this.setDetailDialogDimension(new Dimension(526, 367));
    }

    public int writeHeader(BufferedWriter bw) {
        try {
            int count = 0;
            for (String tmpStr : this.headerStrList) {
                if (count == 1 && !this.userName.isEmpty()) {
                    tmpStr = this.userName;
                }
                if (count == 2 && this.mainFramePoint != null) {
                    tmpStr = this.makePositionAndDimension();
                }
                bw.write(tmpStr);
                bw.newLine();
                ++count;
            }
            bw.write("\u5716");
            bw.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
            return -1;
        }
        return 0;
    }

    public ArrayList<String> getHeaderStrList() {
        return this.headerStrList;
    }

    public String getUserName() {
        return this.userName;
    }

    private String makePositionAndDimension() {
        String mainPoint = new String("(" + Integer.toString(this.mainFramePoint.x) + "," + Integer.toString(this.mainFramePoint.y) + ")");
        String mainDimension = new String("[" + Integer.toString(this.mainFrameDimension.width) + "," + Integer.toString(this.mainFrameDimension.height) + "]");
        String detailPoint = new String("(" + Integer.toString(this.detailDialogPoint.x) + "," + Integer.toString(this.detailDialogPoint.y) + ")");
        String detailDimension = new String("[" + Integer.toString(this.detailDialogDimension.width) + "," + Integer.toString(this.detailDialogDimension.height) + "]");
        return String.valueOf(mainPoint) + mainDimension + detailPoint + detailDimension;
    }

    public Point getMainFramePoint() {
        return this.mainFramePoint;
    }

    public void setMainFramePoint(Point mainFramePoint) {
        this.mainFramePoint = mainFramePoint;
    }

    public Dimension getMainFrameDimension() {
        return this.mainFrameDimension;
    }

    public void setMainFrameDimension(Dimension mainFrameDimension) {
        this.mainFrameDimension = mainFrameDimension;
    }

    public Point getDetailDialogPoint() {
        return this.detailDialogPoint;
    }

    public void setDetailDialogPoint(Point detailDialogPoint) {
        this.detailDialogPoint = detailDialogPoint;
    }

    public Dimension getDetailDialogDimension() {
        return this.detailDialogDimension;
    }

    public void setDetailDialogDimension(Dimension detailDialogDimension) {
        this.detailDialogDimension = detailDialogDimension;
    }
}

