/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import jScheduleData.JScheduleDataHeader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import workMasterData.ProjectItem;

public class JScheduleDataOld {
    private HashMap<String, HashMap<String, HashMap<String, ScheduleData>>> scheduleDataMap = new HashMap();
    private HashMap<String, ArrayList<ScheduleData>> dayScheduleMap = new HashMap();
    private UserInfo userInfo;
    private File file;
    private JScheduleDataHeader jScheduleDataHeader;
    private boolean offLineMode = false;

    public JScheduleDataOld(String fileName, UserInfo userInfo) {
        this.file = new File(fileName);
        this.userInfo = userInfo;
        if (this.file.exists() && this.file.canRead() && this.file.getPath().endsWith(".jsm")) {
            this.readScheduleData();
        } else {
            this.jScheduleDataHeader = new JScheduleDataHeader();
            this.jScheduleDataHeader.createDummyHeader(userInfo.getUserName());
            this.writeScheduleFile(this.file);
        }
    }

    private ArrayList<ScheduleData> getYearScheduleList(String yyyy) {
        ArrayList<ScheduleData> resultList = new ArrayList<ScheduleData>();
        if (this.scheduleDataMap.containsKey(yyyy)) {
            Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
            for (String mm : mmList) {
                Set<String> sdKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
                for (String sdKey : sdKeyList) {
                    resultList.add(this.scheduleDataMap.get(yyyy).get(mm).get(sdKey));
                }
            }
        }
        return resultList;
    }

    private ArrayList<ScheduleData> getMonthScheduleList(String yyyy, String mm) {
        ArrayList<ScheduleData> resultList = new ArrayList<ScheduleData>();
        if (this.scheduleDataMap.containsKey(yyyy) && this.scheduleDataMap.get(yyyy).containsKey(mm)) {
            Set<String> sdKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
            for (String sdKey : sdKeyList) {
                resultList.add(this.scheduleDataMap.get(yyyy).get(mm).get(sdKey));
            }
        }
        return resultList;
    }

    public HashMap<String, ScheduleData> getMonthSchedule(String yyyy, String mm) {
        if (this.scheduleDataMap.containsKey(yyyy) && this.scheduleDataMap.get(yyyy).containsKey(mm)) {
            return this.scheduleDataMap.get(yyyy).get(mm);
        }
        return new HashMap<String, ScheduleData>();
    }

    public ArrayList<ScheduleData> getDayScheduleList2(YyyyMmDdHolder yyyyMmDd) {
        ArrayList<ScheduleData> result = new ArrayList<ScheduleData>();
        DateInfo di = new DateInfo(yyyyMmDd.getYyyy(), yyyyMmDd.getMm(), yyyyMmDd.getDd(), "00", "00");
        if (this.dayScheduleMap.containsKey(di.createYyyyMmDdKey())) {
            for (ScheduleData sd : this.dayScheduleMap.get(di.createYyyyMmDdKey())) {
                result.add(sd);
            }
        }
        return result;
    }

    public ArrayList<ScheduleData> getScheduleListAfterDateInfo(DateInfo dateInfo) {
        ArrayList<ScheduleData> resultList = new ArrayList<ScheduleData>();
        String targetYyyy = dateInfo.getYyyy();
        String targetMm = dateInfo.getMm();
        Set<String> yyyyList = this.scheduleDataMap.keySet();
        for (String yyyy : yyyyList) {
            if (Integer.valueOf(targetYyyy) < Integer.valueOf(yyyy)) {
                resultList.addAll(this.getYearScheduleList(yyyy));
                continue;
            }
            if (Integer.valueOf(targetYyyy).intValue() != Integer.valueOf(yyyy).intValue()) continue;
            Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
            for (String mm : mmList) {
                if (Integer.valueOf(targetMm) < Integer.valueOf(mm)) {
                    resultList.addAll(this.getMonthScheduleList(yyyy, mm));
                    continue;
                }
                if (Integer.valueOf(targetMm).intValue() != Integer.valueOf(mm).intValue()) continue;
                for (ScheduleData sd : this.getMonthScheduleList(yyyy, mm)) {
                    if (!this.s_date_check(dateInfo, sd.getS_date()).booleanValue()) continue;
                    resultList.add(sd);
                }
            }
        }
        return resultList;
    }

    public ArrayList<ScheduleData> getDayScheduleList(String yyyy, String mm, String dd) {
        YyyyMmDdHolder yyyyMmDd = new YyyyMmDdHolder();
        yyyyMmDd.setYyyy(yyyy);
        yyyyMmDd.setMm(mm);
        yyyyMmDd.setDd(dd);
        return this.getDayScheduleList2(yyyyMmDd);
    }

    public int readScheduleData() {
        DateInfo sDateScope = new DateInfo("0000", "00", "00", "00", "00");
        return this.readScheduleData(sDateScope);
    }

    public int readScheduleData(DateInfo sDateScope) {
        if (this.readScheduleFile(this.file, sDateScope) < 0) {
            return -1;
        }
        return 0;
    }

    public void addSchedule(ScheduleData sd) {
        this.addSchedule2ScheduleDataMap2(sd);
        this.addSchedule2DayScheduleDataMap(sd);
        this.writeScheduleFile(this.file);
    }

    public void delSchedule(ScheduleData sd) {
        this.delScheduleFromScheduleDataMap(sd);
        this.delScheduleFromDayScheduleDataMap(sd);
        this.writeScheduleFile(this.file);
    }

    private void delScheduleFromScheduleDataMap(ScheduleData sd) {
        this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).remove(sd.createScheduleDataKey());
        if (this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).size() == 0) {
            this.scheduleDataMap.get(sd.getS_date().getYyyy()).remove(sd.getS_date().getMm());
            if (this.scheduleDataMap.get(sd.getS_date().getYyyy()).size() == 0) {
                this.scheduleDataMap.remove(sd.getS_date().getYyyy());
            }
        }
    }

    private void delScheduleFromDayScheduleDataMap(ScheduleData sd) {
        this.dayScheduleMap.get(sd.getS_date().createYyyyMmDdKey()).remove(sd);
    }

    public String getUserName() {
        return this.userInfo.getUserName();
    }

    public DateInfo getMaxSchduleDate() {
        String yyyy = this.getMaxYyyy();
        String mm = this.getMaxMm(yyyy);
        return this.getMaxDateInfo(yyyy, mm);
    }

    private String getMaxYyyy() {
        String maxYyyy = "0";
        Set<String> yyyyList = this.scheduleDataMap.keySet();
        for (String yyyy : yyyyList) {
            if (Integer.valueOf(maxYyyy) >= Integer.valueOf(yyyy)) continue;
            maxYyyy = yyyy;
        }
        return maxYyyy;
    }

    private String getMaxMm(String yyyy) {
        String maxMm = "0";
        Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
        for (String mm : mmList) {
            if (Integer.valueOf(maxMm) >= Integer.valueOf(mm)) continue;
            maxMm = mm;
        }
        return maxMm;
    }

    private DateInfo getMaxDateInfo(String yyyy, String mm) {
        DateInfo maxDateInfo = new DateInfo("0", "0", "0", "0", "0");
        Set<String> sdKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
        for (String sdKey : sdKeyList) {
            DateInfo targetDateInfo = this.scheduleDataMap.get(yyyy).get(mm).get(sdKey).getS_date();
            if (maxDateInfo.compareDateInfo(targetDateInfo) != -1) continue;
            maxDateInfo = targetDateInfo;
        }
        return maxDateInfo;
    }

    private void addSchedule2ScheduleDataMap2(ScheduleData sd) {
        if (this.scheduleDataMap.containsKey(sd.getS_date().getYyyy())) {
            if (this.scheduleDataMap.get(sd.getS_date().getYyyy()).containsKey(sd.getS_date().getMm())) {
                this.scheduleDataMap.get(sd.getS_date().getYyyy()).get(sd.getS_date().getMm()).put(sd.createScheduleDataKey(), sd);
            } else {
                HashMap<String, ScheduleData> mapScheduleKey = new HashMap<String, ScheduleData>();
                mapScheduleKey.put(sd.createScheduleDataKey(), sd);
                this.scheduleDataMap.get(sd.getS_date().getYyyy()).put(sd.getS_date().getMm(), mapScheduleKey);
            }
        } else {
            HashMap<String, ScheduleData> mapScheduleKey = new HashMap<String, ScheduleData>();
            mapScheduleKey.put(sd.createScheduleDataKey(), sd);
            HashMap<String, HashMap<String, ScheduleData>> mapMm = new HashMap<String, HashMap<String, ScheduleData>>();
            mapMm.put(sd.getS_date().getMm(), mapScheduleKey);
            this.scheduleDataMap.put(sd.getS_date().getYyyy(), mapMm);
        }
    }

    private void addSchedule2DayScheduleDataMap(ScheduleData sd) {
        String mapKey = sd.getS_date().createYyyyMmDdKey();
        if (this.dayScheduleMap.containsKey(mapKey)) {
            this.dayScheduleMap.get(mapKey).add(sd);
        } else {
            ArrayList<ScheduleData> sdList = new ArrayList<ScheduleData>();
            sdList.add(sd);
            this.dayScheduleMap.put(mapKey, sdList);
        }
    }

    private int readScheduleFile(File file, DateInfo sDateScope) {
        int position = 2;
        int result = 0;
        String derimita = "\u5716";
        String tmp_str = "";
        String title = "";
        String place = "";
        String projectUnitName = "";
        String prj_code = "";
        String phase = "";
        String action = "";
        String comment = "";
        boolean closed = false;
        boolean unFixed = false;
        String progressRatio = "0";
        int color = 0;
        DateInfo s_date = new DateInfo("0", "0", "0", "0", "0");
        DateInfo e_date = new DateInfo("0", "0", "0", "0", "0");
        BufferedReader br = null;
        try {
            br = this.createBufferedReader(file);
            if (br == null) {
                return -1;
            }
            try {
                this.readHeader(br);
                while ((tmp_str = br.readLine()) != null) {
                    if (tmp_str.equals(derimita)) {
                        if (this.s_date_check(sDateScope, s_date).booleanValue()) {
                            ScheduleData scheduleData = new ScheduleData();
                            scheduleData.title = title;
                            scheduleData.setS_date(s_date);
                            scheduleData.setE_date(e_date);
                            scheduleData.place = place;
                            if (projectUnitName.length() > 0) {
                                scheduleData.setProjectUnitName(projectUnitName);
                            } else {
                                scheduleData.setProjectUnitName(this.createProjectName(prj_code));
                            }
                            scheduleData.prj_code = prj_code;
                            scheduleData.setPhaseName(phase);
                            scheduleData.work = action;
                            scheduleData.comment = comment;
                            scheduleData.setClosed(closed);
                            scheduleData.setUnFixed(unFixed);
                            scheduleData.setProgressRatio(progressRatio);
                            scheduleData.colorInfo = color;
                            this.addSchedule2ScheduleDataMap2(scheduleData);
                            this.addSchedule2DayScheduleDataMap(scheduleData);
                        }
                        title = new String("");
                        place = new String("");
                        projectUnitName = new String("");
                        prj_code = new String("");
                        phase = new String("");
                        action = new String("");
                        comment = new String("");
                        closed = false;
                        unFixed = false;
                        progressRatio = "0";
                        position = 1;
                        continue;
                    }
                    if (position == 1) {
                        s_date = this.get_date_info(tmp_str, "s");
                        e_date = this.get_date_info(tmp_str, "e");
                        color = this.getColorInfo(tmp_str);
                        position = 2;
                        continue;
                    }
                    if (position == 2) {
                        title = tmp_str;
                        position = 3;
                        continue;
                    }
                    if (position == 3) {
                        place = tmp_str;
                        position = 4;
                        continue;
                    }
                    if (position == 4) {
                        String prjResult = this.get_prj_code(tmp_str);
                        if (prjResult != "") {
                            prj_code = prjResult;
                        } else if (tmp_str.length() > 0) {
                            comment = this.makeComment(comment, tmp_str);
                        }
                        position = 5;
                        continue;
                    }
                    if (position == 5) {
                        phase = tmp_str;
                        position = 6;
                        continue;
                    }
                    if (position == 6) {
                        action = tmp_str;
                        position = 7;
                        continue;
                    }
                    if (position == 7) {
                        if (this.isClosed(tmp_str)) {
                            closed = this.makeClosed(tmp_str);
                        } else {
                            comment = this.makeComment(comment, tmp_str);
                        }
                        position = 8;
                        continue;
                    }
                    if (position == 8) {
                        if (this.isUnFixed(tmp_str)) {
                            unFixed = this.makeUnFixed(tmp_str);
                        } else {
                            comment = this.makeComment(comment, tmp_str);
                        }
                        position = 9;
                        continue;
                    }
                    if (position == 9) {
                        String progressValue = "";
                        progressValue = this.makeProgressRatio(tmp_str);
                        if (progressValue != null) {
                            progressRatio = progressValue;
                        } else {
                            comment = this.makeComment(comment, tmp_str);
                        }
                        position = 10;
                        continue;
                    }
                    if (position == 10) {
                        String wkProjectUnitName = "";
                        wkProjectUnitName = this.makeProjectUnitName(tmp_str);
                        if (wkProjectUnitName != null) {
                            projectUnitName = wkProjectUnitName;
                        } else {
                            comment = this.makeComment(comment, tmp_str);
                        }
                        position = 11;
                        continue;
                    }
                    if (position < 11) continue;
                    comment = this.makeComment(comment, tmp_str);
                    position = 11;
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
                return -1;
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String makeComment(String comment, String tmp_str) {
        if (tmp_str.length() == 0) {
            return comment;
        }
        comment = comment.length() > 0 ? String.valueOf(comment) + "\n" + tmp_str : new String(tmp_str);
        return comment;
    }

    private String get_prj_code(String tmp_str) {
        String prj_code = "";
        Pattern pattern = Pattern.compile("\\d{2}.\\d{7}");
        Matcher matcher = pattern.matcher(tmp_str);
        if (tmp_str.length() == 10 && matcher.find()) {
            prj_code = tmp_str;
        }
        return prj_code;
    }

    private boolean isUnFixed(String str) {
        Pattern pattern = Pattern.compile("disable2Garoon");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private String makeProjectUnitName(String str) {
        Pattern pattern = Pattern.compile("^projectUnitName=(.*)");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find() && matcher.group(1) != null) {
            return matcher.group(1);
        }
        return null;
    }

    private String makeProgressRatio(String str) {
        Pattern pattern = Pattern.compile("progressRatio=(\\d*)");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find() && matcher.group(1) != null) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean makeUnFixed(String str) {
        return str.equals("disable2Garoon=true");
    }

    private boolean isClosed(String str) {
        Pattern pattern = Pattern.compile("closed");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private boolean makeClosed(String str) {
        return str.equals("closed=true");
    }

    private BufferedReader createBufferedReader(File file) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getPath()), "JISAutoDetect"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Boolean s_date_check(DateInfo s_date_scope, DateInfo s_date) {
        Boolean result = false;
        try {
            Integer wk_yyyy = Integer.valueOf(s_date_scope.getYyyy());
            Integer wk_mm = Integer.valueOf(s_date_scope.getMm());
            Integer wk_dd = Integer.valueOf(s_date_scope.getDd());
            Integer wk_HH = Integer.valueOf(s_date_scope.getHH());
            Integer wk_MM = Integer.valueOf(s_date_scope.getMM());
            Calendar cal = Calendar.getInstance();
            cal.set(wk_yyyy, wk_mm, wk_dd, wk_HH, wk_MM);
            Integer wk2_yyyy = Integer.valueOf(s_date.getYyyy());
            Integer wk2_mm = Integer.valueOf(s_date.getMm());
            Integer wk2_dd = Integer.valueOf(s_date.getDd());
            Integer wk2_HH = Integer.valueOf(s_date.getHH());
            Integer wk2_MM = Integer.valueOf(s_date.getMM());
            Calendar cal2 = Calendar.getInstance();
            cal2.set(wk2_yyyy, wk2_mm, wk2_dd, wk2_HH, wk2_MM);
            if (cal.before(cal2)) {
                result = true;
            }
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    private DateInfo get_date_info(String tmp_str, String s_e_flg) {
        DateInfo date_info = new DateInfo("0", "0", "0", "0", "0");
        String s_flg = "s";
        if (tmp_str.length() == 25) {
            if (s_e_flg.equals(s_flg)) {
                date_info.setYyyy(tmp_str.substring(0, 4));
                date_info.setMm(tmp_str.substring(4, 6));
                date_info.setDd(tmp_str.substring(6, 8));
                date_info.setHH(tmp_str.substring(8, 10));
                date_info.setMM(tmp_str.substring(10, 12));
            } else {
                date_info.setYyyy(tmp_str.substring(12, 16));
                date_info.setMm(tmp_str.substring(16, 18));
                date_info.setDd(tmp_str.substring(18, 20));
                date_info.setHH(tmp_str.substring(20, 22));
                date_info.setMM(tmp_str.substring(22, 24));
            }
        }
        return date_info;
    }

    private int getColorInfo(String tmpStr) {
        if (tmpStr.length() == 25) {
            return Integer.valueOf(tmpStr.substring(24));
        }
        return 0;
    }

    public void printScheduleData() {
        int count = 0;
        System.out.println("====> scheduleDataMap");
        Set<String> yyyyList = this.scheduleDataMap.keySet();
        for (String yyyy : yyyyList) {
            Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
            for (String mm : mmList) {
                Set<String> scheduleKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
                for (String scheduleKey : scheduleKeyList) {
                    System.out.println("[" + ++count + "]" + ":" + scheduleKey);
                }
            }
        }
        System.out.println("====> dayScheduleDataMap");
        Set<String> yyyyMmDdList = this.dayScheduleMap.keySet();
        for (String yyyyMmDd : yyyyMmDdList) {
            count = 0;
            for (ScheduleData sd : this.dayScheduleMap.get(yyyyMmDd)) {
                System.out.println("[" + count + "]" + ":" + sd.createScheduleDataKey());
                ++count;
            }
        }
    }

    private int readHeader(BufferedReader br) {
        this.jScheduleDataHeader = new JScheduleDataHeader();
        return this.jScheduleDataHeader.readHeader(br, this.userInfo.getUserName());
    }

    public int writeScheduleData() {
        return this.writeScheduleFile(this.file);
    }

    private int writeScheduleFile(File file) {
        if (this.offLineMode) {
            return 0;
        }
        File tmpFile = new File(String.valueOf(file.getPath()) + ".tmp");
        if (tmpFile.exists()) {
            System.err.println("warning writeSchduleFile err, file exist " + tmpFile.getName());
            tmpFile.delete();
        }
        if (this.writeTmpScheduleFile(String.valueOf(file.getPath()) + ".tmp") < 0) {
            System.err.println("writeTmpSchduleFile err " + file.getPath() + ".tmp");
            return -2;
        }
        File targetFile = file;
        File bakDir = new File(this.createBakDirName(targetFile));
        File backUpFile = new File(String.valueOf(this.createBakDirName(targetFile)) + targetFile.getName());
        File backUp2File = new File(String.valueOf(this.createBakDirName(targetFile)) + targetFile.getName() + "bak2");
        if (!bakDir.exists()) {
            try {
                if (!bakDir.mkdir()) {
                    System.err.println("bakDir create err " + bakDir.getAbsolutePath());
                    return -2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (backUpFile.exists()) {
            if (backUp2File.exists()) {
                backUp2File.delete();
            }
            if (!backUpFile.renameTo(backUp2File)) {
                System.err.println("writeSchduleFile err, renameTo, backUp2backUp2");
                return -3;
            }
        }
        if (targetFile.exists() && !targetFile.renameTo(backUpFile)) {
            System.err.println("writeSchduleFile err, renameTo, target2backUp " + backUpFile);
            return -4;
        }
        if (!tmpFile.renameTo(targetFile)) {
            System.err.println("writeSchduleFile err, renameTo, tmp2target");
            return -5;
        }
        if (backUp2File.exists() && !backUp2File.delete()) {
            System.err.println("writeSchduleFile err, delete");
            return -6;
        }
        return 0;
    }

    private int writeTmpScheduleFile(String fileName) {
        BufferedWriter bw;
        block5: {
            block4: {
                bw = null;
                try {
                    bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
                    if (this.jScheduleDataHeader.writeHeader(bw) >= 0) break block4;
                    return -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e" + fileName);
                    return -1;
                }
            }
            if (this.writeBody(bw) >= 0) break block5;
            return -2;
        }
        bw.close();
        return 0;
    }

    private String createBakDirName(File targetFile) {
        String result = targetFile.getAbsoluteFile().getParent();
        result = String.valueOf(result) + "\\bak\\";
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int writeBody(BufferedWriter bw) {
        try {
            Set<String> yyyyList = this.scheduleDataMap.keySet();
            for (String yyyy : yyyyList) {
                Set<String> mmList = this.scheduleDataMap.get(yyyy).keySet();
                for (String mm : mmList) {
                    Set<String> scheduleKeyList = this.scheduleDataMap.get(yyyy).get(mm).keySet();
                    for (String scheduleKey : scheduleKeyList) {
                        if (this.writeOneScheduleData(bw, this.scheduleDataMap.get(yyyy).get(mm).get(scheduleKey)) >= 0) continue;
                        return -1;
                    }
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
            return -2;
        }
    }

    private int writeOneScheduleData(BufferedWriter bw, ScheduleData sd) {
        try {
            bw.write(String.valueOf(sd.getS_date().getYyyy()) + sd.getS_date().getMm() + sd.getS_date().getDd() + sd.getS_date().getHH() + sd.getS_date().getMM() + sd.getE_date().getYyyy() + sd.getE_date().getMm() + sd.getE_date().getDd() + sd.getE_date().getHH() + sd.getE_date().getMM() + sd.colorInfo);
            bw.newLine();
            bw.write(sd.title);
            bw.newLine();
            bw.write(sd.place);
            bw.newLine();
            bw.write(sd.prj_code);
            bw.newLine();
            bw.write(sd.getPhaseName());
            bw.newLine();
            bw.write(sd.work);
            bw.newLine();
            if (sd.isClosed()) {
                bw.write("closed=true");
            } else {
                bw.write("closed=false");
            }
            bw.newLine();
            if (sd.isUnFixed()) {
                bw.write("disable2Garoon=true");
            } else {
                bw.write("disable2Garoon=false");
            }
            bw.newLine();
            bw.write("progressRatio=" + Integer.toString(sd.getProgressRatio()));
            bw.newLine();
            bw.write("projectUnitName=" + sd.getProjectUnitName());
            bw.newLine();
            bw.write(sd.comment);
            bw.newLine();
            bw.write("\u5716");
            bw.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public void setOffLineMode(boolean offLineMode) {
        this.offLineMode = offLineMode;
    }

    public boolean isOffLineMode() {
        return this.offLineMode;
    }

    public JScheduleDataHeader getJScheduleHeader() {
        return this.jScheduleDataHeader;
    }

    public void projectCodeConvert(YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd, ProjectItem beforeProject, ProjectItem afterProject) {
        YyyyMmDdHolder targetYyyyMmDd = new YyyyMmDdHolder();
        targetYyyyMmDd.setYyyy(startYyyyMmDd.getYyyy());
        targetYyyyMmDd.setMm(startYyyyMmDd.getMm());
        targetYyyyMmDd.setDd(startYyyyMmDd.getDd());
        while (targetYyyyMmDd.compareYyyyMmDd(endYyyyMmDd) == -1 || targetYyyyMmDd.compareYyyyMmDd(endYyyyMmDd) == 0) {
            for (ScheduleData sd : this.getDayScheduleList2(targetYyyyMmDd)) {
                sd.convertProjectCode(beforeProject.getCode(), afterProject.getCode());
            }
            targetYyyyMmDd.inclementDd();
        }
    }

    private String createProjectName(String projectCode) {
        ProjectNameConv pnc = new ProjectNameConv(this.userInfo);
        return pnc.getProjectUnitName(projectCode);
    }

    private class ProjectNameConv {
        HashMap<String, String> projectNameMap;
        HashMap<String, String> sapMenberMap = new HashMap();

        public ProjectNameConv(UserInfo userInfo) {
            this.projectNameMap = new HashMap();
            this.sapMenberMap.put("gu", "sap");
            this.sapMenberMap.put("HIROKI-SUGITA", "sap");
            this.sapMenberMap.put("takamichi_takeuchi", "sap");
            this.sapMenberMap.put("\u5efa\u5c71\u5e78\u5e83", "sap");
            this.sapMenberMap.put("\u65b0\u4e95\u5c06\u6643", "sap");
            this.sapMenberMap.put("\u6589\u85e4\u654f\u548c", "sap");
            this.sapMenberMap.put("\u7530\u4e2d\u6b63\u6d0b", "sap");
            if (this.checkSap(userInfo)) {
                this.projectNameMap.put("41X0042301", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SAP)");
                this.projectNameMap.put("4101163101", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SAP)");
                this.projectNameMap.put("4101453001", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SAP)");
                this.projectNameMap.put("41X0042301", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SAP)");
            } else {
                this.projectNameMap.put("41X0042301", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SYS)");
                this.projectNameMap.put("4101163101", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SYS)");
                this.projectNameMap.put("4101453001", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SYS)");
                this.projectNameMap.put("41X0042301", "core2 \u69cb\u7bc9\u30d5\u30a7\u30fc\u30ba \u30a4\u30f3\u30d5\u30e9(SYS)");
            }
            this.projectNameMap.put("34X0004801", "\u7b2c\uff13\u8005\u30ec\u30d3\u30e5\u30fc\uff08\u30ec\u30d3\u30e5\u30fc\u30a2\uff09");
            this.projectNameMap.put("9999999106", "\u5de5\u6570\u96c6\u8a08\u5bfe\u8c61\u5916");
            this.projectNameMap.put("38X0086101", "\u30d7\u30ed\u652f\uff0d\u958b\uff0d\uff2c\uff2d");
            this.projectNameMap.put("38X0085801", "\u30d7\u30ed\u652f\uff0d\u958b\uff0d\u6280\u8853\u30b5\u30dd\u30fc\u30c8");
            this.projectNameMap.put("35X0040301", "\u30d7\u30ed\u652f\uff0d\u958b\uff0d\u6280\u8853\u7fd2\u5f97");
            this.projectNameMap.put("38X0032601", "\u30d7\u30ed\u652f\uff0d\u958b\uff0d\u59d4\u54e1\u4f1a\u6d3b\u52d5");
        }

        private boolean checkSap(UserInfo userInfo) {
            return this.sapMenberMap.containsKey(userInfo.getUserId());
        }

        public String getProjectUnitName(String projectCode) {
            if (this.projectNameMap.containsKey(projectCode)) {
                return this.projectNameMap.get(projectCode);
            }
            return projectCode;
        }
    }
}

