/*
 * Decompiled with CFR 0.152.
 */
package mScheduler;

import commonData.MmDdHolder;
import commonData.UserInfo;
import commonData.YyyyMmHolder;
import configInfo.JSchedulerConfig;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.HolidayInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import mScheduler.AtmuoSyncProcessCtl;
import mScheduler.GaroonSyncProcessCtl;
import mScheduler.GoogleCalendarSyncProcessCtl;
import mScheduler.IthdSchedulerSyncProcessCtl;
import scheduleData.ScheduleData;
import scheduleExtract.DelSchedule;
import uiControlPanel.AddGaroonJButtonListener;
import uiControlPanel.AddMuoJButtonListener;
import uiControlPanel.ControlPanel;
import uiControlPanel.CreateCsvJButtonListener;
import uiControlPanel.CreateDataConvertJButtonListener;
import uiControlPanel.CreateDelivaryStatementJButtonListener;
import uiControlPanel.CreateEvmResultJButtonListener;
import uiControlPanel.CreateManHourJButtonListener;
import uiControlPanel.DeleteGaroonJButtonListener;
import uiControlPanel.GetGaroonJButtonListener;
import uiControlPanel.OffLineJToggleButtonListener;
import uiControlPanel.ReadJScheduleDataJButtonListener;
import uiControlPanel.SyncGaroonJButtonListener;
import uiControlPanel.SyncGoogleCalendarJButtonListener;
import uiControlPanel.SyncIthdSchedulerJButtonListener;
import uiCsv.CsvResultReqListener;
import uiDataConvert.DataConvertDialog;
import uiDataConvert.DataConvertReqListener;
import uiDaySchedule.DayScheduleDialog;
import uiDeliveryStatement.DeliveryStatementDialog;
import uiDeliveryStatement.DeliveryStatementListener;
import uiDetailSchedule.DetailScheduleJDialog2;
import uiDetailSchedule.DetailScheduleListener;
import uiEvmResult.EvmResultReqListener;
import uiEvmResult.EvmResultRequestDialog;
import uiMonthSchedule.ArrowPanelListener;
import uiMonthSchedule.MonthScheduleHeader;
import uiMonthSchedule.MonthSchedulePanel3Imp;
import uiMonthSchedule.MonthSchedulePanel3Listener;
import uiMonthSchedule.VersionInfoPanelListener;
import uiMuoCtl.MuoCtlListener;
import uiUserInfo.UserInfoPanel;
import uiUserInfo.UserInfoPanelListener;
import userInfoData.UserInfoData;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectUnitList;
import workMasterData.WorkInfoListMap;

public abstract class MSchedulerFrame
extends JFrame
implements KeyListener,
ComponentListener,
MonthSchedulePanel3Listener,
DetailScheduleListener,
ArrowPanelListener,
VersionInfoPanelListener,
AddGaroonJButtonListener,
GetGaroonJButtonListener,
DeleteGaroonJButtonListener,
AddMuoJButtonListener,
UserInfoPanelListener,
CreateCsvJButtonListener,
MuoCtlListener,
CsvResultReqListener,
CreateManHourJButtonListener,
CreateDelivaryStatementJButtonListener,
DeliveryStatementListener,
CreateEvmResultJButtonListener,
EvmResultReqListener,
CreateDataConvertJButtonListener,
DataConvertReqListener,
ReadJScheduleDataJButtonListener,
OffLineJToggleButtonListener,
SyncGoogleCalendarJButtonListener,
SyncGaroonJButtonListener,
SyncIthdSchedulerJButtonListener {
    private static final long serialVersionUID = 1L;
    protected JSchedulerConfig jsc;
    protected YyyyMmHolder currentMonth;
    protected MonthSchedulePanel3Imp msp3;
    protected AllUserJScheduleData aujsd;
    protected HolidayInfo holidayInfo;
    protected ProjectUnitList projectUnitList;
    protected PhaseInfoListMap phaseInfoListMap;
    protected WorkInfoListMap workInfoListMap;
    protected UserInfo currentUserInfo;
    protected ArrayList<UserInfo> userInfoList;
    protected IthdSchedulerSyncProcessCtl isspctl;
    protected GoogleCalendarSyncProcessCtl gcspctl;
    protected GaroonSyncProcessCtl gspctl;
    protected AtmuoSyncProcessCtl aspctl;
    protected JSplitPane leftPane;
    protected ControlPanel controlPanel;
    protected UserInfoPanel userInfoPanel;
    protected JScrollPane scrollPane;
    protected JSplitPane splitPane;
    protected DetailScheduleJDialog2 dsf;
    protected DayScheduleDialog dayScheduleDialog;
    protected DeliveryStatementDialog deliveryStatementDialog;
    protected EvmResultRequestDialog evmRequestDialog;
    protected DataConvertDialog dataConvertDialog;
    protected ScheduleData selectedScheduleData;
    protected UserInfo selectedUserInfo;
    protected ScheduleData selectedScheduleData2;
    protected UserInfo selectedUserInfo2;
    protected DelSchedule delSchedule;
    protected JComponent sheet;
    protected JPanel glass;
    protected JOptionPane optionPane;

    public MSchedulerFrame(String title, UserInfo currentUserInfo, String yyyy, String mm, AllUserJScheduleData aujsd, HolidayInfo holidayInfo, JSchedulerConfig jsc, ProjectUnitList projectUnitList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap, UserInfoData userInfoData) {
        this.setDefaultCloseOperation(3);
        this.currentMonth = new YyyyMmHolder(yyyy, mm);
        this.aujsd = aujsd;
        this.jsc = jsc;
        this.currentUserInfo = currentUserInfo;
        this.userInfoList = new ArrayList();
        this.userInfoList.add(currentUserInfo);
        this.holidayInfo = holidayInfo;
        this.projectUnitList = projectUnitList;
        this.phaseInfoListMap = phaseInfoListMap;
        this.workInfoListMap = workInfoListMap;
        this.delSchedule = new DelSchedule();
        this.glass = (JPanel)this.getGlassPane();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isspctl = new IthdSchedulerSyncProcessCtl(this.currentUserInfo, jsc.getIthdSchedulerConfig(), aujsd.getJScheduleData(currentUserInfo));
        this.gcspctl = new GoogleCalendarSyncProcessCtl(this.currentUserInfo, jsc.getGoogleCalendarConfig(), aujsd.getJScheduleData(currentUserInfo));
        this.gspctl = new GaroonSyncProcessCtl(jsc.getGaroonConfig(), aujsd.getJScheduleData(currentUserInfo));
        this.aspctl = new AtmuoSyncProcessCtl(jsc.getAtmuo_config());
        this.initJScheduleFrame(aujsd.getJScheduleData(currentUserInfo).getJScheduleHeader().getMainFramePoint(), aujsd.getJScheduleData(currentUserInfo).getJScheduleHeader().getMainFrameDimension(), yyyy, mm, title, userInfoData.getRootUserInfo(), jsc);
        this.setVisible(true);
    }

    private void initJScheduleFrame(Point point, Dimension dimension, String yyyy, String mm, String title, UserInfo rootUserInfo, JSchedulerConfig jsc) {
        this.setTitle(title);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setDividerSize(3);
        this.leftPane = new JSplitPane(0);
        this.leftPane.setDividerSize(2);
        this.controlPanel = new ControlPanel(this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, jsc);
        this.leftPane.setLeftComponent(this.controlPanel);
        this.userInfoPanel = new UserInfoPanel(rootUserInfo, this);
        this.userInfoPanel.setLayout(new FlowLayout(0));
        this.userInfoPanel.setBackground(new Color(255, 255, 255));
        JScrollPane jsp = new JScrollPane();
        jsp.getVerticalScrollBar().setUnitIncrement(7);
        jsp.getHorizontalScrollBar().setUnitIncrement(10);
        this.splitPane.setLeftComponent(jsp);
        jsp.setViewportView(this.userInfoPanel);
        this.leftPane.setRightComponent(jsp);
        this.splitPane.setLeftComponent(this.leftPane);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(7);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.splitPane.setRightComponent(this.scrollPane);
        this.createMonthSchedule(yyyy, mm, this.currentUserInfo, this.userInfoList, this.aujsd, this.holidayInfo);
        this.add(this.splitPane);
        URL url = this.getClass().getClassLoader().getResource("image/mScheduler.gif");
        ImageIcon icon = new ImageIcon(url);
        this.setIconImage(icon.getImage());
        this.setBounds(point.x, point.y, dimension.width, dimension.height);
    }

    protected void createMonthSchedule(String yyyy, String mm, UserInfo currentUserInfo, ArrayList<UserInfo> userIdList, AllUserJScheduleData aujsd, HolidayInfo holidayInfo) {
        this.msp3 = this.createMonthSchedulePanel3(yyyy, mm, currentUserInfo, userIdList, aujsd, holidayInfo);
        this.scrollPane.setViewportView(this.msp3);
        this.scrollPane.setColumnHeaderView(new MonthScheduleHeader(this.jsc.get_month_panel_config(), yyyy, mm, 8, 22, 0.5, 48, 20, this, this));
    }

    private MonthSchedulePanel3Imp createMonthSchedulePanel3(String yyyy, String mm, UserInfo currentUserInfo, ArrayList<UserInfo> userIdList, AllUserJScheduleData aujsd, HolidayInfo holidayInfo) {
        return new MonthSchedulePanel3Imp(this.jsc.get_month_panel_config(), 0.5, 20.0, 48, 20, 8, 22, yyyy, mm, currentUserInfo, userIdList, aujsd, holidayInfo, this);
    }

    public void nextMonthSchedule() {
        YyyyMmHolder yyyyMmHolder;
        this.currentMonth = yyyyMmHolder = this.inclimentMonth(this.currentMonth.getYyyy(), this.currentMonth.getMm());
        this.createMonthSchedulePanel();
    }

    public void beforeMonthSchedule() {
        YyyyMmHolder yyyyMmHolder;
        this.currentMonth = yyyyMmHolder = this.declimentMonth(this.currentMonth.getYyyy(), this.currentMonth.getMm());
        this.createMonthSchedulePanel();
    }

    public void addSchedule(ScheduleData sd, UserInfo userInfo) {
        this.addSchedule(sd, userInfo, false);
    }

    public void addSchedule(ScheduleData sd, UserInfo userInfo, boolean selectFlag) {
        this.aujsd.addScheduleData(userInfo, sd);
        YyyyMmHolder currentMonth = this.msp3.getCurrnentMonth();
        if (currentMonth.getYyyy().equals(sd.getS_date().getYyyy()) && currentMonth.getMm().equals(sd.getS_date().getMm()) && this.isThereInUserInfoList(userInfo)) {
            this.msp3.addSchedule(sd, userInfo, selectFlag);
            this.msp3.selectOn(sd, userInfo);
            if (this.dayScheduleDialog != null) {
                this.dayScheduleDialog.getDaySchedulePanel().addSchedule(sd, userInfo, selectFlag);
                this.dayScheduleDialog.getDaySchedulePanel().selectOn(sd, userInfo);
            }
        }
        if (this.selectedScheduleData != null && !this.selectedScheduleData.compare(sd)) {
            this.msp3.selectOff(this.selectedScheduleData, this.selectedUserInfo);
            if (this.dayScheduleDialog != null) {
                this.dayScheduleDialog.getDaySchedulePanel().selectOff(this.selectedScheduleData, this.selectedUserInfo);
            }
        }
        this.selectedScheduleData = sd;
        this.selectedUserInfo = userInfo;
        if (this.dsf != null) {
            this.dsf.addPanel(sd, userInfo, this.currentUserInfo);
        }
        this.deleteFromDelScheduleList(sd);
    }

    private void deleteFromDelScheduleList(ScheduleData sd) {
        ArrayList<ScheduleData> sdList = new ArrayList<ScheduleData>();
        for (ScheduleData delSd : this.delSchedule.getScheduleDataList()) {
            if (sd.compare(delSd)) continue;
            sdList.add(delSd);
        }
        this.delSchedule.setScheduleDataList(sdList);
    }

    protected boolean checkUserInfo(UserInfo userInfo) {
        if (this.currentUserInfo.compareUserId(userInfo)) {
            return true;
        }
        return this.isThereInUserInfoList(userInfo);
    }

    protected boolean isThereInUserInfoList(UserInfo userInfo) {
        for (UserInfo listUserInfo : this.userInfoList) {
            if (!userInfo.compareUserId(listUserInfo)) continue;
            return true;
        }
        return false;
    }

    protected void delSchedule(ScheduleData sd, UserInfo userInfo) {
        this.aujsd.delScheduleData(userInfo, sd);
        this.msp3.delSchedule(sd, userInfo);
        this.delSchedule.addScheduleData(sd);
        this.selectedScheduleData = null;
        this.selectedScheduleData2 = null;
        this.selectedUserInfo = null;
        this.selectedUserInfo2 = null;
        if (this.dsf != null && this.dsf.getScheduleData().compare(sd) && this.dsf.getUserInfo().compareUserId(userInfo)) {
            this.dsf.addPanel(null, null, null);
        }
        if (this.dayScheduleDialog != null) {
            this.dayScheduleDialog.getDaySchedulePanel().delSchedule(sd, userInfo);
        }
    }

    protected void delScheduleByDndMove(ScheduleData sd, UserInfo userInfo) {
        this.aujsd.delScheduleData(userInfo, sd);
        this.msp3.delSchedule(sd, userInfo);
        this.delSchedule.addScheduleData(sd);
        if (this.dayScheduleDialog != null) {
            this.dayScheduleDialog.getDaySchedulePanel().delSchedule(sd, userInfo);
        }
    }

    private YyyyMmHolder inclimentMonth(String yyyy, String mm) {
        String wkYyyy = "";
        String wkMm = "";
        if (Integer.valueOf(mm) < 12) {
            wkYyyy = yyyy;
            wkMm = Integer.toString(Integer.valueOf(mm) + 1);
        } else {
            wkYyyy = Integer.toString(Integer.valueOf(yyyy) + 1);
            wkMm = "01";
        }
        return new YyyyMmHolder(wkYyyy, wkMm);
    }

    private YyyyMmHolder declimentMonth(String yyyy, String mm) {
        String wkYyyy = "";
        String wkMm = "";
        if (Integer.valueOf(mm) > 1) {
            wkYyyy = yyyy;
            wkMm = Integer.toString(Integer.valueOf(mm) - 1);
        } else {
            wkYyyy = Integer.toString(Integer.valueOf(yyyy) - 1);
            wkMm = "12";
        }
        return new YyyyMmHolder(wkYyyy, wkMm);
    }

    public int getJScheduleFrameUpperLeftX() {
        Rectangle rectangle = this.getBounds();
        return rectangle.x;
    }

    public int getJScheduleFrameUpperLeftY() {
        Rectangle rectangle = this.getBounds();
        return rectangle.y;
    }

    public int getJScheduleFrameUpperLeftPlusX() {
        Rectangle rectangle = this.getBounds();
        return rectangle.x + this.splitPane.getLeftComponent().getBounds().width + 5;
    }

    public int getJScheduleFrameUpperLeftPlusY() {
        Rectangle rectangle = this.getBounds();
        return rectangle.y + 30;
    }

    protected void add2UserInfoList(ArrayList<UserInfo> addUserInfoList) {
        if (addUserInfoList.isEmpty()) {
            return;
        }
        if (!this.userInfoList.addAll(addUserInfoList)) {
            System.err.println(String.valueOf(this.getClass().getName()) + "UserInfoList add failed");
        }
        System.out.println("----> add2UserInfoList");
        for (UserInfo userInfo : this.userInfoList) {
            System.out.println("   added " + userInfo.getUserId());
        }
    }

    protected void remFromUserInfoList(ArrayList<UserInfo> remUserInfoList) {
        if (remUserInfoList.isEmpty()) {
            return;
        }
        for (UserInfo remUserInfo : remUserInfoList) {
            int index = -1;
            int max = this.userInfoList.size();
            int j = 0;
            while (j < max) {
                UserInfo targetUserInfo = this.userInfoList.get(j);
                if (targetUserInfo.compareUserId(remUserInfo)) {
                    index = j;
                    break;
                }
                ++j;
            }
            if (index < 0) continue;
            this.userInfoList.remove(index);
        }
        System.out.println("----> remFromUserInfoList");
        for (UserInfo userInfo : this.userInfoList) {
            System.out.println("   remed " + userInfo.getUserId());
        }
    }

    protected void createDaySchedulePanel(int dd, int x, int y) {
        System.out.println("called createDaySchedulePanel");
        MmDdHolder mmDd = new MmDdHolder();
        mmDd.setTargetDd(Integer.toString(dd));
        this.dayScheduleDialog = new DayScheduleDialog(this, "mScheduler Day", x, y, this.jsc.get_month_panel_config().getHolizontai_ratio_double(), 20.0, 48, 20, 8, 22, this.currentMonth.getYyyy(), this.currentMonth.getMm(), mmDd.getTargetDd(), this.currentUserInfo, this.userInfoList, this.aujsd, this.holidayInfo, this);
    }

    protected String[] intList2StringListWithIncrement(int[] intList) {
        String[] stringList = new String[intList.length];
        int i = 0;
        while (i < intList.length) {
            stringList[i] = Integer.toString(intList[i] + 1);
            ++i;
        }
        return stringList;
    }

    protected void createMonthSchedulePanel() {
        this.createMonthSchedule(this.currentMonth.getYyyy(), this.currentMonth.getMm(), this.currentUserInfo, this.userInfoList, this.aujsd, this.holidayInfo);
        if (this.selectedScheduleData != null && this.selectedScheduleData.getS_date().getYyyy().equals(this.currentMonth.getYyyy()) && this.selectedScheduleData.getS_date().getMm().equals(this.currentMonth.getMm())) {
            this.msp3.selectOn(this.selectedScheduleData, this.selectedUserInfo);
        }
    }

    protected void copy2Clipboad(String str) {
        Clipboard clipboad = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selection = new StringSelection(str);
        clipboad.setContents(selection, selection);
    }
}

