/*
 * Decompiled with CFR 0.152.
 */
package manHourData;

import commonData.UserInfo;
import commonData.YyyyMmHolder;
import configInfo.ManHourDataConfig;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.HolidayInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import manHourData.ManHourOneData;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import workMasterData.ProjectUnitList;

public class ManHourData {
    private HolidayInfo holidayInfo;
    private ProjectUnitList projectUnitList;
    private Calendar cal;
    private YyyyMmHolder currentMonth;
    private ArrayList<UserInfo> userInfoList;
    private int workDaysOfMonth = 0;
    private HashMap<String, Double> workTimeResultMap;
    private HashMap<String, Double> workTimePlanMap;
    private HashMap<String, Double> overTimeResultMap;
    private HashMap<String, Double> overTimePlanMap;
    private HashMap<String, HashMap<String, String>> projectCodeMapMap;
    private HashMap<String, HashMap<String, Double>> projectResultMap;
    private HashMap<String, HashMap<String, Double>> projectPlanMap;
    private TreeMap<String, Double> ddWorkTime;
    private HashMap<String, Double> outOfWorkTimeResultMap;
    private HashMap<String, Double> outOfWorkTimePlanMap;
    private final String outOfWorkProjectCode;
    private final double standardWorkTimeOfDay;

    public ManHourData(YyyyMmHolder yyyyMm, HolidayInfo holidayInfo, ManHourDataConfig manHourDataConfig, ProjectUnitList projectUnitList) {
        this.cal = this.initCalendar(Integer.valueOf(yyyyMm.getYyyy()), Integer.valueOf(yyyyMm.getMm()));
        this.currentMonth = yyyyMm;
        this.holidayInfo = holidayInfo;
        this.projectUnitList = projectUnitList;
        this.outOfWorkProjectCode = manHourDataConfig.getOut_of_work_project_code() != null ? manHourDataConfig.getOut_of_work_project_code() : "9999999106";
        this.standardWorkTimeOfDay = manHourDataConfig.getStandard_work_time_of_day() != null ? Double.valueOf(manHourDataConfig.getStandard_work_time_of_day()) : 7.75;
        this.workTimeResultMap = new HashMap();
        this.workTimePlanMap = new HashMap();
        this.overTimeResultMap = new HashMap();
        this.overTimePlanMap = new HashMap();
        this.projectCodeMapMap = new HashMap();
        this.projectResultMap = new HashMap();
        this.projectPlanMap = new HashMap();
        this.ddWorkTime = new TreeMap();
        this.outOfWorkTimeResultMap = new HashMap();
        this.outOfWorkTimePlanMap = new HashMap();
    }

    private Calendar initCalendar(int yyyy, int mm) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, yyyy);
        cal.set(2, mm - 1);
        return cal;
    }

    public void calcManHourData(AllUserJScheduleData aujsd, ArrayList<UserInfo> userInfoList, DateInfo todayDi) {
        this.userInfoList = userInfoList;
        for (UserInfo userInfo : userInfoList) {
            TreeMap<String, ScheduleData> sdMap = aujsd.getJScheduleData(userInfo).getMonthSchedule(this.currentMonth.getYyyy(), this.currentMonth.getMm());
            if (sdMap == null) continue;
            this.ddWorkTime = new TreeMap();
            this.analyseUserMonthData(userInfo, this.currentMonth, sdMap, todayDi);
        }
    }

    private void analyseUserMonthData(UserInfo userInfo, YyyyMmHolder yyyyMm, TreeMap<String, ScheduleData> sdMap, DateInfo todayDi) {
        this.initElements4UserId(userInfo);
        Set<String> scheduleKeyList = sdMap.keySet();
        for (String scheduleKey : scheduleKeyList) {
            this.analyseOneScheduleData(userInfo, sdMap.get(scheduleKey), todayDi);
        }
        this.analyseOverTime(this.currentMonth, userInfo, todayDi, this.holidayInfo, this.cal);
    }

    private void initElements4UserId(UserInfo userInfo) {
        this.workTimeResultMap.put(userInfo.getUserId(), 0.0);
        this.workTimePlanMap.put(userInfo.getUserId(), 0.0);
        this.overTimeResultMap.put(userInfo.getUserId(), 0.0);
        this.overTimePlanMap.put(userInfo.getUserId(), 0.0);
        this.projectCodeMapMap.put(userInfo.getUserId(), new HashMap());
        this.projectResultMap.put(userInfo.getUserId(), new HashMap());
        this.projectPlanMap.put(userInfo.getUserId(), new HashMap());
        this.ddWorkTime.put(userInfo.getUserId(), 0.0);
        this.outOfWorkTimeResultMap.put(userInfo.getUserId(), 0.0);
        this.outOfWorkTimePlanMap.put(userInfo.getUserId(), 0.0);
    }

    private void initElements4ProjectCode(UserInfo userInfo, String projectCode) {
        this.projectResultMap.get(userInfo.getUserId()).put(projectCode, 0.0);
        this.projectPlanMap.get(userInfo.getUserId()).put(projectCode, 0.0);
    }

    private void analyseOneScheduleData(UserInfo userInfo, ScheduleData sd, DateInfo todayDi) {
        if (sd.getPrj_code().length() == 0) {
            return;
        }
        if (this.ddWorkTime.containsKey(sd.getS_date().getDd())) {
            double totalWorkTime = this.ddWorkTime.get(sd.getS_date().getDd());
            this.ddWorkTime.put(sd.getS_date().getDd(), totalWorkTime += sd.getTimeByHour());
        } else {
            this.ddWorkTime.put(sd.getS_date().getDd(), sd.getTimeByHour());
        }
        if (this.projectCodeMapMap.containsKey(userInfo.getUserId())) {
            this.projectCodeMapMap.get(userInfo.getUserId()).put(sd.getPrj_code(), sd.getProjectUnitName());
        } else {
            HashMap<String, String> projectCodeMap = new HashMap<String, String>();
            projectCodeMap.put(sd.getPrj_code(), sd.getProjectUnitName());
            this.projectCodeMapMap.put(userInfo.getUserId(), projectCodeMap);
            this.initElements4ProjectCode(userInfo, sd.getPrj_code());
        }
        if (sd.getS_date().compareDateInfo(todayDi) == -1) {
            if (this.projectResultMap.containsKey(userInfo.getUserId())) {
                if (this.projectResultMap.get(userInfo.getUserId()).containsKey(sd.getPrj_code())) {
                    double totalWorkTime = this.projectResultMap.get(userInfo.getUserId()).get(sd.getPrj_code());
                    this.projectResultMap.get(userInfo.getUserId()).put(sd.getPrj_code(), totalWorkTime += sd.getTimeByHour());
                } else {
                    this.projectResultMap.get(userInfo.getUserId()).put(sd.getPrj_code(), sd.getTimeByHour());
                }
            } else {
                HashMap<String, Double> projectMap = new HashMap<String, Double>();
                projectMap.put(sd.getPrj_code(), sd.getTimeByHour());
                this.projectResultMap.put(userInfo.getUserId(), projectMap);
            }
            double wkResult = this.workTimeResultMap.get(userInfo.getUserId()) + sd.getTimeByHour();
            this.workTimeResultMap.put(userInfo.getUserId(), wkResult);
            if (sd.getPrj_code().equals(this.outOfWorkProjectCode)) {
                this.outOfWorkTimeResultMap.put(userInfo.getUserId(), this.outOfWorkTimeResultMap.get(userInfo.getUserId()) + sd.getTimeByHour());
            }
        } else {
            if (this.projectPlanMap.containsKey(userInfo.getUserId())) {
                if (this.projectPlanMap.get(userInfo.getUserId()).containsKey(sd.getPrj_code())) {
                    double totalWorkTime = this.projectPlanMap.get(userInfo.getUserId()).get(sd.getPrj_code());
                    this.projectPlanMap.get(userInfo.getUserId()).put(sd.getPrj_code(), totalWorkTime += sd.getTimeByHour());
                } else {
                    this.projectPlanMap.get(userInfo.getUserId()).put(sd.getPrj_code(), sd.getTimeByHour());
                }
            } else {
                HashMap<String, Double> projectMap = new HashMap<String, Double>();
                projectMap.put(sd.getPrj_code(), sd.getTimeByHour());
                this.projectPlanMap.put(userInfo.getUserId(), projectMap);
            }
            double wkPlan = this.workTimePlanMap.get(userInfo.getUserId()) + sd.getTimeByHour();
            this.workTimePlanMap.put(userInfo.getUserId(), wkPlan);
            if (sd.getPrj_code().equals(this.outOfWorkProjectCode)) {
                this.outOfWorkTimePlanMap.put(userInfo.getUserId(), this.outOfWorkTimePlanMap.get(userInfo.getUserId()) + sd.getTimeByHour());
            }
        }
    }

    private void analyseOverTime(YyyyMmHolder targetYyyyMm, UserInfo userInfo, DateInfo todayDi, HolidayInfo holidayInfo, Calendar cal) {
        int dayOfMonth = cal.getActualMaximum(5);
        int workDaysOfMonth = 0;
        int dayth = 1;
        while (dayth <= dayOfMonth) {
            double totalOverWorkTime;
            DateInfo di = new DateInfo();
            di.setYyyy(targetYyyyMm.getYyyy());
            di.setMm(targetYyyyMm.getMm());
            di.setDd(Integer.toString(dayth));
            di.setHH("23");
            di.setMM("59");
            double overWorkTime = 0.0;
            double workTimeOfDay = 0.0;
            if (this.ddWorkTime.containsKey(di.getDd())) {
                workTimeOfDay = this.ddWorkTime.get(di.getDd());
            }
            if (holidayInfo.isHoliday(di.getYyyy(), di.getMm(), di.getDd())) {
                overWorkTime = workTimeOfDay;
            } else {
                ++workDaysOfMonth;
                overWorkTime = workTimeOfDay - this.standardWorkTimeOfDay;
            }
            if (di.compareDateInfo(todayDi) == -1) {
                if (this.overTimeResultMap.containsKey(userInfo.getUserId())) {
                    totalOverWorkTime = this.overTimeResultMap.get(userInfo.getUserId());
                    this.overTimeResultMap.put(userInfo.getUserId(), totalOverWorkTime + overWorkTime);
                } else {
                    this.overTimeResultMap.put(userInfo.getUserId(), overWorkTime);
                }
            } else if (this.overTimePlanMap.containsKey(userInfo.getUserId())) {
                totalOverWorkTime = this.overTimePlanMap.get(userInfo.getUserId());
                this.overTimePlanMap.put(userInfo.getUserId(), totalOverWorkTime + overWorkTime);
            } else {
                this.overTimePlanMap.put(userInfo.getUserId(), overWorkTime);
            }
            ++dayth;
        }
        this.workDaysOfMonth = workDaysOfMonth;
    }

    public String[] createJTableContentsHeader() {
        String[] result = new String[]{"\u9805\u756a", "\u30e6\u30fc\u30b6ID", "\u9805\u76ee", "\u5b9f\u7e3e(h)", "\u4e88\u5b9a(h)", "\u8a08(h)", "\u5b9f\u7e3e(\u4eba\u6708)", "\u4e88\u5b9a(\u4eba\u6708)", "\u8a08(\u4eba\u6708)"};
        return result;
    }

    public ArrayList<ManHourOneData> createManHourDataList() {
        ArrayList<ManHourOneData> manHourDataList = new ArrayList<ManHourOneData>();
        double workTimeResult = 0.0;
        double workTimePlan = 0.0;
        double overTimeResult = 0.0;
        double overTimePlan = 0.0;
        double projectResult = 0.0;
        double projectPlan = 0.0;
        int rowCount = 0;
        Iterator<UserInfo> i = this.userInfoList.iterator();
        while (i.hasNext()) {
            String userId = i.next().getUserId();
            workTimeResult = this.workTimeResultMap.get(userId);
            workTimePlan = this.workTimePlanMap.get(userId);
            manHourDataList.add(this.makeWorkTimeRecord(rowCount, userId, workTimeResult, workTimePlan));
            overTimeResult = this.overTimeResultMap.get(userId);
            overTimePlan = this.overTimePlanMap.get(userId);
            manHourDataList.add(this.makeOverTimeRecord(++rowCount, userId, overTimeResult, overTimePlan));
            ++rowCount;
            Set<String> projectCodeList = this.projectCodeMapMap.get(userId).keySet();
            for (String projectCode : projectCodeList) {
                String projectUnitName = this.projectCodeMapMap.get(userId).get(projectCode);
                projectResult = this.projectResultMap.get(userId).containsKey(projectCode) ? this.projectResultMap.get(userId).get(projectCode) : 0.0;
                projectPlan = this.projectPlanMap.get(userId).containsKey(projectCode) ? this.projectPlanMap.get(userId).get(projectCode) : 0.0;
                boolean outOfWorkTimeFlag = false;
                if (projectCode.equals(this.outOfWorkProjectCode)) {
                    outOfWorkTimeFlag = true;
                }
                double outOfWorkTimeTotal = this.outOfWorkTimeResultMap.get(userId) + this.outOfWorkTimePlanMap.get(userId);
                String projectCodeName = this.projectUnitList.getProjectUnit(projectUnitName).getProjectItems().getProjectCodeName(projectCode);
                manHourDataList.add(this.makeProjectCodeRecord(rowCount, userId, projectCodeName, projectResult, projectPlan, workTimeResult + workTimePlan, outOfWorkTimeTotal, outOfWorkTimeFlag));
                ++rowCount;
            }
        }
        return manHourDataList;
    }

    private ManHourOneData makeProjectCodeRecord(int rowCount, String userId, String projectCode, double projectResult, double projectPlan, double workTimeTotal, double outOfWorkTimeTotal, boolean outOfWorkTimeFlag) {
        ManHourOneData manHourOneData;
        if (outOfWorkTimeFlag) {
            manHourOneData = new ManHourOneData(userId, projectCode, Double.toString(projectResult), Double.toString(projectPlan), "-", "-");
        } else {
            double workTime = workTimeTotal - outOfWorkTimeTotal;
            manHourOneData = new ManHourOneData(userId, projectCode, Double.toString(projectResult), Double.toString(projectPlan), Double.toString(projectResult / workTime), Double.toString(projectPlan / workTime));
        }
        return manHourOneData;
    }

    private ManHourOneData makeOverTimeRecord(int rowCount, String userId, double overTimeResult, double overTimePlan) {
        ManHourOneData manHourOneData = new ManHourOneData(userId, "\u6642\u9593\u5916", Double.toString(overTimeResult), Double.toString(overTimePlan), "-", "-");
        return manHourOneData;
    }

    private ManHourOneData makeWorkTimeRecord(int rowCount, String userId, double workTimeResult, double workTimePlan) {
        ManHourOneData manHourOneData = new ManHourOneData(userId, "\u7a3c\u52d5\u6642\u9593", Double.toString(workTimeResult), Double.toString(workTimePlan), "-", "-");
        return manHourOneData;
    }

    public void printProjectCodeMapList() {
        System.out.println("----> printProjectCodeMapList " + this.getClass().toString());
        Set<String> userIdList = this.projectCodeMapMap.keySet();
        int userIdCount = 0;
        for (String userId : userIdList) {
            int projectCodeCount = 0;
            Set<String> projectCodeList = this.projectCodeMapMap.get(userId).keySet();
            for (String projectCode : projectCodeList) {
                System.out.println("[" + userIdCount + "][" + projectCodeCount + "] " + userId + "," + projectCode);
                ++projectCodeCount;
            }
            ++userIdCount;
        }
    }

    public int getWorkDaysOfMonth() {
        return this.workDaysOfMonth;
    }

    public double getStandardWorkTime() {
        return (double)this.workDaysOfMonth * this.standardWorkTimeOfDay;
    }
}

