/*
 * Decompiled with CFR 0.152.
 */
package mtroom;

import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import mtroom.Reservation;
import mtroom.ReservationComparator;
import org.apache.commons.lang.time.DateUtils;

public class ReservationList {
    private TreeSet<Reservation> rList = new TreeSet(new ReservationComparator());

    public TreeSet<Reservation> getRList() {
        return this.rList;
    }

    public void add(Reservation r) {
        this.rList.add(r);
    }

    public void add(ReservationList rl) {
        this.rList.addAll(rl.getRList());
    }

    public void remove(Reservation r) {
        this.rList.remove(r);
    }

    public void remove(ReservationList rl) {
        this.rList.removeAll(rl.getRList());
    }

    public int size() {
        return this.rList.size();
    }

    public ReservationList getReservationByRoom(String room) {
        ReservationList rl = new ReservationList();
        for (Reservation r : this.rList) {
            if (r.getPlace() == null || !r.getPlace().equals(room)) continue;
            rl.add(r);
        }
        return rl;
    }

    public void print() {
        Iterator<Reservation> rIterator = this.rList.iterator();
        while (rIterator.hasNext()) {
            System.out.println(rIterator.next());
        }
    }

    public boolean isReserved(String room, Date datetime) {
        for (Reservation r : this.getReservationByRoom(room).getRList()) {
            if (!DateUtils.isSameDay(datetime, r.getDate())) continue;
            long reserved_time1_min = DateUtils.getFragmentInMinutes(r.getTime1DateTime(), 5);
            long reserved_time2_min = DateUtils.getFragmentInMinutes(r.getTime2DateTime(), 5);
            long minute = DateUtils.getFragmentInMinutes(datetime, 5);
            if (minute < reserved_time1_min || minute >= reserved_time2_min) continue;
            return true;
        }
        return false;
    }

    public boolean isReserved(String room, Date date, Date timefrom, Date timeto) {
        long from_mins = DateUtils.getFragmentInMinutes(timefrom, 5);
        long to_mins = DateUtils.getFragmentInMinutes(timeto, 5);
        Date datetime = DateUtils.addMinutes(DateUtils.truncate(date, 5), (int)from_mins);
        long count = (to_mins - from_mins) / 30L;
        int i = 0;
        while ((long)i < count) {
            if (this.isReserved(room, datetime)) {
                return true;
            }
            datetime = DateUtils.addMinutes(datetime, 30);
            ++i;
        }
        return false;
    }
}

