/*
 * Decompiled with CFR 0.152.
 */
package scheduleData;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateInfo
implements Cloneable {
    public static final int SAME_DATE = 0;
    public static final int LARGE_DATE = 1;
    public static final int SMALL_DATE = -1;
    public static final int NOT_APPLICABLE = -2;
    private String yyyy = "";
    private String mm = "";
    private String dd = "";
    private String HH = "";
    private String MM = "";

    public DateInfo(String w_yyyy, String w_mm, String w_dd, String w_HH, String w_MM) {
        this.yyyy = new String(w_yyyy);
        this.mm = new String(w_mm);
        this.dd = new String(w_dd);
        this.HH = new String(w_HH);
        this.MM = new String(w_MM);
    }

    public DateInfo() {
        Date now_date = new Date();
        SimpleDateFormat sd_yyyy = new SimpleDateFormat("yyyy");
        SimpleDateFormat sd_mm = new SimpleDateFormat("MM");
        SimpleDateFormat sd_dd = new SimpleDateFormat("dd");
        SimpleDateFormat sd_HH = new SimpleDateFormat("HH");
        SimpleDateFormat sd_MM = new SimpleDateFormat("mm");
        this.yyyy = sd_yyyy.format(now_date);
        this.mm = sd_mm.format(now_date);
        this.dd = sd_dd.format(now_date);
        this.HH = sd_HH.format(now_date);
        this.MM = sd_MM.format(now_date);
    }

    public Object clone() {
        DateInfo di = new DateInfo();
        di.yyyy = new String(this.yyyy);
        di.mm = new String(this.mm);
        di.dd = new String(this.dd);
        di.HH = new String(this.HH);
        di.MM = new String(this.MM);
        return di;
    }

    public String getDow() {
        Calendar cal1 = Calendar.getInstance();
        cal1.set(1, Integer.valueOf(this.yyyy));
        cal1.set(2, Integer.valueOf(this.mm) - 1);
        cal1.set(5, Integer.valueOf(this.dd));
        StringBuffer dow = new StringBuffer();
        switch (cal1.get(7)) {
            case 1: {
                dow.append("\u65e5");
                break;
            }
            case 2: {
                dow.append("\u6708");
                break;
            }
            case 3: {
                dow.append("\u706b");
                break;
            }
            case 4: {
                dow.append("\u6c34");
                break;
            }
            case 5: {
                dow.append("\u6728");
                break;
            }
            case 6: {
                dow.append("\u91d1");
                break;
            }
            case 7: {
                dow.append("\u571f");
            }
        }
        return dow.toString();
    }

    public String getYyyy() {
        return this.yyyy;
    }

    public void setYyyy(String yyyy) {
        this.yyyy = String.format("%04d", Integer.valueOf(yyyy));
    }

    public String getMm() {
        return this.mm;
    }

    public void setMm(String mm) {
        this.mm = String.format("%02d", Integer.valueOf(mm));
    }

    public String getDd() {
        return this.dd;
    }

    public void setDd(String dd) {
        this.dd = String.format("%02d", Integer.valueOf(dd));
    }

    public String getHH() {
        return this.HH;
    }

    public void setHH(String hh) {
        this.HH = String.format("%02d", Integer.valueOf(hh));
    }

    public String getMM() {
        return this.MM;
    }

    public void setMM(String mm) {
        this.MM = String.format("%02d", Integer.valueOf(mm));
    }

    public void clear() {
        this.yyyy = "";
        this.mm = "";
        this.dd = "";
        this.HH = "";
        this.MM = "";
    }

    public boolean compare(DateInfo di) {
        return this.getYyyy().equals(di.getYyyy()) && this.getMm().equals(di.getMm()) && this.getDd().equals(di.getDd()) && this.getHH().equals(di.getHH()) && this.getMM().equals(di.getMM());
    }

    public String createDateInfoKey() {
        String str = String.valueOf(this.yyyy) + this.mm + this.dd + this.HH + this.MM;
        return str;
    }

    public void incrementMm() {
        int wkYyyy = Integer.valueOf(this.getYyyy());
        int wkMm = Integer.valueOf(this.getMm());
        if (wkMm < 12) {
            ++wkMm;
        } else {
            ++wkYyyy;
            wkMm = 1;
        }
        this.setYyyy(Integer.toString(wkYyyy));
        this.setMm(Integer.toString(wkMm));
        int daysMonth = 0;
        daysMonth = this.getMaxDays(this.getYyyy(), this.getMm());
        if (daysMonth <= Integer.valueOf(this.getDd())) {
            this.setDd(Integer.toString(daysMonth));
        }
    }

    public void addHH(String hH) {
        int wkHH1 = Integer.valueOf(hH);
        int wkHH2 = Integer.valueOf(this.getHH());
        this.setHH(Integer.toString(wkHH1 + wkHH2));
    }

    public void addMM(String mM) {
        int wkMM1 = Integer.valueOf(mM);
        int wkMM2 = Integer.valueOf(this.getMM());
        int wkMM3 = wkMM1 + wkMM2;
        int wkHH = wkMM3 / 60;
        int wkMM4 = wkMM3 % 60;
        this.addHH(Integer.toString(wkHH));
        this.setMM(Integer.toString(wkMM4));
    }

    public void addDd(String dd) {
        int wkDd = Integer.valueOf(dd);
        int wkDd2 = Integer.valueOf(this.getDd()) + wkDd;
        int monthMax = this.getMaxDays(this.getYyyy(), this.getMm());
        if (monthMax < wkDd2) {
            this.incrementMm();
            this.setDd(Integer.toString(wkDd2 - monthMax));
        } else {
            this.setDd(Integer.toString(wkDd2));
        }
    }

    public int getTimeOfMinute() {
        int wkHH = Integer.valueOf(this.getYyyy());
        int result = wkHH + Integer.valueOf(this.getMM());
        return result;
    }

    private int getMaxDays(String yyyy, String mm) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.valueOf(yyyy));
        cal.set(2, Integer.valueOf(mm) - 1);
        return cal.getActualMaximum(5);
    }

    public boolean checkSameAll(DateInfo di) {
        boolean result = false;
        if (this.yyyy.equals(di.yyyy) && this.mm.equals(di.mm) && this.dd.equals(di.dd) && this.HH.equals(di.HH) && this.MM.equals(di.MM)) {
            result = true;
        }
        return result;
    }

    public boolean checkSameDay(DateInfo di) {
        boolean result = false;
        if (this.yyyy.equals(di.yyyy) && this.mm.equals(di.mm) && this.dd.equals(di.dd)) {
            result = true;
        }
        return result;
    }

    public int compareDateInfo(DateInfo di) {
        try {
            Calendar cal1 = Calendar.getInstance();
            cal1.set(Integer.valueOf(this.yyyy), Integer.valueOf(this.mm), Integer.valueOf(this.dd), Integer.valueOf(this.HH), Integer.valueOf(this.MM));
            Date mySelf = cal1.getTime();
            Calendar cal2 = Calendar.getInstance();
            cal2.set(Integer.valueOf(di.yyyy), Integer.valueOf(di.mm), Integer.valueOf(di.dd), Integer.valueOf(di.HH), Integer.valueOf(di.MM));
            Date comp = cal2.getTime();
            return mySelf.compareTo(comp);
        }
        catch (Exception numberFoException) {
            return -2;
        }
    }

    public int compareDateInfo3(DateInfo di) {
        char[] mySelf = this.createDateInfoKey().toCharArray();
        char[] target = di.createDateInfoKey().toCharArray();
        int i = 0;
        while (i < mySelf.length) {
            int targetInt;
            int mySelfInt = mySelf[i];
            if (mySelfInt < (targetInt = Integer.valueOf(target[i]).intValue())) {
                return -1;
            }
            if (mySelfInt > targetInt) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int compareDateInfo2(DateInfo di) {
        double targetYyyyMmDd;
        double mySelfYyyyMmDd = Double.valueOf(this.yyyy) * 365.0 + Double.valueOf(this.mm) * 31.0 + Double.valueOf(this.dd);
        if (mySelfYyyyMmDd == (targetYyyyMmDd = Double.valueOf(di.getYyyy()) * 365.0 + Double.valueOf(di.getMm()) * 31.0 + Double.valueOf(di.getDd()))) {
            return this.compareDateInfoHHMM(di);
        }
        if (mySelfYyyyMmDd < targetYyyyMmDd) {
            return -1;
        }
        if (mySelfYyyyMmDd > targetYyyyMmDd) {
            return 1;
        }
        return -2;
    }

    private int compareDateInfoHHMM(DateInfo di) {
        double targetHHMM;
        double mySelfHHMM = Double.valueOf(this.HH) * 60.0 + Double.valueOf(this.MM);
        if (mySelfHHMM < (targetHHMM = Double.valueOf(di.getHH()) * 60.0 + Double.valueOf(di.getMM()))) {
            return -1;
        }
        if (mySelfHHMM > targetHHMM) {
            return 1;
        }
        if (mySelfHHMM == targetHHMM) {
            return 0;
        }
        return -2;
    }

    public void increment30minWithRoundUp() {
        if (Integer.valueOf(this.getMM()) < 30) {
            this.setMM("30");
        } else {
            this.setMM("00");
            if (Integer.valueOf(this.getHH()) < 23) {
                this.setHH(Integer.toString(Integer.valueOf(this.getHH()) + 1));
            } else {
                this.setHH("00");
            }
        }
    }

    public void drop30min() {
        if (Integer.valueOf(this.getMM()) < 30) {
            this.setMM("00");
        } else {
            this.setMM("30");
        }
    }

    public boolean isSameDay(DateInfo di) {
        return this.getYyyy().equals(di.getYyyy()) && this.getMm().equals(di.getMm()) && this.getDd().equals(di.getDd());
    }

    public void printAll() {
        System.out.println(String.valueOf(this.getYyyy()) + this.getMm() + this.getDd() + this.getHH() + this.getMM());
    }

    public String createYyyyMmDdKey() {
        return String.valueOf(this.getYyyy()) + this.getMm() + this.getDd();
    }

    public String createYyyyMmDdBySlash() {
        if (this.getYyyy().equals("") || this.getMm().equals("") || this.getDd().equals("")) {
            return "N/A";
        }
        if (this.getYyyy().equals("0000") || this.getMm().equals("00") || this.getDd().equals("00")) {
            return "N/A";
        }
        return String.valueOf(this.getYyyy()) + "/" + this.getMm() + "/" + this.getDd();
    }
}

